/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixNestedBMOC;
import cds.moc.SMoc;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.OutputStreamParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.cone.ConeQueryRowSequence;
import uk.ac.starlink.ttools.cone.JELQuerySequenceFactory;
import uk.ac.starlink.ttools.cone.MocFormat;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.SkyCoordParameter;
import uk.ac.starlink.util.Destination;

public class MocMode
implements ProcessingMode {
    private final IntegerParameter orderParam_ = new IntegerParameter("order");
    private final StringParameter raParam_;
    private final StringParameter decParam_;
    private final StringParameter radiusParam_;
    private final ChoiceParameter<MocFormat> mocfmtParam_;
    private final OutputStreamParameter outParam_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.mode");
    public static final MocFormat FITS_FORMAT = new CdsMocFormat("fits"){

        @Override
        protected void doWrite(SMoc moc, OutputStream out) throws Exception {
            moc.writeFITS(out);
        }
    };
    public static final MocFormat JSON_FORMAT = new CdsMocFormat("json"){

        @Override
        protected void doWrite(SMoc moc, OutputStream out) throws Exception {
            moc.writeJSON(out);
        }
    };
    public static MocFormat ASCII_FORMAT = new CdsMocFormat("ascii"){

        @Override
        protected void doWrite(SMoc moc, OutputStream out) throws Exception {
            moc.writeASCII(out);
            out.write(10);
        }
    };
    private static MocFormat[] FORMATS = new MocFormat[]{FITS_FORMAT, JSON_FORMAT, ASCII_FORMAT};

    public MocMode() {
        this.orderParam_.setPrompt("MOC Healpix maximum order");
        this.orderParam_.setUsage("0..29");
        this.orderParam_.setMinimum(0);
        this.orderParam_.setMaximum(29);
        int orderDflt = 13;
        this.orderParam_.setIntDefault(orderDflt);
        int dfltResArcsec = (int)Math.round(3520.0 * Math.pow(2.0, -orderDflt) * 60.0);
        this.orderParam_.setDescription(new String[]{"<p>Maximum HEALPix order for the MOC.", "This defines the maximum resolution of the output coverage map.", "The angular resolution corresponding to order <em>k</em>", "is approximately 180/sqrt(3.Pi)/2^<em>k</em> degrees", "(3520*2^<em>-k</em> arcmin).", "Permitted values are 0..29 inclusive.", "The default value is " + orderDflt + ", which corresponds to", "about " + dfltResArcsec + " arcsec.", "</p>"});
        String system = null;
        String inDescrip = "the input table";
        this.raParam_ = SkyCoordParameter.createRaParameter("ra", system, inDescrip);
        this.decParam_ = SkyCoordParameter.createDecParameter("dec", system, inDescrip);
        this.radiusParam_ = new StringParameter("radius");
        this.radiusParam_.setUsage("<expr>");
        this.radiusParam_.setPrompt("Radius expression in degrees");
        this.radiusParam_.setDescription(new String[]{"<p>Expression which evaluates to the radius in degrees", "of the cone at each row of the input table.", "The default is \"<code>0</code>\",", "which treats each position as a point rather than a cone,", "but a constant or an expression as described in", "<ref id='jel'/> may be used instead.", "</p>"});
        this.radiusParam_.setStringDefault("0");
        this.mocfmtParam_ = new ChoiceParameter("mocfmt", MocFormat.class, (Object[])FORMATS);
        this.mocfmtParam_.setPrompt("Output format for MOC file");
        this.mocfmtParam_.setDescription(new String[]{"<p>Determines the output format for the MOC file.", "</p>"});
        this.mocfmtParam_.setDefaultOption((Object)FITS_FORMAT);
        this.outParam_ = new OutputStreamParameter("out");
        this.outParam_.setPreferExplicit(true);
        this.outParam_.setPrompt("Location of output MOC file");
    }

    @Override
    public Parameter<?>[] getAssociatedParameters() {
        return new Parameter[]{this.orderParam_, this.raParam_, this.decParam_, this.radiusParam_, this.mocfmtParam_, this.outParam_};
    }

    @Override
    public String getDescription() {
        return DocUtils.join(new String[]{"<p>Generates and outputs a Multi-Order Coverage map from", "the sky positions associated with the rows of the input table.", "</p>"});
    }

    @Override
    public TableConsumer createConsumer(Environment env) throws TaskException {
        String raString = this.raParam_.stringValue(env);
        String decString = this.decParam_.stringValue(env);
        String radiusString = this.radiusParam_.stringValue(env);
        final JELQuerySequenceFactory qsFact = new JELQuerySequenceFactory(raString, decString, radiusString);
        final int order = this.orderParam_.intValue(env);
        final MocFormat mocfmt = (MocFormat)this.mocfmtParam_.objectValue(env);
        final Destination dest = (Destination)this.outParam_.objectValue(env);
        return new TableConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void consume(StarTable table) throws IOException {
                SMoc moc;
                try (ConeQueryRowSequence qseq = qsFact.createQuerySequence(table);){
                    moc = MocMode.createMoc(order, qseq);
                }
                if (logger_.isLoggable(Level.INFO)) {
                    logger_.info("MOC: size=" + moc.getNbCoding() + ", coverage=" + moc.getCoverage());
                }
                try (OutputStream out = dest.createStream();){
                    mocfmt.writeMoc(moc, out);
                }
            }
        };
    }

    private static SMoc createMoc(int order, ConeQueryRowSequence qseq) throws IOException {
        SMoc moc;
        try {
            moc = new SMoc(order);
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error creating MOC (bad order " + order + "?)").initCause(e);
        }
        logger_.info("New MOC order=" + order + ", resolution=" + (float)moc.getAngularRes() + "deg");
        HealpixNested hpx = Healpix.getNested((int)order);
        moc.bufferOn();
        while (qseq.next()) {
            double raRad = Math.toRadians(qseq.getRa());
            double decRad = Math.toRadians(qseq.getDec());
            double radiusRad = Math.toRadians(qseq.getRadius());
            if (Double.isNaN(raRad) || !(decRad >= -1.5707963267948966) || !(decRad <= 1.5707963267948966) || !(radiusRad >= 0.0)) continue;
            HealpixNestedBMOC bmoc = hpx.newConeComputerApprox(radiusRad).overlappingCells(raRad, decRad);
            for (HealpixNestedBMOC.CurrentValueAccessor vac : bmoc) {
                try {
                    moc.add(vac.getDepth(), vac.getHash());
                }
                catch (Exception e) {
                    throw (IOException)new IOException("HEALPix/MOC error").initCause(e);
                }
            }
        }
        moc.bufferOff();
        return moc;
    }

    private static abstract class CdsMocFormat
    implements MocFormat {
        private final String name_;

        CdsMocFormat(String name) {
            this.name_ = name;
        }

        protected abstract void doWrite(SMoc var1, OutputStream var2) throws Exception;

        @Override
        public void writeMoc(SMoc moc, OutputStream out) throws IOException {
            try {
                this.doWrite(moc, out);
            }
            catch (Exception e) {
                throw (IOException)new IOException("MOC write error").initCause(e);
            }
        }

        public String toString() {
            return this.name_;
        }
    }
}

