/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.ttools.plot.DataColorTweaker;
import uk.ac.starlink.ttools.plot.Drawing;
import uk.ac.starlink.ttools.plot.Fogger;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.ttools.plot.Pixellator;
import uk.ac.starlink.ttools.plot.PlotVolume;
import uk.ac.starlink.ttools.plot.Point3D;
import uk.ac.starlink.util.LongList;

public class BitmapSortPlotVolume
extends PlotVolume {
    private PointStore pointStore_;
    private boolean seenLabels_;
    private final int xdim_;
    private final int ydim_;
    private final int xoff_;
    private final int yoff_;
    private final Pixellator[] markPixoffs_;
    private final MarkStyle[] styles_;
    private final float[][] rgbas_;
    private final float[][] labelRgbas_;
    private final float[][] rgbaBufs_;
    private final int[] rgbBuf_;
    private final BufferedImage image_;
    private final DataColorTweaker tweaker_;

    public BitmapSortPlotVolume(Component c, Graphics g, MarkStyle[] styles, double padFactor, int[] padBorders, double fogginess, boolean hasLabels, boolean hasErrors, double zmin, double zmax, DataColorTweaker tweaker, Workspace ws) {
        super(c, g, styles, padFactor, padBorders, fogginess);
        boolean hasAux;
        MarkStyle style;
        int is;
        this.styles_ = styles;
        int ppad = 2;
        for (int i = 0; i < styles.length; ++i) {
            ppad = Math.max(ppad, 2 + 2 * styles[i].getMaximumRadius());
        }
        this.xdim_ = c.getWidth() + 2 * ppad;
        this.ydim_ = c.getHeight() + 2 * ppad;
        this.xoff_ = -ppad;
        this.yoff_ = -ppad;
        ws.init(this.xdim_, this.ydim_);
        this.rgbaBufs_ = ws.rgbaBufs_;
        this.rgbBuf_ = ws.rgbBuf_;
        this.image_ = ws.image_;
        int nstyle = styles.length;
        this.markPixoffs_ = new Pixellator[nstyle];
        for (is = 0; is < nstyle; ++is) {
            style = styles[is];
            this.markPixoffs_[is] = style.getPixelOffsets();
        }
        this.rgbas_ = new float[nstyle][];
        this.labelRgbas_ = new float[nstyle][];
        for (is = 0; is < nstyle; ++is) {
            style = styles[is];
            this.rgbas_[is] = style.getColor().getRGBComponents(null);
            this.rgbas_[is][3] = 1.0f / (float)style.getOpaqueLimit();
            this.labelRgbas_[is] = style.getLabelColor().getRGBComponents(null);
            this.labelRgbas_[is][3] = 1.0f;
        }
        this.tweaker_ = tweaker;
        boolean bl = hasAux = tweaker != null;
        this.pointStore_ = hasAux ? new AuxObjectPointStore(this.rgbas_, tweaker) : (hasErrors || hasLabels ? new ObjectPointStore() : new PackedPointStore(zmin, zmax));
    }

    @Override
    public void plot2d(int px, int py, double z, double[] coords, int istyle, boolean showPoint, String label, int nerr, int[] xoffs, int[] yoffs, double[] zerrs) {
        this.pointStore_.addPoint(px, py, z, coords, istyle, showPoint, label, nerr, xoffs, yoffs);
        this.seenLabels_ = this.seenLabels_ || label != null;
    }

    @Override
    public void flush() {
        float[] rBuf = this.rgbaBufs_[0];
        float[] gBuf = this.rgbaBufs_[1];
        float[] bBuf = this.rgbaBufs_[2];
        float[] aBuf = this.rgbaBufs_[3];
        float[] b4 = new float[4];
        Fogger fogger = this.getFogger();
        Rectangle clip = this.getGraphics().getClipBounds();
        Iterator<BitmapPoint3D> it = this.pointStore_.getSortedPointIterator();
        while (it.hasNext()) {
            int is;
            MarkStyle style;
            Pixellator lpixoffs;
            String label;
            BitmapPoint3D point = it.next();
            double z = point.getZ();
            int base = point.getPixelBase(this);
            Pixellator pixoffs = point.getPixelOffsets(this);
            if (pixoffs != null) {
                float[] rgba = point.getRgba(this);
                pixoffs.start();
                while (pixoffs.next()) {
                    int ipix = base + pixoffs.getX() + this.xdim_ * pixoffs.getY();
                    float alpha = aBuf[ipix];
                    if (!(alpha < 1.0f)) continue;
                    b4[0] = rgba[0];
                    b4[1] = rgba[1];
                    b4[2] = rgba[2];
                    b4[3] = rgba[3];
                    fogger.fogAt(z, b4);
                    float remain = 1.0f - alpha;
                    float weight = Math.min(remain, rgba[3]);
                    int n = ipix;
                    aBuf[n] = aBuf[n] + weight * 1.0f;
                    int n2 = ipix;
                    rBuf[n2] = rBuf[n2] + weight * b4[0];
                    int n3 = ipix;
                    gBuf[n3] = gBuf[n3] + weight * b4[1];
                    int n4 = ipix;
                    bBuf[n4] = bBuf[n4] + weight * b4[2];
                }
            }
            if ((label = point.getLabel()) == null || (lpixoffs = (style = this.styles_[is = point.istyle_]).getLabelPixels(label, point.px_ - this.xoff_, point.py_ - this.yoff_, clip)) == null) continue;
            float[] rgba = this.labelRgbas_[is];
            lpixoffs.start();
            while (lpixoffs.next()) {
                int ipix = lpixoffs.getX() + this.xdim_ * lpixoffs.getY();
                float alpha = aBuf[ipix];
                if (!(alpha < 1.0f)) continue;
                b4[0] = rgba[0];
                b4[1] = rgba[1];
                b4[2] = rgba[2];
                b4[3] = rgba[3];
                fogger.fogAt(z, b4);
                float remain = 1.0f - alpha;
                float weight = Math.min(remain, rgba[3]);
                int n = ipix;
                aBuf[n] = aBuf[n] + weight * 1.0f;
                int n5 = ipix;
                rBuf[n5] = rBuf[n5] + weight * b4[0];
                int n6 = ipix;
                gBuf[n6] = gBuf[n6] + weight * b4[1];
                int n7 = ipix;
                bBuf[n7] = bBuf[n7] + weight * b4[2];
            }
        }
        ColorModel colorModel = this.image_.getColorModel();
        float[] rgba = new float[4];
        Arrays.fill(this.rgbBuf_, colorModel.getDataElement(rgba, 0));
        int npix = this.xdim_ * this.ydim_;
        for (int ipix = 0; ipix < npix; ++ipix) {
            float a = aBuf[ipix];
            if (!(a > 0.0f)) continue;
            float a1 = 1.0f / aBuf[ipix];
            rgba[0] = rBuf[ipix] * a1;
            rgba[1] = gBuf[ipix] * a1;
            rgba[2] = bBuf[ipix] * a1;
            rgba[3] = a;
            this.rgbBuf_[ipix] = colorModel.getDataElement(rgba, 0);
        }
        this.image_.setRGB(0, 0, this.xdim_, this.ydim_, this.rgbBuf_, 0, this.xdim_);
        this.getGraphics().drawImage(this.image_, this.xoff_, this.yoff_, null);
    }

    public static class Workspace {
        private int xdim_ = -1;
        private int ydim_ = -1;
        private float[][] rgbaBufs_;
        private int[] rgbBuf_;
        private BufferedImage image_;

        private void init(int xdim, int ydim) {
            if (xdim == this.xdim_ && ydim == this.ydim_) {
                for (int i = 0; i < 4; ++i) {
                    Arrays.fill(this.rgbaBufs_[i], 0.0f);
                }
                Arrays.fill(this.rgbBuf_, 0);
            } else {
                this.xdim_ = xdim;
                this.ydim_ = ydim;
                int npix = xdim * ydim;
                this.rgbaBufs_ = new float[4][npix];
                this.rgbBuf_ = new int[npix];
                this.image_ = new BufferedImage(xdim, ydim, 2);
            }
        }
    }

    private static class ExtrasBitmapPoint3D
    extends BitmapPoint3D {
        final boolean showPoint_;
        final String label_;
        final int nerr_;
        final int[] xoffs_;
        final int[] yoffs_;
        private static final int[] NO_OFFSETS = new int[0];

        public ExtrasBitmapPoint3D(int iseq, double z, int istyle, int px, int py, boolean showPoint, String label, int nerr, int[] xoffs, int[] yoffs) {
            super(iseq, z, istyle, px, py);
            this.showPoint_ = showPoint;
            this.label_ = label;
            this.nerr_ = nerr;
            this.xoffs_ = nerr > 0 ? (int[])xoffs.clone() : null;
            this.yoffs_ = nerr > 0 ? (int[])yoffs.clone() : null;
        }

        @Override
        public Pixellator getPixelOffsets(BitmapSortPlotVolume vol) {
            Rectangle clip = vol.getGraphics().getClipBounds();
            clip.translate(-this.px_, -this.py_);
            if (this.nerr_ > 0) {
                Pixellator ePixer = vol.getStyles()[this.istyle_].getErrorRenderer().getPixels(clip, 0, 0, this.xoffs_, this.yoffs_);
                return this.showPoint_ ? Drawing.combinePixellators(new Pixellator[]{vol.markPixoffs_[this.istyle_], ePixer}) : ePixer;
            }
            return this.showPoint_ ? vol.markPixoffs_[this.istyle_] : null;
        }

        @Override
        public String getLabel() {
            return this.label_;
        }
    }

    private static class BitmapPoint3D
    extends Point3D {
        final int istyle_;
        final int px_;
        final int py_;

        public BitmapPoint3D(int iseq, double z, int istyle, int px, int py) {
            super(iseq, z);
            this.istyle_ = istyle;
            this.px_ = px;
            this.py_ = py;
        }

        public int getPixelBase(BitmapSortPlotVolume vol) {
            int ix = this.px_ - vol.xoff_;
            int iy = this.py_ - vol.yoff_;
            return ix + iy * vol.xdim_;
        }

        public Pixellator getPixelOffsets(BitmapSortPlotVolume vol) {
            return vol.markPixoffs_[this.istyle_];
        }

        public float[] getRgba(BitmapSortPlotVolume vol) {
            return vol.rgbas_[this.istyle_];
        }

        public String getLabel() {
            return null;
        }
    }

    private static class PackedPointStore
    extends PointStore {
        private LongList pointList_ = new LongList();
        private final double zmin_;
        private final double zmax_;
        private final double zmult_;
        private static final int TWO12 = 8192;

        PackedPointStore(double zmin, double zmax) {
            this.zmax_ = zmax;
            this.zmin_ = zmin;
            this.zmult_ = 2.147483647E9 / (zmax - zmin);
        }

        @Override
        public void addPoint(int px, int py, double z, double[] coords, int istyle, boolean showPoint, String label, int nerr, int[] xoffs, int[] yoffs) {
            if (nerr > 0 || label != null) {
                throw new UnsupportedOperationException("No errors or labels");
            }
            if (showPoint) {
                if (z > this.zmin_ && z <= this.zmax_ && px >= 0 && px <= 8192 && py >= 0 && py <= 8192) {
                    this.pointList_.add(this.pack(px, py, z, istyle));
                }
            } else assert (false) : "pointless";
        }

        @Override
        public Iterator<BitmapPoint3D> getSortedPointIterator() {
            final long[] points = this.pointList_.toLongArray();
            this.pointList_ = new LongList();
            Arrays.sort(points);
            return new Iterator<BitmapPoint3D>(){
                int ip;

                @Override
                public boolean hasNext() {
                    return this.ip < points.length;
                }

                @Override
                public BitmapPoint3D next() {
                    long packed = points[this.ip++];
                    double z = this.unpackZ(packed);
                    int px = this.unpackX(packed);
                    int py = this.unpackY(packed);
                    int istyle = this.unpackStyleIndex(packed);
                    return new BitmapPoint3D(-1, z, istyle, px, py);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private long pack(int xp, int yp, double z, int is) {
            long zint = (long)((z - this.zmin_) * this.zmult_);
            assert (zint >= 0L && zint <= Integer.MAX_VALUE);
            assert (xp >= 0 && xp < 8192);
            assert (yp >= 0 && yp < 8192);
            long mis = 255 - is;
            return zint << 32 | mis << 24 | (long)(xp << 12) | (long)(yp << 0);
        }

        private double unpackZ(long val) {
            int zint = (int)(val >> 32);
            double z = (double)zint / this.zmult_ + this.zmin_;
            assert (z >= this.zmin_ && z <= this.zmax_);
            return z;
        }

        private int unpackStyleIndex(long val) {
            int mis = (int)(val >> 24 & 0xFFL);
            assert (mis >= 0);
            return 255 - mis;
        }

        private int unpackX(long val) {
            int xp = (int)val >> 12 & 0xFFF;
            assert (xp >= 0 && xp < 8192);
            return xp;
        }

        private int unpackY(long val) {
            int yp = (int)val >> 0 & 0xFFF;
            assert (yp >= 0 && yp < 8192);
            return yp;
        }
    }

    private static class AuxObjectPointStore
    extends ObjectPointStore {
        private final DataColorTweaker tweaker_;
        private final float[][] rgbas_;
        private final float[] buf_;

        public AuxObjectPointStore(float[][] rgbas, DataColorTweaker tweaker) {
            this.tweaker_ = tweaker;
            this.rgbas_ = rgbas;
            this.buf_ = new float[4];
        }

        @Override
        public void addPoint(int px, int py, double z, double[] coords, int istyle, boolean showPoint, String label, int nerr, int[] xoffs, int[] yoffs) {
            float[] rgbaBuf = this.getRgba(istyle, coords);
            if (rgbaBuf != null) {
                BitmapPoint3D p3;
                final int rgba = PlotVolume.packRgba(rgbaBuf);
                int np = this.pointList_.size();
                if (nerr > 0 || label != null) {
                    p3 = new ExtrasBitmapPoint3D(np, z, istyle, px, py, showPoint, label, nerr, xoffs, yoffs){

                        @Override
                        public float[] getRgba(BitmapSortPlotVolume vol) {
                            PlotVolume.unpackRgba(rgba, buf_);
                            return buf_;
                        }
                    };
                } else if (showPoint) {
                    p3 = new BitmapPoint3D(np, z, istyle, px, py){

                        @Override
                        public float[] getRgba(BitmapSortPlotVolume vol) {
                            PlotVolume.unpackRgba(rgba, buf_);
                            return buf_;
                        }
                    };
                } else {
                    assert (false) : "pointless call";
                    p3 = null;
                }
                if (p3 != null) {
                    this.pointList_.add(p3);
                }
            }
        }

        private float[] getRgba(int istyle, double[] coords) {
            if (this.tweaker_.setCoords(coords)) {
                float[] rgba = this.rgbas_[istyle];
                this.buf_[0] = rgba[0];
                this.buf_[1] = rgba[1];
                this.buf_[2] = rgba[2];
                this.buf_[3] = rgba[3];
                this.tweaker_.tweakColor(this.buf_);
                return this.buf_;
            }
            return null;
        }
    }

    private static class ObjectPointStore
    extends PointStore {
        List<BitmapPoint3D> pointList_ = new ArrayList<BitmapPoint3D>();

        private ObjectPointStore() {
        }

        @Override
        public void addPoint(int px, int py, double z, double[] coords, int istyle, boolean showPoint, String label, int nerr, int[] xoffs, int[] yoffs) {
            BitmapPoint3D p3;
            int np = this.pointList_.size();
            if (nerr > 0 || label != null) {
                p3 = new ExtrasBitmapPoint3D(np, z, istyle, px, py, showPoint, label, nerr, xoffs, yoffs);
            } else if (showPoint) {
                p3 = new BitmapPoint3D(np, z, istyle, px, py);
            } else {
                p3 = null;
                assert (false) : "pointless call";
            }
            if (p3 != null) {
                this.pointList_.add(p3);
            }
        }

        @Override
        public Iterator<BitmapPoint3D> getSortedPointIterator() {
            BitmapPoint3D[] points = this.pointList_.toArray(new BitmapPoint3D[0]);
            this.pointList_ = new ArrayList<BitmapPoint3D>();
            Arrays.sort(points, Point3D.getComparator(true, false));
            return Arrays.asList(points).iterator();
        }
    }

    private static abstract class PointStore {
        private PointStore() {
        }

        public abstract void addPoint(int var1, int var2, double var3, double[] var5, int var6, boolean var7, String var8, int var9, int[] var10, int[] var11);

        public abstract Iterator<BitmapPoint3D> getSortedPointIterator();
    }
}

