/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

public class Corner
implements Comparable<Corner> {
    private final int index_;
    private static final int NDIM = 3;
    public static final int COUNT = 8;
    private static final Corner[] CORNERS = new Corner[8];
    public static final Corner ORIGIN;

    private Corner(int index) {
        this.index_ = index;
    }

    public Corner[] getAdjacent() {
        Corner[] adj = new Corner[3];
        for (int idim = 0; idim < 3; ++idim) {
            boolean[] flags = this.getFlags();
            flags[idim] = !flags[idim];
            adj[idim] = Corner.getCorner(Corner.getIndex(flags));
        }
        return adj;
    }

    public boolean[] getFlags() {
        boolean[] flags = new boolean[3];
        for (int idim = 0; idim < 3; ++idim) {
            flags[idim] = (this.index_ & 1 << idim) > 0;
        }
        return flags;
    }

    public static Corner getCorner(int index) {
        return CORNERS[index];
    }

    private static int getIndex(boolean[] flags) {
        int index = 0;
        for (int idim = 0; idim < 3; ++idim) {
            index += (flags[idim] ? 1 : 0) << idim;
        }
        return index;
    }

    public boolean equals(Object other) {
        return other instanceof Corner && ((Corner)other).index_ == this.index_;
    }

    public int hashCode() {
        return this.index_;
    }

    public String toString() {
        boolean[] flags = this.getFlags();
        return this.index_ + ": " + (flags[0] ? 1 : 0) + (flags[1] ? 1 : 0) + (flags[2] ? 1 : 0);
    }

    @Override
    public int compareTo(Corner other) {
        int oIndex = other.index_;
        if (this.index_ < oIndex) {
            return -1;
        }
        if (this.index_ > oIndex) {
            return 1;
        }
        return 0;
    }

    static {
        for (int i = 0; i < 8; ++i) {
            Corner.CORNERS[i] = new Corner(i);
        }
        ORIGIN = Corner.getCorner(0);
    }
}

