/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultFontMapper;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ExternalFontMapper
extends DefaultFontMapper {
    private final Set<String> registeredFonts_;
    private final Map<String, BaseFont> fontMap_ = new HashMap<String, BaseFont>();
    private static final Pattern FONTPATH_REGEX = Pattern.compile("^.*[:/\\\\](.*)\\.ttf");
    private static final String CHARSET = "UTF-8";
    private static final Logger logger_ = Logger.getLogger(ExternalFontMapper.class.getName());

    public ExternalFontMapper(String[] fontLocations) {
        this.registeredFonts_ = new HashSet<String>();
        for (int il = 0; il < fontLocations.length; ++il) {
            String loc = fontLocations[il];
            Matcher matcher = FONTPATH_REGEX.matcher(loc);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Not a TTF font path: " + loc);
            }
            String fname = matcher.group(1);
            FontFactory.register(loc);
            this.registeredFonts_.add(fname);
        }
    }

    @Override
    public BaseFont awtToPdf(Font font) {
        String fname = font.getFontName();
        if (!this.fontMap_.containsKey(fname)) {
            BaseFont baseFont;
            if (this.registeredFonts_.contains(fname)) {
                BaseFont bf;
                com.lowagie.text.Font itextFont = FontFactory.getFont(fname);
                BaseFont baseFont2 = bf = itextFont == null ? null : itextFont.getBaseFont();
                if (bf == null) {
                    logger_.warning("Failed to get registered font " + fname);
                    bf = super.awtToPdf(font);
                } else {
                    logger_.config("Embedding registered PDF font " + fname);
                }
                baseFont = bf;
            } else {
                logger_.config("Embedding default PDF font " + fname);
                baseFont = super.awtToPdf(font);
            }
            this.fontMap_.put(fname, baseFont);
        }
        return this.fontMap_.get(fname);
    }

    public static ExternalFontMapper createMapperFromResourcePaths(String[] paths) {
        ArrayList<String> resourceList = new ArrayList<String>();
        Class<ExternalFontMapper> clazz = ExternalFontMapper.class;
        for (int ip = 0; ip < paths.length; ++ip) {
            URL url = clazz.getResource(paths[ip]);
            if (url == null) continue;
            resourceList.add(url.toString());
        }
        return new ExternalFontMapper(resourceList.toArray(new String[0]));
    }

    public static ExternalFontMapper createMapperFromResourceList(InputStream in) throws IOException {
        return ExternalFontMapper.createMapperFromResourcePaths(ExternalFontMapper.readLines(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readLines(InputStream in) throws IOException {
        ArrayList<String> lineList = new ArrayList<String>();
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader(in, CHARSET));){
            String line;
            while ((line = rdr.readLine()) != null) {
                lineList.add(line);
            }
        }
        return lineList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(String[] lines, OutputStream out) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, CHARSET));){
            for (int il = 0; il < lines.length; ++il) {
                writer.write(lines[il]);
                writer.newLine();
            }
        }
    }

    private static String[] getFontPaths(ZipFile zip) {
        ArrayList<String> pathList = new ArrayList<String>();
        Enumeration<? extends ZipEntry> zen = zip.entries();
        while (zen.hasMoreElements()) {
            ZipEntry entry = zen.nextElement();
            String path = "/" + entry.getName();
            if (!FONTPATH_REGEX.matcher(path).matches()) continue;
            pathList.add(path);
        }
        return pathList.toArray(new String[0]);
    }

    public static void main(String[] args) throws IOException {
        String usage = "Usage: " + ExternalFontMapper.class.getName() + " <font-zipfile> ...";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(1);
            return;
        }
        if (args[0].startsWith("-h")) {
            System.err.println(usage);
            return;
        }
        for (int iz = 0; iz < args.length; ++iz) {
            ZipFile zip;
            try {
                zip = new ZipFile(args[iz]);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("\n" + usage);
                System.exit(1);
                return;
            }
            String[] fontPaths = ExternalFontMapper.getFontPaths(zip);
            for (int ip = 0; ip < fontPaths.length; ++ip) {
                System.out.println(fontPaths[ip]);
            }
        }
    }

    static {
        FontFactory.defaultEmbedding = true;
    }
}

