/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jfree.graphics2d.svg.MeetOrSlice;
import org.jfree.graphics2d.svg.PreserveAspectRatio;
import org.jfree.graphics2d.svg.SVGGraphics2D;
import org.jfree.graphics2d.svg.SVGUnits;
import org.jfree.graphics2d.svg.ViewBox;
import uk.ac.starlink.ttools.plot.FixedEpsGraphics2D;
import uk.ac.starlink.ttools.plot.PdfGraphicExporter;
import uk.ac.starlink.ttools.plot.Picture;

public abstract class GraphicExporter {
    private final String name_;
    private final String mimeType_;
    private final boolean isVector_;
    private final String description_;
    private final String[] fileSuffixes_;
    public static final GraphicExporter JPEG = new ImageIOExporter("jpeg", "image/jpeg", "JPEG", new String[]{".jpg", ".jpeg"}, "jpeg", false);
    public static final GraphicExporter PNG = new ImageIOExporter("png", "image/png", "PNG", new String[]{".png"}, "png", false);
    public static final GraphicExporter PNG_TRANSPARENT = new ImageIOExporter("png-transp", "image/png", "PNG with transparent background", null, "png", true);
    public static final GraphicExporter GIF = new ImageIOExporter("gif", "image/gif", "GIF", new String[]{".gif"}, "gif", false);
    public static final GraphicExporter SVG = new GraphicExporter("svg", "image/svg+xml", true, "Scalable Vector Graphics", new String[]{".svg"}){

        @Override
        public void exportGraphic(Picture picture, OutputStream out) throws IOException {
            int w = picture.getPictureWidth();
            int h = picture.getPictureHeight();
            SVGGraphics2D g2 = new SVGGraphics2D(w, h, SVGUnits.PX);
            picture.paintPicture((Graphics2D)g2);
            OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
            String id = null;
            boolean includeDimensions = true;
            ViewBox viewBox = new ViewBox(0, 0, w, h);
            PreserveAspectRatio aspect = null;
            MeetOrSlice meet = null;
            writer.write(g2.getSVGElement(id, includeDimensions, viewBox, aspect, meet));
            ((Writer)writer).close();
        }
    };
    public static final GraphicExporter EPS = new GraphicExporter("eps", "application/postscript", true, "Encapsulated PostScript", new String[]{".eps", ".ps"}){

        @Override
        public void exportGraphic(Picture picture, OutputStream out) throws IOException {
            int pad;
            double scale;
            int width = picture.getPictureWidth();
            int height = picture.getPictureHeight();
            double padfrac = 0.0;
            double xdpi = (double)width / 6.0;
            double ydpi = (double)height / 9.0;
            if (xdpi > ydpi) {
                scale = 72.0 / xdpi;
                pad = (int)Math.ceil((double)width * padfrac * scale);
            } else {
                scale = 72.0 / ydpi;
                pad = (int)Math.ceil((double)height * padfrac * scale);
            }
            int xlo = -pad;
            int ylo = -pad;
            int xhi = (int)Math.ceil(scale * (double)width) + pad;
            int yhi = (int)Math.ceil(scale * (double)height) + pad;
            FixedEpsGraphics2D g2 = new FixedEpsGraphics2D("Plot", out, xlo, ylo, xhi, yhi);
            g2.scale(scale, scale);
            picture.paintPicture(g2);
            g2.close();
        }
    };
    public static final GraphicExporter EPS_GZIP = new GzipExporter(EPS);

    protected GraphicExporter(String name, String mimeType, boolean isVector, String description, String[] fileSuffixes) {
        this.name_ = name;
        this.mimeType_ = mimeType;
        this.isVector_ = isVector;
        this.description_ = description;
        this.fileSuffixes_ = fileSuffixes == null ? new String[]{} : (String[])fileSuffixes.clone();
    }

    public abstract void exportGraphic(Picture var1, OutputStream var2) throws IOException;

    public String getName() {
        return this.name_;
    }

    public String getMimeType() {
        return this.mimeType_;
    }

    public boolean isVector() {
        return this.isVector_;
    }

    public String getDescription() {
        return this.description_;
    }

    public String getContentEncoding() {
        return null;
    }

    public String[] getFileSuffixes() {
        return (String[])this.fileSuffixes_.clone();
    }

    public String toString() {
        return this.name_;
    }

    public static Picture toPicture(final JComponent comp) {
        final Rectangle bounds = comp.getBounds();
        return new Picture(){

            @Override
            public int getPictureWidth() {
                return bounds.width;
            }

            @Override
            public int getPictureHeight() {
                return bounds.height;
            }

            @Override
            public void paintPicture(Graphics2D g) {
                int xoff = -bounds.x;
                int yoff = -bounds.y;
                g.translate(xoff, yoff);
                comp.print(g);
                g.translate(-xoff, -yoff);
            }
        };
    }

    public static GraphicExporter[] getKnownExporters(PdfGraphicExporter pdfEx) {
        ArrayList<GraphicExporter> list = new ArrayList<GraphicExporter>();
        list.add(PNG);
        list.add(PNG_TRANSPARENT);
        list.add(GIF);
        list.add(JPEG);
        if (pdfEx != null) {
            list.add(pdfEx);
        }
        list.add(SVG);
        list.add(EPS);
        list.add(EPS_GZIP);
        return list.toArray(new GraphicExporter[0]);
    }

    private static class GzipExporter
    extends GraphicExporter {
        private final GraphicExporter baseExporter_;

        GzipExporter(GraphicExporter baseExporter) {
            super(baseExporter.getName() + "-gzip", baseExporter.getMimeType(), baseExporter.isVector(), "Gzipped " + baseExporter.getDescription(), GzipExporter.appendGzipSuffix(baseExporter.getFileSuffixes()));
            this.baseExporter_ = baseExporter;
        }

        @Override
        public void exportGraphic(Picture picture, OutputStream out) throws IOException {
            GZIPOutputStream gzout = new GZIPOutputStream(out);
            this.baseExporter_.exportGraphic(picture, gzout);
            gzout.finish();
        }

        @Override
        public String getContentEncoding() {
            return "gzip";
        }

        private static String[] appendGzipSuffix(String[] names) {
            String[] sNames = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                sNames[i] = names[i] + ".gz";
            }
            return sNames;
        }
    }

    private static class ImageIOExporter
    extends GraphicExporter {
        private final String iioName_;
        private final boolean transparentBg_;
        private final boolean isSupported_;

        ImageIOExporter(String name, String mimeType, String description, String[] fileSuffixes, String iioName, boolean transparentBg) {
            super(name, mimeType, false, description, fileSuffixes);
            this.iioName_ = iioName;
            this.transparentBg_ = transparentBg;
            this.isSupported_ = ImageIO.getImageWritersByFormatName(iioName).hasNext();
        }

        @Override
        public void exportGraphic(Picture picture, OutputStream out) throws IOException {
            if (!this.isSupported_) {
                throw new IOException("Graphics export to " + this.iioName_ + " not supported");
            }
            int w = picture.getPictureWidth();
            int h = picture.getPictureHeight();
            int imageType = this.transparentBg_ ? 2 : 1;
            BufferedImage image = new BufferedImage(w, h, imageType);
            Graphics2D g2 = image.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            Color color = g2.getColor();
            Composite compos = g2.getComposite();
            if (this.transparentBg_) {
                g2.setComposite(AlphaComposite.Src);
                g2.setColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
            } else {
                g2.setColor(Color.WHITE);
            }
            g2.fillRect(0, 0, w, h);
            g2.setColor(color);
            g2.setComposite(compos);
            picture.paintPicture(g2);
            boolean done = ImageIO.write((RenderedImage)image, this.iioName_, out);
            out.flush();
            g2.dispose();
            if (!done) {
                throw new IOException("No handler for format " + this.iioName_ + " (surprising - thought there was)");
            }
        }
    }
}

