/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class LutSteal {
    private final Icon icon_;
    private final boolean horiz_;

    public LutSteal(Icon icon, boolean horiz) {
        this.icon_ = icon;
        this.horiz_ = horiz;
    }

    public void writeLut(OutputStream out, boolean verbose) throws IOException {
        int w = this.icon_.getIconWidth();
        int h = this.icon_.getIconHeight();
        BufferedImage im = new BufferedImage(w, h, 1);
        Graphics2D g = im.createGraphics();
        this.icon_.paintIcon(null, g, 0, 0);
        g.dispose();
        int n = this.horiz_ ? w : h;
        Rectangle line = this.horiz_ ? new Rectangle(0, h / 2, w, 1) : new Rectangle(w / 2, 0, 1, h);
        DataBuffer dbuf = im.getData(line).getDataBuffer();
        DataOutputStream dout = new DataOutputStream(new BufferedOutputStream(out));
        for (int i = 0; i < n; ++i) {
            int isamp = dbuf.getElem(i);
            for (int j = 0; j < 3; ++j) {
                int bs = (isamp & 0xFF0000) >> 16;
                isamp <<= 8;
                float fsamp = (float)bs / 255.0f;
                dout.writeFloat(fsamp);
                if (!verbose) continue;
                System.err.print("\t" + bs);
            }
            if (!verbose) continue;
            System.err.println();
        }
        dout.flush();
    }

    public static void main(String[] args) throws IOException {
        String usage = LutSteal.class.getName() + " [-x|-y] [-v] <iconfile>";
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean horiz = true;
        boolean verbose = false;
        String filename = null;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if ("-x".equals(arg)) {
                it.remove();
                horiz = true;
                continue;
            }
            if ("-y".equals(arg)) {
                it.remove();
                horiz = false;
                continue;
            }
            if ("-v".equals(arg)) {
                it.remove();
                verbose = true;
                continue;
            }
            if (arg.startsWith("-h")) {
                System.out.println(usage);
                return;
            }
            if (filename != null) continue;
            it.remove();
            filename = arg;
        }
        if (filename == null || argList.size() > 0) {
            System.err.println(usage);
            System.exit(1);
        }
        new LutSteal(new ImageIcon(filename), horiz).writeLut(System.out, verbose);
    }
}

