/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.util.ArrayList;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.ttools.plot.Style;

public class MultiPlotData
implements PlotData {
    private final PlotData[] datas_;
    private final int ndim_;
    private final int nerror_;
    private final boolean hasLabels_;
    private final SetLoc[] setLocs_;

    public MultiPlotData(PlotData[] datas) {
        this.datas_ = (PlotData[])datas.clone();
        int ndata = this.datas_.length;
        this.ndim_ = this.datas_[0].getNdim();
        int nerror = 0;
        boolean hasLabels = false;
        ArrayList<SetLoc> setLocList = new ArrayList<SetLoc>();
        for (int id = 0; id < ndata; ++id) {
            PlotData data = this.datas_[id];
            if (data.getNdim() != this.ndim_) {
                throw new IllegalArgumentException("Inconsistent ndims");
            }
            nerror = Math.max(nerror, data.getNerror());
            hasLabels = hasLabels || data.hasLabels();
            for (int is = 0; is < data.getSetCount(); ++is) {
                setLocList.add(new SetLoc(id, is));
            }
        }
        this.nerror_ = nerror;
        this.hasLabels_ = hasLabels;
        this.setLocs_ = setLocList.toArray(new SetLoc[0]);
    }

    @Override
    public int getNdim() {
        return this.ndim_;
    }

    @Override
    public int getNerror() {
        return this.nerror_;
    }

    @Override
    public int getSetCount() {
        return this.setLocs_.length;
    }

    @Override
    public String getSetName(int iset) {
        SetLoc loc = this.setLocs_[iset];
        return this.datas_[loc.id_].getSetName(loc.is_);
    }

    @Override
    public Style getSetStyle(int iset) {
        SetLoc loc = this.setLocs_[iset];
        return this.datas_[loc.id_].getSetStyle(loc.is_);
    }

    @Override
    public boolean hasLabels() {
        return this.hasLabels_;
    }

    @Override
    public PointSequence getPointSequence() {
        return new MultiPointSequence();
    }

    private static class SetLoc {
        final int id_;
        final int is_;

        SetLoc(int id, int is) {
            this.id_ = id;
            this.is_ = is;
        }
    }

    private class MultiPointSequence
    implements PointSequence {
        private int idata_;
        private PointSequence pseq_;
        private int loSet_;
        private int hiSet_;

        private MultiPointSequence() {
        }

        @Override
        public boolean next() {
            while (this.pseq_ != null || this.idata_ < MultiPlotData.this.datas_.length) {
                if (this.pseq_ == null) {
                    this.loSet_ = this.hiSet_;
                    this.hiSet_ += MultiPlotData.this.datas_[this.idata_].getSetCount();
                    this.pseq_ = MultiPlotData.this.datas_[this.idata_].getPointSequence();
                    ++this.idata_;
                }
                if (this.pseq_.next()) {
                    return true;
                }
                this.pseq_.close();
                this.pseq_ = null;
            }
            return false;
        }

        @Override
        public double[] getPoint() {
            return this.pseq_.getPoint();
        }

        @Override
        public double[][] getErrors() {
            return this.pseq_.getErrors();
        }

        @Override
        public String getLabel() {
            return this.pseq_.getLabel();
        }

        @Override
        public boolean isIncluded(int iset) {
            return iset >= this.loSet_ && iset < this.hiSet_ ? this.pseq_.isIncluded(iset - this.loSet_) : false;
        }

        @Override
        public void close() {
            if (this.pseq_ != null) {
                this.pseq_.close();
            }
        }
    }
}

