/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.BitSet;

public class PixelMask {
    private final Rectangle box_;
    private final int npix_;
    private final BitSet mask_;

    public PixelMask(Rectangle box) {
        this.box_ = new Rectangle(box);
        this.npix_ = box.width * box.height;
        this.mask_ = new BitSet(this.npix_);
    }

    public void set(Rectangle rect) {
        int xmin = Math.max(rect.x, this.box_.x);
        int xmax = Math.min(rect.x + rect.width, this.box_.x + this.box_.width);
        int ymin = Math.max(rect.y, this.box_.y);
        int ymax = Math.min(rect.y + rect.height, this.box_.y + this.box_.height);
        if (xmax >= xmin) {
            for (int y = ymin; y <= ymax; ++y) {
                int base = (y - this.box_.y) * this.box_.width - this.box_.x;
                assert (base + xmin >= 0 && base + xmin < this.npix_);
                assert (base + xmax >= 0 && base + xmax < this.npix_);
                this.mask_.set(base + xmin, base + xmax + 1);
            }
        }
    }

    public void set(Point p) {
        this.set(p.x, p.y);
    }

    public boolean get(Point p) {
        return this.get(p.x, p.y);
    }

    public void set(int x, int y) {
        int index = this.getIndex(x, y);
        if (index >= 0 && index < this.npix_) {
            this.mask_.set(index);
        }
    }

    public boolean get(int x, int y) {
        int index = this.getIndex(x, y);
        return index >= 0 && index < this.npix_ ? this.mask_.get(index) : false;
    }

    private int getIndex(int x, int y) {
        return (y - this.box_.y) * this.box_.width + (x - this.box_.x);
    }
}

