/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import uk.ac.starlink.ttools.plot.BitmapSortPlotVolume;
import uk.ac.starlink.ttools.plot.MarkShape;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.ttools.plot.Matrices;
import uk.ac.starlink.ttools.plot.Plot3DState;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PlotDataPointIterator;
import uk.ac.starlink.ttools.plot.PlotEvent;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.PlotVolume;
import uk.ac.starlink.ttools.plot.PointIterator;
import uk.ac.starlink.ttools.plot.PointPlacer;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.ShaderTweaker;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot.TablePlot;
import uk.ac.starlink.ttools.plot.VectorSortPlotVolume;
import uk.ac.starlink.ttools.plot.ZBufferPlotVolume;

public abstract class Plot3D
extends TablePlot {
    private RangeChecker rangeChecker_;
    private PlotVolume lastVol_;
    private Transformer3D lastTrans_;
    private int plotTime_;
    private Object plotvolWorkspace_;
    private int[] padBorders_;
    private double zmax_;
    private final JComponent plotArea_;
    protected double[] loBounds_;
    protected double[] hiBounds_;
    protected double[] loBoundsG_;
    protected double[] hiBoundsG_;
    private static final MarkStyle DOT_STYLE = MarkShape.POINT.getStyle(Color.BLACK, 1);
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot");

    public Plot3D() {
        this.setLayout(new BorderLayout());
        this.plotArea_ = new Plot3DDataPanel();
        this.plotArea_.setBackground(Color.white);
        this.plotArea_.setOpaque(true);
        this.plotArea_.setPreferredSize(new Dimension(450, 450));
        this.plotArea_.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        this.add((Component)this.plotArea_, "Center");
        this.setOpaque(false);
    }

    protected abstract RangeChecker configureRanges(Plot3DState var1);

    protected abstract double getPadding(Plot3DState var1, Graphics var2, int[] var3);

    protected abstract boolean frontOnly(Plot3DState var1);

    protected abstract boolean[] get3DLogFlags();

    protected abstract void plotAxes(Plot3DState var1, Graphics var2, Transformer3D var3, PlotVolume var4, boolean var5);

    @Override
    public void setState(PlotState state) {
        super.setState(state);
        this.lastVol_ = null;
        this.lastTrans_ = null;
        if (state.getValid()) {
            this.rangeChecker_ = this.configureRanges((Plot3DState)state);
        }
    }

    @Override
    public Rectangle getPlotBounds() {
        return this.plotArea_.getBounds();
    }

    public Rectangle getDisplayBounds() {
        Rectangle display = new Rectangle(this.getPlotBounds());
        display.x += this.padBorders_[0];
        display.y += this.padBorders_[3];
        display.width -= this.padBorders_[0] + this.padBorders_[1];
        display.height -= this.padBorders_[2] + this.padBorders_[3];
        return display;
    }

    private void drawData(Graphics g, Component c) {
        PlotVolume vol;
        Plot3DState state = (Plot3DState)this.getState();
        if (state == null || !state.getValid()) {
            return;
        }
        PlotData data = state.getPlotData();
        if (data == null) {
            return;
        }
        int nset = data.getSetCount();
        Transformer3D trans = new Transformer3D(state.getRotation(), this.loBoundsG_, this.hiBoundsG_, state.getZoomScale());
        this.padBorders_ = new int[4];
        double padFactor = this.getPadding(state, g, this.padBorders_);
        MarkStyle[] styles = new MarkStyle[nset + 1];
        for (int is = 0; is < nset; ++is) {
            styles[is] = (MarkStyle)data.getSetStyle(is);
        }
        styles[nset] = DOT_STYLE;
        int iDotStyle = nset;
        boolean allOpaque = true;
        for (int is = 0; is < nset && allOpaque; ++is) {
            allOpaque = allOpaque && styles[is].getOpaqueLimit() == 1;
        }
        Shader[] shaders = state.getShaders();
        for (int iaux = 0; iaux < shaders.length; ++iaux) {
            Shader shader = shaders[iaux];
            allOpaque = allOpaque && !Shaders.isTransparent(shaders[iaux]);
        }
        boolean anyErrors = false;
        for (int is = 0; is < nset && !anyErrors; ++is) {
            anyErrors = anyErrors || MarkStyle.hasErrors(styles[is], data);
        }
        boolean hasLabels = data.hasLabels();
        double fog = state.getFogginess();
        ShaderTweaker tweaker = ShaderTweaker.createTweaker(3, state);
        if (Plot3D.isVectorContext(g)) {
            if (!allOpaque) {
                logger_.warning("Can't render transparency to vector format");
            }
            vol = new VectorSortPlotVolume(c, g, styles, padFactor, this.padBorders_, fog, tweaker);
        } else {
            vol = allOpaque ? new ZBufferPlotVolume(c, g, styles, padFactor, this.padBorders_, fog, hasLabels, tweaker, this.getZBufferWorkspace()) : new BitmapSortPlotVolume(c, g, styles, padFactor, this.padBorders_, fog, hasLabels, anyErrors, -1.0, 2.0, tweaker, this.getBitmapSortWorkspace());
        }
        logger_.config("PlotVolume class is: " + vol.getClass().getName());
        boolean frontOnly = this.frontOnly(state);
        boolean grid = state.getGrid();
        if (grid && !frontOnly) {
            this.plotAxes(g, trans, vol, false);
        }
        boolean[] showPoints = new boolean[nset];
        boolean[] showErrors = new boolean[nset];
        for (int is = 0; is < nset; ++is) {
            MarkStyle style = styles[is];
            showPoints[is] = !style.getHidePoints();
            showErrors[is] = MarkStyle.hasErrors(style, data);
        }
        long tStart = System.currentTimeMillis();
        boolean isRotating = state.getRotating();
        int step = isRotating ? Math.max(this.plotTime_ / 100, 1) : 1;
        this.zmax_ = frontOnly ? 0.5 : Double.MAX_VALUE;
        int nInclude = 0;
        int nVisible = 0;
        boolean[] logFlags = this.get3DLogFlags();
        boolean[] showMarkPoints = new boolean[nset];
        boolean[] showMarkErrors = new boolean[nset];
        double[] centre = new double[3];
        int nerr = data.getNerror();
        double[] xerrs = new double[nerr];
        double[] yerrs = new double[nerr];
        double[] zerrs = new double[nerr];
        RangeChecker ranger = this.rangeChecker_;
        int ip = 0;
        PointSequence pseq = data.getPointSequence();
        while (pseq.next()) {
            boolean use = false;
            boolean useErrors = false;
            int labelSet = -1;
            for (int is = 0; is < nset; ++is) {
                boolean included = pseq.isIncluded(is);
                use = use || included;
                boolean showP = included && showPoints[is];
                boolean showE = included && showErrors[is];
                useErrors = useErrors || showE;
                showMarkPoints[is] = showP;
                showMarkErrors[is] = showE;
                if (!included || !hasLabels) continue;
                labelSet = is;
            }
            if (use) {
                ++nInclude;
                double[] coords = pseq.getPoint();
                centre[0] = coords[0];
                centre[1] = coords[1];
                centre[2] = coords[2];
                if (ranger.inRange(coords) && Plot3D.logize(coords, logFlags)) {
                    trans.transform(coords);
                    if (coords[2] < this.zmax_) {
                        if (useErrors) {
                            double[][] errors = pseq.getErrors();
                            useErrors = useErrors && Plot3D.transformErrors(trans, ranger, logFlags, errors, xerrs, yerrs, zerrs);
                        }
                        boolean vis = false;
                        for (int is = 0; is < nset; ++is) {
                            String label;
                            int numErr;
                            int n = numErr = useErrors && showMarkErrors[is] ? nerr : 0;
                            if (is == labelSet) {
                                label = pseq.getLabel();
                                if (label != null && label.trim().length() == 0) {
                                    label = null;
                                }
                            } else {
                                label = null;
                            }
                            boolean plotted = vol.plot3d(coords, is, showMarkPoints[is], label, numErr, xerrs, yerrs, zerrs);
                            vis = vis || plotted;
                        }
                        if (vis) {
                            ++nVisible;
                        }
                    }
                }
            }
            while (++ip % step != 0 && pseq.next()) {
            }
        }
        pseq.close();
        int nPoint = ip;
        double[] dot = new double[data.getNdim()];
        dot[0] = 0.5;
        dot[1] = 0.5;
        dot[2] = 0.5;
        vol.plot3d(dot, iDotStyle, true, null, 0, null, null, null);
        vol.flush();
        if (!isRotating) {
            this.plotTime_ = (int)(System.currentTimeMillis() - tStart);
        }
        if (grid) {
            this.plotAxes(g, trans, vol, true);
        }
        this.lastVol_ = vol;
        this.lastTrans_ = trans;
        this.firePlotChangedLater(new PlotEvent(this, state, nPoint, nInclude, nVisible));
        logger_.fine("3D plot time (ms): " + (System.currentTimeMillis() - tStart));
    }

    private void plotAxes(Graphics g, Transformer3D trans, PlotVolume vol, boolean front) {
        Plot3DState state = (Plot3DState)this.getState();
        Graphics2D g2 = (Graphics2D)g;
        Object antialias = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, state.getAntialias() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        this.plotAxes(state, g, trans, vol, front);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialias);
    }

    public PointIterator getPlottedPointIterator() {
        PlotData data = this.getState().getPlotData();
        if (this.lastVol_ != null && this.lastTrans_ != null && data != null) {
            return new PlotDataPointIterator(data, this.getPointPlacer());
        }
        return PointIterator.EMPTY;
    }

    public PointPlacer getPointPlacer() {
        final PlotVolume vol = this.lastVol_;
        final Transformer3D trans = this.lastTrans_;
        if (trans == null || vol == null) {
            return null;
        }
        boolean[] logFlags = this.get3DLogFlags();
        final RangeChecker ranger = this.rangeChecker_;
        Rectangle plotBounds = this.getPlotBounds();
        final int xmin = plotBounds.x + 1;
        final int xmax = plotBounds.x + plotBounds.width - 2;
        final int ymin = plotBounds.y + 1;
        final int ymax = plotBounds.y + plotBounds.height - 2;
        final double zmax = this.zmax_;
        return new PointPlacer(){

            @Override
            public Point getXY(double[] coords) {
                if (ranger.inRange(coords) && Plot3D.logize(coords, Plot3D.this.get3DLogFlags())) {
                    trans.transform(coords);
                    double z = coords[2];
                    if (z <= zmax) {
                        int px = vol.projectX(coords[0]);
                        int py = vol.projectY(coords[1]);
                        Insets insets = Plot3D.this.getInsets();
                        if ((px += insets.left) >= xmin && px <= xmax && (py += insets.top) >= ymin && py <= ymax) {
                            return new Point(px, py);
                        }
                    }
                }
                return null;
            }
        };
    }

    private ZBufferPlotVolume.Workspace getZBufferWorkspace() {
        if (!(this.plotvolWorkspace_ instanceof ZBufferPlotVolume.Workspace)) {
            this.plotvolWorkspace_ = new ZBufferPlotVolume.Workspace();
        }
        return (ZBufferPlotVolume.Workspace)this.plotvolWorkspace_;
    }

    private BitmapSortPlotVolume.Workspace getBitmapSortWorkspace() {
        if (!(this.plotvolWorkspace_ instanceof BitmapSortPlotVolume.Workspace)) {
            this.plotvolWorkspace_ = new BitmapSortPlotVolume.Workspace();
        }
        return (BitmapSortPlotVolume.Workspace)this.plotvolWorkspace_;
    }

    protected static boolean logize(double[] coords, boolean[] logFlags) {
        for (int iax = 0; iax < 3; ++iax) {
            if (!logFlags[iax]) continue;
            if (coords[iax] > 0.0) {
                coords[iax] = Math.log(coords[iax]);
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean inRange(double[] coords, double[] lo, double[] hi) {
        return coords[0] >= lo[0] && coords[0] <= hi[0] && coords[1] >= lo[1] && coords[1] <= hi[1] && coords[2] >= lo[2] && coords[2] <= hi[2];
    }

    protected static boolean transformErrors(Transformer3D trans, RangeChecker ranger, boolean[] logFlags, double[][] errors, double[] xerrs, double[] yerrs, double[] zerrs) {
        int nerr = xerrs.length;
        assert (nerr == yerrs.length);
        assert (nerr == zerrs.length);
        for (int ierr = 0; ierr < nerr; ++ierr) {
            xerrs[ierr] = Double.NaN;
            yerrs[ierr] = Double.NaN;
            zerrs[ierr] = Double.NaN;
        }
        boolean hasError = false;
        int ierr = 0;
        int nerrDim = errors.length / 2;
        for (int ied = 0; ied < nerrDim; ++ied) {
            double[] lo = errors[ied * 2 + 0];
            double[] hi = errors[ied * 2 + 1];
            if (lo != null && ranger.inRange(lo) && Plot3D.logize(lo, logFlags)) {
                trans.transform(lo);
                xerrs[ierr] = lo[0];
                yerrs[ierr] = lo[1];
                zerrs[ierr] = lo[2];
                hasError = true;
            }
            ++ierr;
            if (hi != null && ranger.inRange(hi) && Plot3D.logize(hi, logFlags)) {
                trans.transform(hi);
                xerrs[ierr] = hi[0];
                yerrs[ierr] = hi[1];
                zerrs[ierr] = hi[2];
                hasError = true;
            }
            ++ierr;
        }
        return hasError;
    }

    public static double[] rotateXY(double[] base, double phi, double psi) {
        double[] rotX = Plot3D.rotate(base, new double[]{0.0, 1.0, 0.0}, phi);
        double[] rotY = Plot3D.rotate(base, new double[]{1.0, 0.0, 0.0}, psi);
        return Matrices.mmMult(Matrices.mmMult(base, rotX), rotY);
    }

    public static double[] rotate(double[] base, double[] screenAxis, double theta) {
        double[] axis = Matrices.mvMult(Matrices.invert(base), screenAxis);
        double[] a = Matrices.normalise(axis);
        double x = a[0];
        double y = a[1];
        double z = a[2];
        double s = Math.sin(theta);
        double c = Math.cos(theta);
        double w = 1.0 - c;
        return new double[]{x * x * w + c, x * y * w + z * s, x * z * w - y * s, x * y * w - z * s, y * y * w + c, y * z * w + x * s, x * z * w + y * s, y * z * w - x * s, z * z * w + c};
    }

    protected boolean paintMemoryError(OutOfMemoryError e) {
        return false;
    }

    private class Plot3DDataPanel
    extends JComponent {
        private boolean failed_ = false;

        Plot3DDataPanel() {
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
        }

        @Override
        protected void paintComponent(Graphics g) {
            block4: {
                super.paintComponent(g);
                if (this.isOpaque()) {
                    ((Graphics2D)g).setBackground(this.getBackground());
                    g.clearRect(0, 0, this.getWidth(), this.getHeight());
                }
                if (!this.failed_) {
                    try {
                        Plot3D.this.drawData(g, this);
                    }
                    catch (OutOfMemoryError e) {
                        this.failed_ = true;
                        if (Plot3D.this.paintMemoryError(e)) break block4;
                        logger_.log(Level.WARNING, "Out of memory in 3D plot", e);
                    }
                }
            }
        }
    }

    protected static class Transformer3D {
        final double[] loBounds_;
        final double[] factors_;
        final double[] rot_;
        final double zoom_;

        Transformer3D(double[] rotation, double[] loBounds, double[] hiBounds, double zoom) {
            this.rot_ = (double[])rotation.clone();
            this.loBounds_ = new double[3];
            this.factors_ = new double[3];
            this.zoom_ = zoom;
            for (int i = 0; i < 3; ++i) {
                double lo = loBounds[i];
                double hi = hiBounds[i];
                if (lo == hi) {
                    lo -= 1.0;
                    hi += 1.0;
                }
                this.loBounds_[i] = lo;
                this.factors_[i] = 1.0 / (hi - lo);
            }
        }

        void transform(double[] coords) {
            for (int i = 0; i < 3; ++i) {
                coords[i] = (coords[i] - this.loBounds_[i]) * this.factors_[i] - 0.5;
            }
            double x = coords[0];
            double y = coords[1];
            double z = coords[2];
            coords[0] = this.rot_[0] * x + this.rot_[1] * y + this.rot_[2] * z;
            coords[1] = this.rot_[3] * x + this.rot_[4] * y + this.rot_[5] * z;
            coords[2] = this.rot_[6] * x + this.rot_[7] * y + this.rot_[8] * z;
            coords[0] = coords[0] * this.zoom_;
            coords[1] = coords[1] * this.zoom_;
            int i = 0;
            while (i < 3) {
                int n = i++;
                coords[n] = coords[n] + 0.5;
            }
        }

        double[] getDepthVector() {
            return Matrices.normalise(Matrices.mvMult(Matrices.invert(this.rot_), new double[]{0.0, 0.0, 1.0}));
        }
    }

    protected static abstract class RangeChecker {
        protected RangeChecker() {
        }

        abstract boolean inRange(double[] var1);
    }
}

