/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.util.Arrays;

public abstract class Rounder {
    public static final Rounder LINEAR = new LinearRounder();
    public static final Rounder LOG = new LogRounder();
    public static final Rounder TIME_SECOND = new SecondRounder();
    private static final double LOG10 = Math.log(10.0);

    public abstract double round(double var1);

    public abstract double nextUp(double var1);

    public abstract double nextDown(double var1);

    private static class SecondRounder
    extends Rounder {
        private static final long SECOND = 1L;
        private static final long MIN = 60L;
        private static final long HOUR = 3600L;
        private static final long DAY = 86400L;
        private static final long WEEK = 604800L;
        private static final long YEAR = 31557600L;
        private final double[] periods_;
        private final int np_;
        private final double pmin_;
        private final double pmax_;

        public SecondRounder() {
            double[] periods = new double[]{1.0, 2.0, 5.0, 10.0, 30.0, 60.0, 120.0, 300.0, 600.0, 900.0, 1800.0, 3600.0, 7200.0, 14400.0, 21600.0, 43200.0, 86400.0, 172800.0, 345600.0, 604800.0, 1209600.0, 2629800.0, 7889400.0, 1.57788E7, 3.15576E7, 6.31152E7, 1.57788E8, 3.15576E8};
            this.periods_ = (double[])periods.clone();
            this.np_ = this.periods_.length;
            this.pmin_ = periods[0];
            this.pmax_ = periods[this.np_ - 1];
            Arrays.sort(this.periods_);
            assert (Arrays.equals(this.periods_, periods));
        }

        @Override
        public double nextUp(double value) {
            int pt = Arrays.binarySearch(this.periods_, value);
            if (pt == this.np_ - 1 || pt == -(this.np_ + 1)) {
                assert (value >= this.pmax_);
                return 3.15576E7 * LINEAR.nextUp(value / 3.15576E7);
            }
            if (pt == -1) {
                assert (value < this.pmin_);
                return 1.0 * LINEAR.nextUp(value / 1.0);
            }
            if (pt >= 0) {
                assert (value >= this.pmin_ && value <= this.pmax_);
                return this.periods_[pt + 1];
            }
            assert (value > this.pmin_ && value < this.pmax_);
            return this.periods_[-pt - 1];
        }

        @Override
        public double nextDown(double value) {
            int pt = Arrays.binarySearch(this.periods_, value);
            if (pt == 0 || pt == -1) {
                assert (value <= this.pmin_);
                return 1.0 * LINEAR.nextDown(value / 1.0);
            }
            if (pt == -(this.np_ + 1)) {
                assert (value > this.pmax_);
                return 3.15576E7 * LINEAR.nextDown(value / 3.15576E7);
            }
            if (pt > 0) {
                assert (value >= this.pmin_ && value <= this.pmax_);
                return this.periods_[pt - 1];
            }
            assert (value > this.pmin_ && value < this.pmax_);
            return this.periods_[-pt - 2];
        }

        @Override
        public double round(double value) {
            double up = this.nextUp(value);
            double down = this.nextDown(value);
            return Math.log(up) + Math.log(down) > 2.0 * Math.log(value) ? down : up;
        }
    }

    private static class LogRounder
    extends Rounder {
        private LogRounder() {
        }

        @Override
        public double round(double value) {
            return this.getNearestNumber(value).getValue();
        }

        @Override
        public double nextUp(double value) {
            RoundNumber num = this.getNearestNumber(value + Double.MIN_VALUE);
            while (num.getValue() <= value) {
                ++num.label_;
            }
            return num.getValue();
        }

        @Override
        public double nextDown(double value) {
            RoundNumber num = this.getNearestNumber(value - Double.MIN_VALUE);
            while (num.getValue() >= value) {
                --num.label_;
            }
            return num.getValue();
        }

        private RoundNumber getNearestNumber(double value) {
            if (value <= 1.0) {
                throw new IllegalArgumentException(value + " <= 1");
            }
            if (value >= 1.75) {
                return new RoundNumber((int)Math.round(value));
            }
            RoundNumber num = new RoundNumber(2);
            while (value < num.getValue()) {
                --num.label_;
            }
            return num;
        }

        private static class RoundNumber {
            int label_;

            RoundNumber(int label) {
                this.label_ = label;
            }

            double getValue() {
                return this.label_ > 1 ? (double)this.label_ : 1.0 + Math.pow(2.0, this.label_ - 2);
            }
        }
    }

    private static class LinearRounder
    extends Rounder {
        private final double[] roundMantissas_ = new double[]{1.0, 2.0, 2.5, 5.0, 10.0};

        private LinearRounder() {
            double[] roundMantissas = (double[])this.roundMantissas_.clone();
            Arrays.sort(roundMantissas);
            if (roundMantissas[0] != 1.0 || roundMantissas[roundMantissas.length - 1] != 10.0) {
                throw new AssertionError();
            }
        }

        @Override
        public double round(double value) {
            return this.getNearestNumber(value).getValue();
        }

        @Override
        public double nextUp(double value) {
            RoundNumber num = this.getNearestNumber(value * 1.01);
            double value1 = num.getValue();
            if (value1 > value) {
                return value1;
            }
            int index = Arrays.binarySearch(this.roundMantissas_, num.mantissa_);
            assert (this.roundMantissas_[index] == num.mantissa_);
            if (++index > this.roundMantissas_.length) {
                num.multiplier_ *= 10.0;
                index = 1;
            }
            num.mantissa_ = this.roundMantissas_[index];
            return num.getValue();
        }

        @Override
        public double nextDown(double value) {
            RoundNumber num = this.getNearestNumber(value * 0.99);
            double value1 = num.getValue();
            if (value1 < value) {
                return value1;
            }
            int index = Arrays.binarySearch(this.roundMantissas_, num.mantissa_);
            assert (this.roundMantissas_[index] == num.mantissa_);
            if (--index < 0) {
                num.multiplier_ *= 0.1;
                index = this.roundMantissas_.length - 2;
            }
            num.mantissa_ = this.roundMantissas_[index];
            return num.getValue();
        }

        private RoundNumber getNearestNumber(double value) {
            if (value <= 0.0) {
                throw new IllegalArgumentException(value + " < 0 (out of range)");
            }
            double exponent = Math.floor(Math.log(value) / LOG10);
            double multiplier = Math.pow(10.0, exponent);
            double mantissa = value / multiplier;
            assert (mantissa >= 0.999 && mantissa <= 10.001);
            for (int i = 1; i < this.roundMantissas_.length; ++i) {
                double r0 = this.roundMantissas_[i - 1];
                double r1 = this.roundMantissas_[i];
                if (!(mantissa >= r0) || !(mantissa <= r1)) continue;
                double d0 = mantissa - r0;
                double d1 = r1 - mantissa;
                return new RoundNumber(d0 < d1 ? r0 : r1, multiplier);
            }
            assert (false) : new RoundNumber(mantissa, multiplier);
            return new RoundNumber(1.0, multiplier);
        }

        private static class RoundNumber {
            double mantissa_;
            double multiplier_;

            RoundNumber(double mantissa, double multiplier) {
                this.mantissa_ = mantissa;
                this.multiplier_ = multiplier;
            }

            double getValue() {
                return this.mantissa_ * this.multiplier_;
            }

            public String toString() {
                return this.mantissa_ + "*" + this.multiplier_;
            }
        }
    }
}

