/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import uk.ac.starlink.ttools.plot2.Caption;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.PlotUtil;

public class BasicCaptioner
implements Captioner {
    private final Font font_;
    private final Boolean antialias_;
    private static Graphics dummyGraphics_;

    public BasicCaptioner() {
        this(null, false);
    }

    public BasicCaptioner(Font font, Boolean antialias) {
        this.font_ = font;
        this.antialias_ = antialias;
    }

    @Override
    public void drawCaption(Caption label, Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.font_ != null) {
            g2.setFont(this.font_);
        }
        if (this.antialias_ != null) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.antialias_ != false ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        g2.drawString(label.toText(), 0, 0);
    }

    @Override
    public Rectangle getCaptionBounds(Caption label) {
        FontMetrics fm = this.getFontMetrics();
        int descent = fm.getDescent();
        int ascent = fm.getAscent();
        return new Rectangle(0, -ascent, fm.stringWidth(label.toText()), ascent + descent);
    }

    @Override
    public int getPad() {
        return this.getFontMetrics().charWidth('0') / 2;
    }

    private FontMetrics getFontMetrics() {
        Graphics g = BasicCaptioner.getDummyGraphics();
        return g.getFontMetrics(this.font_ == null ? g.getFont() : this.font_);
    }

    private static synchronized Graphics getDummyGraphics() {
        if (dummyGraphics_ == null) {
            dummyGraphics_ = new BufferedImage(1, 1, 1).createGraphics();
        }
        return dummyGraphics_;
    }

    public boolean equals(Object o) {
        if (o instanceof BasicCaptioner) {
            BasicCaptioner other = (BasicCaptioner)o;
            return PlotUtil.equals(this.font_, other.font_) && PlotUtil.equals(this.antialias_, other.antialias_);
        }
        return false;
    }

    public int hashCode() {
        int code = 55921;
        code = 23 * code + PlotUtil.hashCode(this.font_);
        code = 23 * code + PlotUtil.hashCode(this.antialias_);
        return code;
    }
}

