/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.util.IconUtils;

@Equality
public class LegendEntry {
    private final String label_;
    private final Style[] styles_;
    private final Icon icon_;

    public LegendEntry(String label, Style[] styles) {
        this.label_ = label;
        this.styles_ = styles;
        int nstyle = styles.length;
        if (nstyle == 0) {
            this.icon_ = IconUtils.emptyIcon((int)4, (int)4);
        } else if (nstyle == 1) {
            this.icon_ = styles[0].getLegendIcon();
        } else {
            Icon[] icons = new Icon[nstyle];
            for (int i = 0; i < nstyle; ++i) {
                icons[i] = styles[i].getLegendIcon();
            }
            this.icon_ = new MultiIcon(icons);
        }
    }

    public LegendEntry(String label, Style style) {
        this(label, new Style[]{style});
    }

    public Icon getIcon() {
        return this.icon_;
    }

    public String getLabel() {
        return this.label_;
    }

    public boolean equals(Object o) {
        if (o instanceof LegendEntry) {
            LegendEntry other = (LegendEntry)o;
            return this.label_.equals(other.label_) && Arrays.equals(this.styles_, other.styles_);
        }
        return false;
    }

    public int hashCode() {
        int code = 29119;
        code = 23 * code + this.label_.hashCode();
        code = 23 * code + Arrays.hashCode(this.styles_);
        return code;
    }

    private static class MultiIcon
    implements Icon {
        private final Icon[] icons_;
        private final int width_;
        private final int height_;

        MultiIcon(Icon[] icons) {
            this.icons_ = icons;
            int w = 0;
            int h = 0;
            for (int i = 0; i < icons.length; ++i) {
                w = Math.max(w, icons[i].getIconWidth());
                h = Math.max(h, icons[i].getIconHeight());
            }
            this.width_ = w;
            this.height_ = h;
        }

        @Override
        public int getIconWidth() {
            return this.width_;
        }

        @Override
        public int getIconHeight() {
            return this.height_;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int xmid = this.width_ / 2;
            int ymid = this.height_ / 2;
            for (int i = 0; i < this.icons_.length; ++i) {
                Icon icon = this.icons_[i];
                int xoff = xmid - icon.getIconWidth() / 2;
                int yoff = ymid - icon.getIconHeight() / 2;
                icon.paintIcon(c, g, x + xoff, y + yoff);
            }
        }
    }
}

