/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import uk.ac.starlink.ttools.plot2.Equality;

@Equality
public abstract class Orientation {
    public static final Orientation X = new Orientation(){

        @Override
        public AffineTransform captionTransform(Rectangle bounds, int pad) {
            return AffineTransform.getTranslateInstance(-bounds.width / 2, -bounds.y + pad);
        }

        @Override
        public boolean isDown() {
            return true;
        }
    };
    public static final Orientation Y = new Orientation(){

        @Override
        public AffineTransform captionTransform(Rectangle bounds, int pad) {
            AffineTransform trans = new AffineTransform();
            trans.rotate(1.5707963267948966);
            trans.translate(-bounds.width - pad, -bounds.y / 2);
            return trans;
        }

        @Override
        public boolean isDown() {
            return false;
        }
    };
    public static final Orientation ANTI_X = new Orientation(){

        @Override
        public AffineTransform captionTransform(Rectangle bounds, int pad) {
            return AffineTransform.getTranslateInstance(-bounds.width / 2, -pad);
        }

        @Override
        public boolean isDown() {
            return false;
        }
    };
    public static final Orientation ANTI_Y = new Orientation(){

        @Override
        public AffineTransform captionTransform(Rectangle bounds, int pad) {
            AffineTransform trans = new AffineTransform();
            trans.rotate(1.5707963267948966);
            trans.translate(pad, -bounds.y / 2);
            return trans;
        }

        @Override
        public boolean isDown() {
            return true;
        }
    };

    public abstract AffineTransform captionTransform(Rectangle var1, int var2);

    public abstract boolean isDown();

    public static Orientation createAngledX(double thetaDeg, boolean isAnti) {
        return new AngledXOrientation(-Math.toRadians(thetaDeg), isAnti);
    }

    private static class AngledXOrientation
    extends Orientation {
        private final double thetaRad_;
        private final boolean isAnti_;
        private final double cosTheta_;
        private final AffineTransform rotateTransform_;

        AngledXOrientation(double thetaRad, boolean isAnti) {
            this.thetaRad_ = thetaRad;
            this.isAnti_ = isAnti;
            this.cosTheta_ = Math.cos(this.thetaRad_);
            this.rotateTransform_ = AffineTransform.getRotateInstance(this.thetaRad_);
        }

        @Override
        public AffineTransform captionTransform(Rectangle bounds, int pad) {
            if (this.isAnti_) {
                AffineTransform trans = new AffineTransform();
                trans.translate(-0.5 * (double)bounds.y * this.cosTheta_, -pad);
                trans.rotate(this.thetaRad_);
                return trans;
            }
            AffineTransform trans = new AffineTransform(this.rotateTransform_);
            trans.translate(-bounds.width, -bounds.y / 2);
            trans.rotate(-this.thetaRad_);
            trans.translate(0.0, (double)pad - 0.5 * this.cosTheta_ * (double)bounds.y);
            trans.rotate(this.thetaRad_);
            return trans;
        }

        @Override
        public boolean isDown() {
            return !this.isAnti_;
        }

        public int hashCode() {
            return Float.floatToIntBits((float)this.thetaRad_) * (this.isAnti_ ? -1 : 1);
        }

        public boolean equals(Object o) {
            if (o instanceof AngledXOrientation) {
                AngledXOrientation other = (AngledXOrientation)o;
                return this.thetaRad_ == other.thetaRad_ && this.isAnti_ == other.isAnti_;
            }
            return false;
        }
    }
}

