/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import uk.ac.starlink.ttools.plot2.Caption;
import uk.ac.starlink.ttools.plot2.Captioner;

public class OutlineCaptioner
implements Captioner {
    private final Captioner base_;
    private final Color color_;

    public OutlineCaptioner(Captioner base, Color color) {
        this.base_ = base;
        this.color_ = color;
    }

    @Override
    public Rectangle getCaptionBounds(Caption label) {
        return this.base_.getCaptionBounds(label);
    }

    @Override
    public void drawCaption(Caption label, Graphics g) {
        this.base_.drawCaption(label, g);
        Color color0 = g.getColor();
        g.setColor(this.color_);
        Rectangle bounds = this.getCaptionBounds(label);
        g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        g.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height);
        g.drawLine(bounds.x, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y);
        g.setColor(color0);
    }

    @Override
    public int getPad() {
        return this.base_.getPad();
    }

    public int hashCode() {
        int code = -66205;
        code += 23 * this.base_.hashCode();
        return code += 23 * this.color_.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof OutlineCaptioner) {
            OutlineCaptioner other = (OutlineCaptioner)o;
            return this.base_.equals(other.base_) && this.color_.equals(other.color_);
        }
        return false;
    }
}

