/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ParsedFunctionCall {
    private final String funcName_;
    private final double[] args_;
    private static final Pattern FUNC_REGEX = Pattern.compile("([a-zA-Z0-9]+)(?: *\\(([ ,0-9eE.+-]*)\\))?");

    public ParsedFunctionCall(String funcName, double[] args) {
        this.funcName_ = funcName;
        this.args_ = args;
    }

    public String getFunctionName() {
        return this.funcName_;
    }

    public double[] getArguments() {
        return this.args_;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(this.funcName_);
        if (this.args_ != null) {
            sbuf.append("(").append(Arrays.stream(this.args_).mapToObj(n -> n == (double)((int)n) ? Integer.toString((int)n) : Double.toString(n)).collect(Collectors.joining(","))).append(")");
        }
        return sbuf.toString();
    }

    public static ParsedFunctionCall fromString(String txt) {
        Matcher matcher = FUNC_REGEX.matcher(txt);
        if (matcher.matches()) {
            double[] args;
            String name = matcher.group(1);
            String argsTxt = matcher.group(2);
            if (argsTxt == null) {
                args = null;
            } else if (argsTxt.trim().length() == 0) {
                args = new double[]{};
            } else {
                try {
                    args = Arrays.stream(argsTxt.split(" *, *")).mapToDouble(s -> Double.parseDouble(s)).toArray();
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return new ParsedFunctionCall(name, args);
        }
        return null;
    }
}

