/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot2.Caption;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Decoration;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotFrame;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ShadeAxis;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.Surround;
import uk.ac.starlink.ttools.plot2.Trimming;

@Equality
public class PlotPlacement {
    private final Rectangle bounds_;
    private final Surface surface_;
    private final List<Decoration> decorations_;
    public static final int PAD = 2;
    private static final int EXTERNAL_LEGEND_GAP = 10;
    private static final int MIN_DIM = 24;

    public PlotPlacement(Rectangle bounds, Surface surface) {
        this(bounds, surface, new Decoration[0]);
    }

    public PlotPlacement(Rectangle bounds, Surface surface, Decoration[] decorations) {
        this.bounds_ = bounds;
        this.surface_ = surface;
        this.decorations_ = new ArrayList<Decoration>(Arrays.asList(decorations));
    }

    public Rectangle getBounds() {
        return this.bounds_;
    }

    public Surface getSurface() {
        return this.surface_;
    }

    public List<Decoration> getDecorations() {
        return this.decorations_;
    }

    public Icon createPlotIcon(final Icon dataIcon) {
        final Rectangle plotBounds = this.surface_.getPlotBounds();
        return new Icon(){

            @Override
            public int getIconWidth() {
                return ((PlotPlacement)PlotPlacement.this).bounds_.width;
            }

            @Override
            public int getIconHeight() {
                return ((PlotPlacement)PlotPlacement.this).bounds_.height;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                int xoff = x - ((PlotPlacement)PlotPlacement.this).bounds_.x;
                int yoff = y - ((PlotPlacement)PlotPlacement.this).bounds_.y;
                g.translate(xoff, yoff);
                this.paintPlot(c, g);
                g.translate(-xoff, -yoff);
            }

            private void paintPlot(Component c, Graphics g) {
                Shape clip0 = g.getClip();
                g.clipRect(plotBounds.x, plotBounds.y, plotBounds.width, plotBounds.height);
                dataIcon.paintIcon(c, g, plotBounds.x, plotBounds.y);
                g.setClip(clip0);
                PlotPlacement.this.surface_.paintForeground(g);
                for (Decoration dec : PlotPlacement.this.decorations_) {
                    dec.paintDecoration(g);
                }
            }
        };
    }

    public boolean equals(Object o) {
        if (o instanceof PlotPlacement) {
            PlotPlacement other = (PlotPlacement)o;
            return this.bounds_.equals(other.bounds_) && this.surface_.equals(other.surface_) && this.decorations_.equals(other.decorations_);
        }
        return false;
    }

    public int hashCode() {
        int code = 239991;
        code = 23 * code + this.bounds_.hashCode();
        code = 23 * code + this.surface_.hashCode();
        code = 23 * code + this.decorations_.hashCode();
        return code;
    }

    public static <P, A> PlotPlacement createPlacement(Rectangle extBounds, Padding padding, SurfaceFactory<P, A> surfFact, P profile, A aspect, boolean withScroll, Trimming trimming, ShadeAxis shadeAxis) {
        Rectangle dataBounds = PlotPlacement.calculateDataBounds(extBounds, padding, surfFact, profile, aspect, withScroll, trimming, shadeAxis);
        Surface surf = surfFact.createSurface(dataBounds, profile, aspect);
        PlotFrame frame = PlotFrame.createPlotFrame(surf, withScroll);
        Decoration[] decs = PlotPlacement.createPlotDecorations(frame, trimming, shadeAxis);
        return new PlotPlacement(extBounds, surf, decs);
    }

    public static Surround calculateApproxDecorationSurround(Rectangle extBounds, Trimming trimming, ShadeAxis shadeAxis, Supplier<Captioner> capFact) {
        Captioner captioner;
        Icon legend = trimming == null ? null : trimming.getLegend();
        float[] legPos = trimming == null ? null : trimming.getLegendPosition();
        String title = trimming == null ? null : trimming.getTitle();
        boolean hasExtLegend = legend != null && legPos == null;
        Surround decSurround = new Surround();
        if (hasExtLegend) {
            decSurround.right.extent = Math.max(decSurround.right.extent, legend.getIconWidth() + 10);
            decSurround.right.extent = Math.min(decSurround.right.extent, extBounds.width / 2);
        }
        if (shadeAxis != null) {
            Rectangle rampBox = new Rectangle(0, 0, shadeAxis.getRampWidth(), extBounds.height);
            decSurround.right.extent = Math.max(decSurround.right.extent, rampBox.width + shadeAxis.getRampInsets((Rectangle)rampBox).right + 10);
            int yShadePad = shadeAxis.getEndPadding();
            if (!hasExtLegend) {
                decSurround.right.under = Math.max(decSurround.right.under, yShadePad);
            }
            decSurround.right.over = Math.max(decSurround.right.under, yShadePad);
        }
        if (title != null && (captioner = capFact.get()) != null) {
            Caption caption = Caption.createCaption(title);
            int titleHeight = captioner.getCaptionBounds((Caption)caption).height + captioner.getPad();
            decSurround.top.extent = Math.max(decSurround.top.extent, titleHeight);
        }
        return decSurround;
    }

    public static <P, A> Insets calculateDataInsets(Rectangle extBounds, SurfaceFactory<P, A> surfFact, P profile, A aspect, boolean withScroll, Trimming trimming, ShadeAxis shadeAxis, int pad) {
        Supplier<Captioner> capFact = () -> surfFact.createSurface(extBounds, profile, aspect).getCaptioner();
        Surround decSurround = PlotPlacement.calculateApproxDecorationSurround(extBounds, trimming, shadeAxis, capFact);
        Insets padInsets = new Insets(2, 2, 2, 2);
        int nit = withScroll ? 2 : 5;
        Surround axisSurround = new Surround();
        Insets plotInsets = null;
        for (int i = 0; i < nit; ++i) {
            plotInsets = decSurround.add(axisSurround).toInsets();
            Rectangle plotBounds = extBounds;
            plotBounds = PlotUtil.subtractInsets(plotBounds, padInsets);
            plotBounds = PlotUtil.subtractInsets(plotBounds, plotInsets);
            plotBounds.width = Math.max(plotBounds.width, 24);
            plotBounds.height = Math.max(plotBounds.height, 24);
            Surface surf = surfFact.createSurface(plotBounds, profile, aspect);
            axisSurround = axisSurround.union(surf.getSurround(withScroll));
        }
        assert (plotInsets != null);
        return new Insets(plotInsets.top + padInsets.top, plotInsets.left + padInsets.left, plotInsets.bottom + padInsets.bottom, plotInsets.right + padInsets.right);
    }

    public static <P, A> Rectangle calculateDataBounds(Rectangle extBounds, Padding padding, SurfaceFactory<P, A> surfFact, P profile, A aspect, boolean withScroll, Trimming trimming, ShadeAxis shadeAxis) {
        Insets insets;
        Padding padding2 = padding = padding == null ? new Padding() : padding;
        if (padding.isDefinite()) {
            insets = padding.toDefiniteInsets();
        } else {
            Insets dataInsets = PlotPlacement.calculateDataInsets(extBounds, surfFact, profile, aspect, withScroll, trimming, shadeAxis, 2);
            insets = padding.overrideInsets(dataInsets);
        }
        Rectangle plotBounds = PlotUtil.subtractInsets(extBounds, insets);
        plotBounds.width = Math.max(plotBounds.width, 24);
        plotBounds.height = Math.max(plotBounds.height, 24);
        return plotBounds;
    }

    public static Decoration[] createPlotDecorations(PlotFrame frame, Trimming trimming, ShadeAxis shadeAxis) {
        Rectangle intBounds = frame.getInternalBounds();
        Surround surround = frame.getSurround();
        Captioner captioner = frame.getCaptioner();
        Icon legend = trimming == null ? null : trimming.getLegend();
        float[] legPos = trimming == null ? null : trimming.getLegendPosition();
        String title = trimming == null ? null : trimming.getTitle();
        ArrayList<Decoration> decList = new ArrayList<Decoration>();
        int gxlo = intBounds.x;
        int gylo = intBounds.y;
        int gxhi = intBounds.x + intBounds.width;
        int gyhi = intBounds.y + intBounds.height;
        int xRightExtra = gxhi + surround.right.extent + 10;
        int yTopExtra = gylo - surround.top.extent;
        if (legend != null) {
            int ly;
            int lx;
            if (legPos == null) {
                lx = xRightExtra;
                ly = gylo;
            } else {
                lx = gxlo + Math.round((float)(gxhi - gxlo - legend.getIconWidth()) * legPos[0]);
                ly = gylo + Math.round((float)(gyhi - gylo - legend.getIconHeight()) * (1.0f - legPos[1]));
            }
            decList.add(new Decoration(legend, lx, ly));
        }
        if (shadeAxis != null) {
            int sx = xRightExtra;
            boolean hasExtLegend = legend != null && legPos == null;
            int sy = gylo;
            if (hasExtLegend) {
                sy += legend.getIconHeight() + Math.max(shadeAxis.getEndPadding() + 2, 10);
            }
            Rectangle rampBox = new Rectangle(sx, sy, shadeAxis.getRampWidth(), gyhi - sy);
            Icon shadeIcon = shadeAxis.createAxisIcon(rampBox);
            decList.add(new Decoration(shadeIcon, sx, sy));
        }
        if (title != null) {
            CaptionIcon titleIcon = new CaptionIcon(title, captioner);
            int px = intBounds.x + intBounds.width / 2 - titleIcon.getIconWidth() / 2;
            int py = yTopExtra - titleIcon.getIconHeight() - captioner.getPad();
            decList.add(new Decoration(titleIcon, px, py));
        }
        return decList.toArray(new Decoration[0]);
    }

    @Equality
    private static class CaptionIcon
    implements Icon {
        private final Caption caption_;
        private final Captioner captioner_;
        private final int width_;
        private final int height_;
        private final int x_;
        private final int y_;

        CaptionIcon(String text, Captioner captioner) {
            this.caption_ = Caption.createCaption(text);
            this.captioner_ = captioner;
            Rectangle bounds = captioner.getCaptionBounds(this.caption_);
            this.x_ = 0;
            this.y_ = -bounds.y;
            this.width_ = bounds.width;
            this.height_ = bounds.height;
        }

        @Override
        public int getIconWidth() {
            return this.width_;
        }

        @Override
        public int getIconHeight() {
            return this.height_;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int xoff = x + this.x_;
            int yoff = y + this.y_;
            Color color0 = g.getColor();
            g.setColor(Color.BLACK);
            g.translate(xoff, yoff);
            this.captioner_.drawCaption(this.caption_, g);
            g.translate(-xoff, -yoff);
            g.setColor(color0);
        }

        public int hashCode() {
            int code = 4432;
            code = 23 * this.caption_.hashCode();
            code = 23 * this.captioner_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof CaptionIcon) {
                CaptionIcon other = (CaptionIcon)o;
                return this.caption_.equals(other.caption_) && this.captioner_.equals(other.captioner_);
            }
            return false;
        }
    }
}

