/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.util.Arrays;
import uk.ac.starlink.ttools.func.Maths;
import uk.ac.starlink.ttools.plot.Rounder;
import uk.ac.starlink.ttools.plot2.BasicTicker;
import uk.ac.starlink.ttools.plot2.ParsedFunctionCall;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Ticker;

public abstract class ScaleType {
    private final String scaleName_;
    private final Param[] params_;
    public static final ScaleType LINEAR = new LinearScaleType("linear", Rounder.LINEAR);
    public static final ScaleType LOG = new LogScaleType();
    public static final ScaleType SYMLOG;
    public static final ScaleType ASINH;
    private static final ScaleType[] INSTANCES;
    public static final ScaleType TIME;
    private static final Rounder DUMMY_ROUNDER;

    protected ScaleType(String scaleName, Param[] params) {
        this.scaleName_ = scaleName;
        this.params_ = params;
    }

    public abstract Scale createScale(double[] var1);

    public Param[] getParams() {
        return (Param[])this.params_.clone();
    }

    public String getName() {
        return this.scaleName_;
    }

    public abstract String getDescription();

    public String toString() {
        return this.scaleName_;
    }

    double[] fillInArgs(double[] args) {
        int np = this.params_.length;
        double[] args1 = new double[np];
        for (int ip = 0; ip < np; ++ip) {
            args1[ip] = args.length > ip ? args[ip] : this.params_[ip].getDefault();
        }
        return args1;
    }

    public static ScaleType[] getInstances() {
        return (ScaleType[])INSTANCES.clone();
    }

    public static ScaleType fromName(String name) {
        for (ScaleType type : INSTANCES) {
            if (!type.scaleName_.equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    private static double log10(double x) {
        return Math.log10(x);
    }

    private static double pow10(double x) {
        return Math.pow(10.0, x);
    }

    static {
        ASINH = new AsinhScaleType();
        SYMLOG = new SymlogScaleType();
        INSTANCES = new ScaleType[]{LINEAR, LOG, ASINH, SYMLOG};
        TIME = new LinearScaleType("time", Rounder.TIME_SECOND);
        DUMMY_ROUNDER = new Rounder(){

            @Override
            public double round(double value) {
                return value;
            }

            @Override
            public double nextUp(double value) {
                return value;
            }

            @Override
            public double nextDown(double value) {
                return value;
            }
        };
    }

    private static class BumpNumber {
        double mant_;
        double exp_;

        BumpNumber(double d) {
            d = Math.abs(d);
            this.exp_ = Math.floor(ScaleType.log10(d));
            this.mant_ = d / ScaleType.pow10(this.exp_);
        }

        double getValue() {
            return this.mant_ * ScaleType.pow10(this.exp_);
        }

        void bumpUp() {
            if (this.mant_ < 2.0) {
                this.mant_ = 2.0;
            } else if (this.mant_ < 5.0) {
                this.mant_ = 5.0;
            } else {
                this.mant_ = 1.0;
                this.exp_ += 1.0;
            }
        }

        void bumpDown() {
            if (this.mant_ > 5.0) {
                this.mant_ = 5.0;
            } else if (this.mant_ > 2.0) {
                this.mant_ = 2.0;
            } else if (this.mant_ > 1.0) {
                this.mant_ = 1.0;
            } else {
                this.mant_ = 5.0;
                this.exp_ -= 1.0;
            }
        }

        public String toString() {
            return this.mant_ + "e" + this.exp_;
        }
    }

    private static class LinscaleParam
    extends Log10Param {
        final double step1_;

        LinscaleParam(String name, double dflt, String descrip) {
            super(name, dflt, descrip);
            this.step1_ = 0.5;
        }

        @Override
        public double nextDown(double d) {
            return d < 1.0 + this.step1_ ? super.nextDown(d) : (Math.ceil(d / this.step1_) - 1.0) * this.step1_;
        }

        @Override
        public double nextUp(double d) {
            return d < 1.0 ? super.nextUp(d) : (Math.floor(d / this.step1_) + 1.0) * this.step1_;
        }
    }

    private static class Log10Param
    extends Param {
        Log10Param(String name, double dflt, String descrip) {
            super(name, dflt, descrip);
        }

        @Override
        public double nextDown(double d) {
            BumpNumber num = new BumpNumber(d);
            num.bumpDown();
            return num.getValue();
        }

        @Override
        public double nextUp(double d) {
            BumpNumber num = new BumpNumber(d);
            num.bumpUp();
            return num.getValue();
        }
    }

    private static class AsinhScaleType
    extends ScaleType {
        private static final Param A = new Log10Param("a", 1.0, "Aprox limit of linear-like region");

        AsinhScaleType() {
            super("asinh", new Param[]{A});
        }

        @Override
        public String getDescription() {
            return String.join((CharSequence)"\n", "Scaling based on inverse hyperbolic sin function.", "This is approximately linear near the origin,", "and approximately logarithmic far from it.", "It has one parameter, the \"linear width\" <code>a</code>,", "which controls the extent of the linear-like region,", "and must be strictly positive.", "The function is <code>x-&gt;asinh(x/a)</code>.");
        }

        @Override
        public Scale createScale(double[] args) {
            final double a = this.fillInArgs(args)[0];
            if (!(a > 0.0)) {
                throw new IllegalArgumentException("Non-positive asinh argument");
            }
            final double a1 = 1.0 / a;
            return new AbstractScale(this, args){
                final Ticker ticker_;
                {
                    super(type, paramValues);
                    this.ticker_ = BasicTicker.createHybridTicker(this, a);
                }

                @Override
                public boolean isPositiveDefinite() {
                    return false;
                }

                @Override
                public boolean isLinear() {
                    return false;
                }

                @Override
                public Rounder getScaleRounder() {
                    return DUMMY_ROUNDER;
                }

                @Override
                public Ticker getTicker() {
                    return this.ticker_;
                }

                @Override
                public double dataToScale(double d) {
                    return AsinhScaleType.asinh(d * a1);
                }

                @Override
                public double scaleToData(double s) {
                    return a * AsinhScaleType.sinh(s);
                }

                @Override
                public String dataToScaleExpression(String var) {
                    return new StringBuffer().append("asinh(").append(var).append("/").append(a).append(")").toString();
                }
            };
        }

        private static double sinh(double x) {
            return Math.sinh(x);
        }

        private static double asinh(double x) {
            return Maths.asinh(x);
        }
    }

    private static class SymlogScaleType
    extends ScaleType {
        private static final Param LINTHRESH = new Log10Param("t", 1.0, "Limit of linear region (linthresh)");
        private static final Param LINSCALE = new LinscaleParam("s", 1.0, "Extent of positive linear region in decades (linscale)");

        SymlogScaleType() {
            super("symlog", new Param[]{LINTHRESH, LINSCALE});
        }

        @Override
        public String getDescription() {
            return String.join((CharSequence)"\n", "Symmetric logarithmic scale.", "This is linear near the origin, and positive/negative", "logarithmic for larger values.", "It has two parameters,", "<code>t</code> (a.k.a. <code>linthresh</code>) and", "<code>s</code> (a.k.a. <code>linscale</code>).", "Both parameters must be strictly positive.", "The linear region is in the range", "<code>-t&lt;x&lt;+t</code>,", "and the graphical extent of the region from the origin", "to <code>t</code> is the same as", "<code>s</code> decades in the logarithmic region.");
        }

        @Override
        public Scale createScale(double[] args) {
            args = this.fillInArgs(args);
            double linthresh = args[0];
            double linscale = args[1];
            return new SymlogScale(linthresh, linscale);
        }

        private class SymlogScale
        extends AbstractScale {
            private final double linthresh_;
            private final double linscale_;
            private final double log10thresh_;
            private final double scaleOverThresh_;
            private final double threshOverScale_;
            private final Ticker ticker_;

            SymlogScale(double linthresh, double linscale) {
                super(SymlogScaleType.this, new double[]{linthresh, linscale});
                if (!(linthresh > 0.0) || !(linscale > 0.0)) {
                    throw new IllegalArgumentException("Non-positive symlog arguments");
                }
                this.linthresh_ = linthresh;
                this.linscale_ = linscale;
                this.log10thresh_ = ScaleType.log10(linthresh);
                this.scaleOverThresh_ = linscale / linthresh;
                this.threshOverScale_ = linthresh / linscale;
                this.ticker_ = BasicTicker.createHybridTicker(this, linthresh);
            }

            @Override
            public boolean isPositiveDefinite() {
                return false;
            }

            @Override
            public boolean isLinear() {
                return false;
            }

            @Override
            public Ticker getTicker() {
                return this.ticker_;
            }

            @Override
            public Rounder getScaleRounder() {
                return DUMMY_ROUNDER;
            }

            @Override
            public double dataToScale(double d) {
                if (d < -this.linthresh_) {
                    return -this.linscale_ - ScaleType.log10(-d) + this.log10thresh_;
                }
                if (d > this.linthresh_) {
                    return this.linscale_ + ScaleType.log10(d) - this.log10thresh_;
                }
                return d * this.scaleOverThresh_;
            }

            @Override
            public double scaleToData(double s) {
                if (s < -this.linscale_) {
                    return -this.linthresh_ * ScaleType.pow10(-s - this.linscale_);
                }
                if (s > this.linscale_) {
                    return this.linthresh_ * ScaleType.pow10(s - this.linscale_);
                }
                return s * this.threshOverScale_;
            }

            @Override
            public String dataToScaleExpression(String var) {
                return new StringBuffer().append("symlog(").append(this.linthresh_).append(",").append(this.linscale_).append(",").append(var).append(")").toString();
            }
        }
    }

    private static class LogScaleType
    extends ScaleType {
        private final Scale scale_;

        LogScaleType() {
            super("log", new Param[0]);
            final Rounder rounder = new Rounder(){

                @Override
                public double round(double value) {
                    return ScaleType.log10(Rounder.LOG.round(ScaleType.pow10(value)));
                }

                @Override
                public double nextUp(double value) {
                    return ScaleType.log10(Rounder.LOG.nextUp(ScaleType.pow10(value)));
                }

                @Override
                public double nextDown(double value) {
                    return ScaleType.log10(Rounder.LOG.nextDown(ScaleType.pow10(value)));
                }
            };
            this.scale_ = new AbstractScale(this, new double[0]){

                @Override
                public boolean isPositiveDefinite() {
                    return true;
                }

                @Override
                public boolean isLinear() {
                    return false;
                }

                @Override
                public Ticker getTicker() {
                    return BasicTicker.LOG;
                }

                @Override
                public Rounder getScaleRounder() {
                    return rounder;
                }

                @Override
                public double dataToScale(double d) {
                    return ScaleType.log10(d);
                }

                @Override
                public double scaleToData(double s) {
                    return ScaleType.pow10(s);
                }

                @Override
                public String dataToScaleExpression(String var) {
                    return "log10(" + var + ")";
                }
            };
        }

        @Override
        public String getDescription() {
            return "Logarithmic scale";
        }

        @Override
        public Scale createScale(double[] args) {
            return this.scale_;
        }
    }

    private static class LinearScaleType
    extends ScaleType {
        private final Scale scale_;

        LinearScaleType(String name, final Rounder rounder) {
            super(name, new Param[0]);
            this.scale_ = new AbstractScale(this, new double[0]){

                @Override
                public boolean isPositiveDefinite() {
                    return false;
                }

                @Override
                public boolean isLinear() {
                    return true;
                }

                @Override
                public Ticker getTicker() {
                    return BasicTicker.LINEAR;
                }

                @Override
                public Rounder getScaleRounder() {
                    return rounder;
                }

                @Override
                public double dataToScale(double d) {
                    return d;
                }

                @Override
                public double scaleToData(double s) {
                    return s;
                }

                @Override
                public String dataToScaleExpression(String var) {
                    return var;
                }
            };
        }

        @Override
        public String getDescription() {
            return "Linear scale";
        }

        @Override
        public Scale createScale(double[] args) {
            return this.scale_;
        }
    }

    private static abstract class AbstractScale
    implements Scale {
        private final ScaleType type_;
        private final double[] paramValues_;

        protected AbstractScale(ScaleType type, double[] paramValues) {
            this.type_ = type;
            this.paramValues_ = type.fillInArgs(paramValues);
        }

        @Override
        public ScaleType getScaleType() {
            return this.type_;
        }

        @Override
        public double[] getParamValues() {
            return this.paramValues_;
        }

        public int hashCode() {
            int code = 992210;
            code = 23 * code + this.type_.hashCode();
            code = 23 * code + Arrays.hashCode(this.paramValues_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof AbstractScale) {
                AbstractScale other = (AbstractScale)o;
                return this.type_ == other.type_ && Arrays.equals(this.paramValues_, other.paramValues_);
            }
            return false;
        }

        public String toString() {
            String typeName = this.type_.getName();
            return this.paramValues_.length > 0 ? new ParsedFunctionCall(typeName, this.paramValues_).toString() : typeName;
        }
    }

    public static abstract class Param {
        private final String name_;
        private final double dflt_;
        private final String description_;

        public Param(String name, double dflt, String description) {
            this.name_ = name;
            this.dflt_ = dflt;
            this.description_ = description;
        }

        public String getName() {
            return this.name_;
        }

        public double getDefault() {
            return this.dflt_;
        }

        public String getDescription() {
            return this.description_;
        }

        public abstract double nextDown(double var1);

        public abstract double nextUp(double var1);

        public String toString() {
            return this.name_;
        }
    }
}

