/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;

@Equality
public class SubCloud {
    private final DataGeom geom_;
    private final DataSpec spec_;
    private final int iPosCoord_;

    public SubCloud(DataGeom geom, DataSpec spec, int iPosCoord) {
        this.geom_ = geom;
        this.spec_ = spec;
        this.iPosCoord_ = iPosCoord;
    }

    public DataGeom getDataGeom() {
        return this.geom_;
    }

    public DataSpec getDataSpec() {
        return this.spec_;
    }

    public int getPosCoordIndex() {
        return this.iPosCoord_;
    }

    public int hashCode() {
        int code = 7701;
        code = 23 * code + this.geom_.hashCode();
        code = 23 * code + this.spec_.getSourceTable().hashCode();
        code = 23 * code + this.spec_.getMaskId().hashCode();
        code = 23 * code + Arrays.hashCode(this.getCoordIds());
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof SubCloud) {
            SubCloud other = (SubCloud)o;
            return this.geom_.equals(other.geom_) && this.spec_.getSourceTable().equals(other.spec_.getSourceTable()) && this.spec_.getMaskId().equals(other.spec_.getMaskId()) && Arrays.equals(this.getCoordIds(), other.getCoordIds());
        }
        return false;
    }

    private Object[] getCoordIds() {
        int npc = this.geom_.getPosCoords().length;
        Object[] ids = new Object[npc];
        for (int ipc = 0; ipc < npc; ++ipc) {
            ids[ipc] = this.spec_.getCoordId(this.iPosCoord_ + ipc);
        }
        return ids;
    }

    public static SubCloud[] createSubClouds(PlotLayer[] layers, boolean deduplicate) {
        Collection<SubCloud> subClouds = SubCloud.createCollection(deduplicate);
        int nl = layers.length;
        int ndim0 = -1;
        for (int il = 0; il < nl; ++il) {
            int icPos;
            int ipos;
            PlotLayer layer = layers[il];
            DataGeom geom = layer.getDataGeom();
            DataSpec spec = layer.getDataSpec();
            CoordGroup cgrp = layer.getPlotter().getCoordGroup();
            if (geom == null || spec == null) continue;
            for (ipos = 0; ipos < cgrp.getBasicPositionCount(); ++ipos) {
                icPos = cgrp.getPosCoordIndex(ipos, geom);
                subClouds.add(new SubCloud(geom, spec, icPos));
            }
            for (ipos = 0; ipos < cgrp.getExtraPositionCount(); ++ipos) {
                icPos = cgrp.getExtraCoordIndex(ipos, geom);
                subClouds.add(new SubCloud(geom, spec, icPos));
            }
            int ndim = geom.getDataDimCount();
            if (ndim0 < 0) {
                ndim0 = ndim;
                continue;
            }
            if (ndim == ndim0) continue;
            throw new IllegalArgumentException("dimensionality mismatch");
        }
        return subClouds.toArray(new SubCloud[0]);
    }

    public static SubCloud[] createPartialSubClouds(PlotLayer[] layers, boolean deduplicate) {
        Collection<SubCloud> subClouds = SubCloud.createCollection(deduplicate);
        for (PlotLayer layer : layers) {
            CoordGroup cgrp;
            DataGeom dataGeom = layer.getDataGeom();
            DataSpec dataSpec = layer.getDataSpec();
            if (dataGeom == null || dataSpec == null || !(cgrp = layer.getPlotter().getCoordGroup()).isSinglePartialPosition()) continue;
            assert (cgrp.getBasicPositionCount() == 0);
            subClouds.add(new SubCloud(dataGeom, dataSpec, 0));
        }
        return subClouds.toArray(new SubCloud[0]);
    }

    public static SubCloud[] createSubClouds(DataGeom geom, DataSpec spec, int npos, boolean deduplicate) {
        Collection<SubCloud> subClouds = SubCloud.createCollection(deduplicate);
        if (geom != null && spec != null && npos > 0) {
            int npc = geom.getPosCoords().length;
            for (int ip = 0; ip < npos; ++ip) {
                subClouds.add(new SubCloud(geom, spec, ip * npc));
            }
        }
        return subClouds.toArray(new SubCloud[0]);
    }

    private static Collection<SubCloud> createCollection(boolean deduplicate) {
        return deduplicate ? new LinkedHashSet() : new ArrayList();
    }
}

