/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Graphics2D;
import uk.ac.starlink.ttools.plot2.Equality;

public abstract class TickLook {
    private final String name_;
    public static final TickLook CLASSIC = TickLook.createClassicLook("classic", 2);
    public static final TickLook STANDARD = TickLook.createStandardLook("standard", 2);
    public static final TickLook NONE = new TickLook("none"){

        @Override
        public void drawMinor(Graphics2D g2) {
        }

        @Override
        public void drawMajor(Graphics2D g2) {
        }
    };

    protected TickLook(String name) {
        this.name_ = name;
    }

    public abstract void drawMinor(Graphics2D var1);

    public abstract void drawMajor(Graphics2D var1);

    public String getName() {
        return this.name_;
    }

    public String toString() {
        return this.name_;
    }

    public static TickLook createClassicLook(String name, int unit) {
        return new LineTickLook(name, 0, unit, -unit, unit);
    }

    public static TickLook createStandardLook(String name, int unit) {
        return new LineTickLook(name, 0, unit, 0, 2 * unit);
    }

    @Equality
    private static class LineTickLook
    extends TickLook {
        private final int minLo_;
        private final int minHi_;
        private final int majLo_;
        private final int majHi_;

        public LineTickLook(String name, int minLo, int minHi, int majLo, int majHi) {
            super(name);
            this.minLo_ = minLo;
            this.minHi_ = minHi;
            this.majLo_ = majLo;
            this.majHi_ = majHi;
        }

        @Override
        public void drawMinor(Graphics2D g2) {
            g2.drawLine(0, this.minLo_, 0, this.minHi_);
        }

        @Override
        public void drawMajor(Graphics2D g2) {
            g2.drawLine(0, this.majLo_, 0, this.majHi_);
        }

        public int hashCode() {
            int code = 99801;
            code = 23 * code + this.minLo_;
            code = 23 * code + this.minHi_;
            code = 23 * code + this.majLo_;
            code = 23 * code + this.majHi_;
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof LineTickLook) {
                LineTickLook other = (LineTickLook)o;
                return this.minLo_ == other.minLo_ && this.minHi_ == other.minHi_ && this.majLo_ == other.majLo_ && this.majHi_ == other.majHi_;
            }
            return false;
        }
    }
}

