/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import uk.ac.starlink.ttools.plot2.BasicCaptioner;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.LatexCaptioner;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.IntegerConfigKey;
import uk.ac.starlink.ttools.plot2.config.KeySet;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;

public class CaptionerKeySet
implements KeySet<Captioner> {
    private final ConfigKey<TextSyntax> textSyntaxKey_;
    private final ConfigKey<Integer> fontSizeKey_;
    private final ConfigKey<FontType> fontTypeKey_;
    private final ConfigKey<FontWeight> fontWeightKey_;
    public static boolean PREFER_PHYSICAL_FONT = false;

    public CaptionerKeySet() {
        ConfigMeta syntaxMeta = new ConfigMeta("texttype", "Text Type");
        syntaxMeta.setShortDescription("Text interpretation");
        syntaxMeta.setXmlDescription(new String[]{"<p>Determines how to turn label text into characters", "on the plot.", "<code>" + (Object)((Object)TextSyntax.PLAIN) + "</code> and", "<code>" + (Object)((Object)TextSyntax.AAPLAIN) + "</code>", "both take the text at face value,", "but <code>" + (Object)((Object)TextSyntax.AAPLAIN) + "</code>", "smooths the characters.", "<code>" + (Object)((Object)TextSyntax.LATEX) + "</code>", "interprets the text as LaTeX source code", "and typesets it accordingly.", "</p>", "<p>When not using LaTeX, antialiased text usually looks nicer,", "but can be perceptibly slower to plot.", "At time of writing, on MacOS antialiased text", "seems to be required to stop the writing coming out", "upside-down for non-horizontal text (MacOS java bug).", "</p>"});
        TextSyntax syntaxDflt = PlotUtil.getDefaultTextAntialiasing() ? TextSyntax.AAPLAIN : TextSyntax.PLAIN;
        this.textSyntaxKey_ = new OptionConfigKey<TextSyntax>(syntaxMeta, TextSyntax.class, TextSyntax.values(), syntaxDflt, true){

            @Override
            public String getXmlDescription(TextSyntax syntax) {
                return null;
            }
        }.setOptionUsage();
        ConfigMeta sizeMeta = new ConfigMeta("fontsize", "Font Size");
        sizeMeta.setShortDescription("Font size in points");
        sizeMeta.setXmlDescription(new String[]{"<p>Size of the text font in points.", "</p>"});
        this.fontSizeKey_ = IntegerConfigKey.createSpinnerKey(sizeMeta, 12, 2, 64);
        ConfigMeta typeMeta = new ConfigMeta("fontstyle", "Font Style");
        typeMeta.setShortDescription("Font style");
        typeMeta.setXmlDescription(new String[]{"<p>Font style for text.", "</p>"});
        this.fontTypeKey_ = new OptionConfigKey<FontType>(typeMeta, FontType.class, FontType.values()){

            @Override
            public String getXmlDescription(FontType ft) {
                return null;
            }
        }.setOptionUsage().addOptionsXml();
        ConfigMeta weightMeta = new ConfigMeta("fontweight", "Font Weight");
        weightMeta.setShortDescription("Font weight");
        weightMeta.setXmlDescription(new String[]{"<p>Font weight for text.", "</p>"});
        this.fontWeightKey_ = new OptionConfigKey<FontWeight>(weightMeta, FontWeight.class, FontWeight.values()){

            @Override
            public String getXmlDescription(FontWeight fw) {
                return null;
            }
        }.setOptionUsage().addOptionsXml();
    }

    @Override
    public ConfigKey<?>[] getKeys() {
        return new ConfigKey[]{this.textSyntaxKey_, this.fontSizeKey_, this.fontTypeKey_, this.fontWeightKey_};
    }

    @Override
    public Captioner createValue(ConfigMap config) {
        TextSyntax syntax = config.get(this.textSyntaxKey_);
        int size = config.get(this.fontSizeKey_);
        FontType type = config.get(this.fontTypeKey_);
        FontWeight weight = config.get(this.fontWeightKey_);
        return syntax.createCaptioner(type, weight, size);
    }

    private static enum TextSyntax {
        PLAIN("Plain"){

            @Override
            public Captioner createCaptioner(FontType type, FontWeight weight, int size) {
                return new BasicCaptioner(new Font(type.awtName_, weight.awtWeight_, size), false);
            }
        }
        ,
        AAPLAIN("Antialias"){

            @Override
            public Captioner createCaptioner(FontType type, FontWeight weight, int size) {
                return new BasicCaptioner(new Font(type.awtName_, weight.awtWeight_, size), true);
            }
        }
        ,
        LATEX("LaTeX"){

            @Override
            public Captioner createCaptioner(FontType type, FontWeight weight, int size) {
                return new LatexCaptioner(size, type.texType_ | weight.texWeight_);
            }
        };

        private final String name_;

        private TextSyntax(String name) {
            this.name_ = name;
        }

        public abstract Captioner createCaptioner(FontType var1, FontWeight var2, int var3);

        public String toString() {
            return this.name_;
        }
    }

    private static enum FontWeight {
        PLAIN("Plain", 0, 0),
        BOLD("Bold", 1, 2),
        ITALIC("Italic", 2, 4),
        BOLDITALIC("Bold Italic", 3, 6);

        private final String name_;
        private final int awtWeight_;
        private final int texWeight_;

        private FontWeight(String name, int awtWeight, int texWeight) {
            this.name_ = name;
            this.awtWeight_ = awtWeight;
            this.texWeight_ = texWeight;
        }

        public String toString() {
            return this.name_;
        }
    }

    private static enum FontType {
        SANSSERIF("Standard", "Dialog", "Lucida Sans", 1),
        SERIF("Serif", "Serif", "Lucida Bright", 8),
        MONO("Mono", "Monospaced", "Lucida Sans Typewriter", 16);

        private final String name_;
        private final String awtName_;
        private final int texType_;

        private FontType(String name, String logicalName, String physicalName, int texType) {
            this.name_ = name;
            this.awtName_ = PREFER_PHYSICAL_FONT && FontType.existsFontFamily(physicalName) ? physicalName : logicalName;
            this.texType_ = texType;
        }

        public String toString() {
            return this.name_;
        }

        private static boolean existsFontFamily(String ffName) {
            for (String name : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                if (!name.equals(ffName)) continue;
                return true;
            }
            return false;
        }
    }
}

