/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComboBox;
import uk.ac.starlink.ttools.gui.DashComboBox;
import uk.ac.starlink.ttools.plot2.config.ChoiceConfigKey;
import uk.ac.starlink.ttools.plot2.config.ComboBoxSpecifier;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.Specifier;

public class DashConfigKey
extends ChoiceConfigKey<float[]> {
    private static final Map<String, float[]> FIXED_MAP = DashConfigKey.createDashMap();

    public DashConfigKey(ConfigMeta meta) {
        super(meta, float[].class, null, true);
        this.getOptionMap().putAll(FIXED_MAP);
    }

    @Override
    public float[] decodeString(String sval) {
        try {
            String[] parts = sval.split(",");
            int np = parts.length;
            float[] fs = new float[np];
            for (int i = 0; i < np; ++i) {
                fs[i] = Float.parseFloat(parts[i]);
            }
            return fs;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String stringifyValue(float[] dash) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < dash.length; ++i) {
            float f;
            if (sbuf.length() > 0) {
                sbuf.append(",");
            }
            sbuf.append((f = dash[i]) == (float)((int)f) ? Integer.toString((int)f) : Float.toString(f));
        }
        return sbuf.toString();
    }

    @Override
    public Specifier<float[]> createSpecifier() {
        return new ComboBoxSpecifier<float[]>(float[].class, (JComboBox<float[]>)((Object)new DashComboBox()));
    }

    public static ConfigMeta createDashMeta(String shortName, String longName) {
        ConfigMeta meta = new ConfigMeta(shortName, longName);
        meta.setStringUsage("dot|dash|...|<a,b,...>");
        meta.setShortDescription("Line dash pattern");
        StringBuffer nameList = new StringBuffer();
        for (String name : FIXED_MAP.keySet()) {
            if (nameList.length() > 0) {
                nameList.append(", ");
            }
            nameList.append("<code>").append(name).append("</code>");
        }
        meta.setXmlDescription(new String[]{"<p>Determines the dash pattern of the line drawn.", "If null (the default), the line is solid.", "</p>", "<p>Possible values for dashed lines are", nameList.toString() + ".", "You can alternatively supply a comma-separated list", "of on/off length values such as", "\"<code>4,2,8,2</code>\".", "</p>"});
        return meta;
    }

    private static final Map<String, float[]> createDashMap() {
        LinkedHashMap<String, float[]> map = new LinkedHashMap<String, float[]>();
        map.put("dot", new float[]{1.0f, 2.0f});
        map.put("dash", new float[]{4.0f, 2.0f});
        map.put("longdash", new float[]{8.0f, 4.0f});
        map.put("dotdash", new float[]{12.0f, 3.0f, 3.0f, 3.0f});
        return Collections.unmodifiableMap(map);
    }
}

