/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.SliderSpecifier;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.SpecifierPanel;
import uk.ac.starlink.ttools.plot2.config.TextFieldSpecifier;

public abstract class DoubleConfigKey
extends ConfigKey<Double> {
    protected DoubleConfigKey(ConfigMeta meta, double dflt) {
        super(meta, Double.class, dflt);
        if (meta.getStringUsage() == null) {
            meta.setStringUsage("<number>");
        }
    }

    @Override
    public String valueToString(Double value) {
        return value == null ? "" : DoubleConfigKey.doubleToString(value);
    }

    @Override
    public Double stringToValue(String txt) throws ConfigException {
        return DoubleConfigKey.stringToDouble(txt, this);
    }

    public static DoubleConfigKey createTextKey(ConfigMeta meta) {
        return DoubleConfigKey.createTextKey(meta, Double.NaN);
    }

    public static DoubleConfigKey createTextKey(ConfigMeta meta, double dflt) {
        return new DoubleConfigKey(meta, dflt){

            @Override
            public Specifier<Double> createSpecifier() {
                return new TextFieldSpecifier<Double>(this, Double.NaN);
            }
        };
    }

    public static DoubleConfigKey createToggleKey(ConfigMeta meta, final double fval, final double tval) {
        return new DoubleConfigKey(meta, fval){

            @Override
            public Specifier<Double> createSpecifier() {
                return new ToggleSpecifier(fval, tval);
            }
        };
    }

    public static DoubleConfigKey createSliderKey(ConfigMeta meta, double dflt, double lo, double hi, boolean log) {
        return DoubleConfigKey.createSliderKey(meta, dflt, lo, hi, log, false, SliderSpecifier.TextOption.NONE);
    }

    public static DoubleConfigKey createSliderKey(ConfigMeta meta, final double dflt, final double lo, final double hi, final boolean log, final boolean flip, final SliderSpecifier.TextOption txtOpt) {
        return new DoubleConfigKey(meta, dflt){

            @Override
            public Specifier<Double> createSpecifier() {
                return new SliderSpecifier(lo, hi, log, dflt, flip, txtOpt);
            }
        };
    }

    public static String doubleToString(double dval) {
        if (Double.isNaN(dval)) {
            return "";
        }
        int ival = (int)dval;
        if ((double)ival == dval) {
            return Integer.toString(ival);
        }
        return Double.toString(dval);
    }

    public static double stringToDouble(String txt, ConfigKey<?> key) throws ConfigException {
        if (txt == null || txt.trim().length() == 0) {
            return Double.NaN;
        }
        try {
            return Double.valueOf(txt.trim());
        }
        catch (NumberFormatException e) {
            throw new ConfigException(key, "\"" + txt + "\" not numeric", e);
        }
    }

    private static class ToggleSpecifier
    extends SpecifierPanel<Double> {
        private final Double fVal_;
        private final Double tVal_;
        private final JCheckBox checkBox_;

        ToggleSpecifier(double fval, double tval) {
            super(false);
            this.fVal_ = fval;
            this.tVal_ = tval;
            this.checkBox_ = new JCheckBox();
        }

        @Override
        protected JComponent createComponent() {
            this.checkBox_.addActionListener(this.getActionForwarder());
            return this.checkBox_;
        }

        @Override
        public Double getSpecifiedValue() {
            return this.checkBox_.isSelected() ? this.tVal_ : this.fVal_;
        }

        @Override
        public void setSpecifiedValue(Double value) {
            if (value == null) {
                value = Double.NaN;
            }
            if (value.equals(this.fVal_)) {
                this.checkBox_.setSelected(false);
            } else if (value.equals(this.tVal_)) {
                this.checkBox_.setSelected(true);
            }
            this.fireAction();
        }

        @Override
        public void submitReport(ReportMap report) {
        }
    }
}

