/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.ErrorModeSelection;
import uk.ac.starlink.ttools.plot2.config.ComboBoxSpecifier;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.layer.MultiPointShape;
import uk.ac.starlink.util.IconUtils;

public class MultiPointConfigKey
extends OptionConfigKey<MultiPointShape> {
    private final MultiPointShape[] shapes_;
    private final ErrorMode[] modes_;

    public MultiPointConfigKey(ConfigMeta meta, MultiPointShape[] shapes, ErrorMode[] modes) {
        super(meta, MultiPointShape.class, shapes, MultiPointConfigKey.chooseDefault(shapes));
        this.shapes_ = shapes;
        this.modes_ = modes;
    }

    @Override
    public String getXmlDescription(MultiPointShape shape) {
        return null;
    }

    public ErrorMode[] getErrorModes() {
        return this.modes_;
    }

    @Override
    public Specifier<MultiPointShape> createSpecifier() {
        int naxis = this.modes_.length;
        ErrorModeSelection[] modeSelections = new ErrorModeSelection[naxis];
        for (int ia = 0; ia < naxis; ++ia) {
            final ErrorMode mode = this.modes_[ia];
            modeSelections[ia] = new ErrorModeSelection(){

                @Override
                public ErrorMode getErrorMode() {
                    return mode;
                }

                @Override
                public void addActionListener(ActionListener listener) {
                }

                @Override
                public void removeActionListener(ActionListener listener) {
                }
            };
        }
        MultiPointShapeComboBoxModel model = new MultiPointShapeComboBoxModel(this.shapes_, (MultiPointShape)this.getDefaultValue(), modeSelections);
        MultiPointShapeRenderer renderer = new MultiPointShapeRenderer(modeSelections);
        JComboBox<MultiPointShape> shapeComboBox = new JComboBox<MultiPointShape>(model);
        shapeComboBox.setRenderer(renderer);
        return new ComboBoxSpecifier<MultiPointShape>(MultiPointShape.class, shapeComboBox){

            @Override
            public String stringify(MultiPointShape value) {
                return MultiPointConfigKey.this.valueToString(value);
            }
        };
    }

    private static MultiPointShape chooseDefault(MultiPointShape[] shapes) {
        for (int ir = 0; ir < shapes.length; ++ir) {
            MultiPointShape shape = shapes[ir];
            if (shape == null || shape == MultiPointShape.NONE) continue;
            return shape;
        }
        assert (false);
        return MultiPointShape.DEFAULT;
    }

    private static class MultiPointShapeRenderer
    implements ListCellRenderer<MultiPointShape> {
        private final ErrorModeSelection[] errModeSelections_;
        private final BasicComboBoxRenderer baseRenderer_;

        MultiPointShapeRenderer(ErrorModeSelection[] errorModeSelections) {
            this.errModeSelections_ = errorModeSelections;
            this.baseRenderer_ = new BasicComboBoxRenderer();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends MultiPointShape> list, MultiPointShape shape, int index, boolean isSelected, boolean hasFocus) {
            Component c = this.baseRenderer_.getListCellRendererComponent(list, shape, index, isSelected, hasFocus);
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                Icon icon = null;
                ErrorMode[] modes = new ErrorMode[this.errModeSelections_.length];
                for (int imode = 0; imode < modes.length; ++imode) {
                    modes[imode] = this.errModeSelections_[imode].getErrorMode();
                }
                icon = shape.getLegendIcon(shape.createScribe(0), modes, 40, 15, 5, 1);
                label.setText((icon = IconUtils.colorIcon((Icon)icon, (Color)c.getForeground())) == null ? "??" : null);
                label.setIcon(icon);
            }
            return c;
        }
    }

    private static class MultiPointShapeComboBoxModel
    extends AbstractListModel<MultiPointShape>
    implements ComboBoxModel<MultiPointShape>,
    ActionListener {
        private final MultiPointShape[] allShapes_;
        private final MultiPointShape defaultShape_;
        private final ErrorModeSelection[] modeSelections_;
        private List<MultiPointShape> activeShapeList_;
        private MultiPointShape selected_;

        MultiPointShapeComboBoxModel(MultiPointShape[] shapes, MultiPointShape defaultShape, ErrorModeSelection[] modeSelections) {
            this.allShapes_ = shapes;
            this.defaultShape_ = defaultShape;
            this.modeSelections_ = modeSelections;
            this.selected_ = defaultShape;
            this.updateState();
            for (int idim = 0; idim < modeSelections.length; ++idim) {
                modeSelections[idim].addActionListener(this);
            }
        }

        @Override
        public MultiPointShape getElementAt(int index) {
            return this.activeShapeList_.get(index);
        }

        @Override
        public int getSize() {
            return this.activeShapeList_.size();
        }

        @Override
        public Object getSelectedItem() {
            return this.selected_;
        }

        @Override
        public void setSelectedItem(Object item) {
            if (!this.activeShapeList_.contains(item) || !(item instanceof MultiPointShape)) {
                throw new IllegalArgumentException("No such selection " + item);
            }
            this.selected_ = (MultiPointShape)item;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.updateState();
        }

        private void updateState() {
            int ndim = 0;
            for (int idim = 0; idim < this.modeSelections_.length; ++idim) {
                if (ErrorMode.NONE.equals(this.modeSelections_[idim].getErrorMode())) continue;
                ++ndim;
            }
            ArrayList<MultiPointShape> shapeList = new ArrayList<MultiPointShape>();
            for (int ir = 0; ir < this.allShapes_.length; ++ir) {
                MultiPointShape shape = this.allShapes_[ir];
                if (!shape.supportsDimensionality(ndim)) continue;
                shapeList.add(shape);
            }
            if (!shapeList.contains(this.selected_)) {
                this.selected_ = this.defaultShape_;
            }
            this.activeShapeList_ = shapeList;
            this.fireContentsChanged(this, 0, this.activeShapeList_.size() - 1);
        }
    }
}

