/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.config.SpecifierPanel;

public class SliderSpecifier
extends SpecifierPanel<Double> {
    private final double lo_;
    private final double hi_;
    private final boolean log_;
    private final boolean flip_;
    private final double resetVal_;
    private final TextOption txtOpt_;
    private final boolean resetOpt_;
    private final JSlider slider_;
    private final JButton resetButton_;
    private final JTextField txtField_;
    private final JRadioButton sliderButton_;
    private final JRadioButton txtButton_;
    private static final int MIN = 0;
    private static final int MAX = 10000;
    private static final boolean DISPLAY_TEXT = false;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.config");

    public SliderSpecifier(double lo, double hi, boolean log, double reset) {
        this(lo, hi, log, reset, false, TextOption.NONE);
    }

    public SliderSpecifier(double lo, double hi, boolean log, final double reset, boolean flip, TextOption txtOpt) {
        super(true);
        this.lo_ = lo;
        this.hi_ = hi;
        this.log_ = log;
        this.flip_ = flip;
        this.resetVal_ = reset;
        this.txtOpt_ = txtOpt == null ? TextOption.NONE : txtOpt;
        this.slider_ = new JSlider(0, 10000){

            @Override
            public Dimension getMinimumSize() {
                return SliderSpecifier.minWidth(super.getMinimumSize(), 100);
            }
        };
        this.resetOpt_ = reset >= lo && reset <= hi;
        AbstractAction resetAct = new AbstractAction(null, ResourceIcon.ZERO){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SliderSpecifier.this.slider_.setValue(SliderSpecifier.this.unscale(reset));
            }
        };
        resetAct.putValue("ShortDescription", "Reset slider to default (" + this.resetVal_ + ")");
        this.resetButton_ = new JButton(resetAct);
        this.resetButton_.setMargin(new Insets(0, 0, 0, 0));
        this.txtField_ = new JTextField(8){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMinimumSize() {
                return SliderSpecifier.minWidth(super.getMinimumSize(), 60);
            }
        };
        this.sliderButton_ = new JRadioButton();
        this.txtButton_ = new JRadioButton();
        ButtonGroup bgrp = new ButtonGroup();
        bgrp.add(this.sliderButton_);
        bgrp.add(this.txtButton_);
        this.sliderButton_.setSelected(true);
    }

    @Override
    protected JComponent createComponent() {
        Box line = Box.createHorizontalBox();
        if (this.txtOpt_.hasTextField_) {
            line.add(this.sliderButton_);
        }
        line.add(this.slider_);
        if (this.resetOpt_) {
            line.add(Box.createHorizontalStrut(5));
            line.add(this.resetButton_);
        }
        if (this.txtOpt_.hasTextField_) {
            line.add(Box.createHorizontalStrut(10));
            line.add(this.txtButton_);
            line.add(this.txtField_);
        }
        final ActionListener actionForwarder = this.getActionForwarder();
        ActionListener radioListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SliderSpecifier.this.updateInputState();
                actionForwarder.actionPerformed(evt);
            }
        };
        this.txtButton_.addActionListener(radioListener);
        this.sliderButton_.addActionListener(radioListener);
        final ChangeListener changeForwarder = this.getChangeForwarder();
        this.slider_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SliderSpecifier.this.updateInputState();
                changeForwarder.stateChanged(evt);
            }
        });
        this.txtField_.addActionListener(actionForwarder);
        this.updateInputState();
        return line;
    }

    @Override
    public Double getSpecifiedValue() {
        double dval;
        if (!this.isSliderActive() && !Double.isNaN(dval = this.getTextValue())) {
            return dval;
        }
        return this.getSliderValue();
    }

    @Override
    public void setSpecifiedValue(Double dValue) {
        if (dValue != null) {
            double dval = dValue;
            if (this.isSliderActive()) {
                this.slider_.setValue(this.unscale(dval));
            } else {
                this.txtField_.setText(Float.toString((float)dval));
                this.txtField_.setCaretPosition(0);
            }
        }
    }

    @Override
    public void submitReport(ReportMap report) {
    }

    public boolean isSliderActive() {
        return this.sliderButton_.isSelected();
    }

    public void setSliderActive(boolean isActive) {
        this.sliderButton_.setSelected(isActive);
    }

    public double getTextValue() {
        String txt = this.txtField_.getText();
        if (txt != null && txt.trim().length() > 0) {
            try {
                return Double.parseDouble(txt.trim());
            }
            catch (NumberFormatException e) {
                this.txtField_.setText(null);
            }
        }
        return Double.NaN;
    }

    public double getSliderValue() {
        int iPixStep;
        double dPixStep;
        int i0 = this.slider_.getValue();
        double d0 = this.scale(i0);
        int npix = this.getSliderPixels();
        if (npix > 10 && (dPixStep = Math.abs(this.scale(i0 + (iPixStep = (this.slider_.getMaximum() - this.slider_.getMinimum()) / npix)) - d0)) > 0.0) {
            String numstr = PlotUtil.formatNumber(d0, dPixStep);
            try {
                return Double.parseDouble(numstr);
            }
            catch (NumberFormatException e) {
                logger_.info("Parse of formatted number failed: " + numstr);
            }
        }
        return d0;
    }

    private int getSliderPixels() {
        int npix = this.slider_.getOrientation() == 0 ? this.slider_.getWidth() : this.slider_.getHeight();
        return npix == 0 ? 200 : npix;
    }

    public JSlider getSlider() {
        return this.slider_;
    }

    public JTextField getTextField() {
        return this.txtField_;
    }

    public String valueToString(double value) {
        if (Double.isNaN(value)) {
            return "";
        }
        if (value == (double)((int)value)) {
            return Integer.toString((int)value);
        }
        return Double.toString(value);
    }

    private void updateInputState() {
        boolean sliderActive = this.isSliderActive();
        this.slider_.setEnabled(sliderActive);
        this.resetButton_.setEnabled(sliderActive);
        this.txtField_.setEnabled(!sliderActive);
        if (this.txtOpt_.isEchoValue_ && sliderActive) {
            this.txtField_.setText(this.valueToString(this.getSpecifiedValue()));
            this.txtField_.setCaretPosition(0);
        }
    }

    private double scale(int ival) {
        double f = (double)(ival - 0) / 10000.0;
        if (this.flip_) {
            f = 1.0 - f;
        }
        return this.log_ ? this.lo_ * Math.pow(this.hi_ / this.lo_, f) : this.lo_ + (this.hi_ - this.lo_) * f;
    }

    private int unscale(double dval) {
        double s;
        double d = s = this.log_ ? Math.log(dval / this.lo_) / Math.log(this.hi_ / this.lo_) : (dval - this.lo_) / (this.hi_ - this.lo_);
        if (this.flip_) {
            s = 1.0 - s;
        }
        return (int)Math.round(s * 10000.0 + 0.0);
    }

    private static Dimension minWidth(Dimension size, int minWidth) {
        return new Dimension(Math.max(minWidth, size.width), size.height);
    }

    public static final class TextOption
    extends Enum<TextOption> {
        public static final /* enum */ TextOption NONE = new TextOption(false, false);
        public static final /* enum */ TextOption ENTER = new TextOption(true, false);
        public static final /* enum */ TextOption ENTER_ECHO = new TextOption(true, true);
        private final boolean hasTextField_;
        private final boolean isEchoValue_;
        private static final /* synthetic */ TextOption[] $VALUES;

        public static TextOption[] values() {
            return (TextOption[])$VALUES.clone();
        }

        public static TextOption valueOf(String name) {
            return Enum.valueOf(TextOption.class, name);
        }

        private TextOption(boolean hasTextField, boolean isEchoValue) {
            this.hasTextField_ = hasTextField;
            this.isEchoValue_ = isEchoValue;
            assert (this.hasTextField_ || !this.isEchoValue_);
        }

        static {
            $VALUES = new TextOption[]{NONE, ENTER, ENTER_ECHO};
        }
    }
}

