/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComboBox;
import uk.ac.starlink.ttools.gui.MarkStyleSelectors;
import uk.ac.starlink.ttools.gui.ThicknessComboBox;
import uk.ac.starlink.ttools.plot.BarStyle;
import uk.ac.starlink.ttools.plot.BarStyles;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot2.Anchor;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.config.BooleanConfigKey;
import uk.ac.starlink.ttools.plot2.config.CaptionerKeySet;
import uk.ac.starlink.ttools.plot2.config.ClippedShader;
import uk.ac.starlink.ttools.plot2.config.ColorConfigKey;
import uk.ac.starlink.ttools.plot2.config.ComboBoxSpecifier;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.DashConfigKey;
import uk.ac.starlink.ttools.plot2.config.DoubleConfigKey;
import uk.ac.starlink.ttools.plot2.config.IntegerConfigKey;
import uk.ac.starlink.ttools.plot2.config.KeySet;
import uk.ac.starlink.ttools.plot2.config.MultiPointConfigKey;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.RampKeySet;
import uk.ac.starlink.ttools.plot2.config.SliderSpecifier;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.StringConfigKey;
import uk.ac.starlink.ttools.plot2.config.SubrangeConfigKey;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurfaceFactory;
import uk.ac.starlink.ttools.plot2.layer.BasicXYShape;
import uk.ac.starlink.ttools.plot2.layer.Cumulation;
import uk.ac.starlink.ttools.plot2.layer.FatMarkerShapes;
import uk.ac.starlink.ttools.plot2.layer.FillMode;
import uk.ac.starlink.ttools.plot2.layer.LevelMode;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.layer.MultiPointShape;
import uk.ac.starlink.ttools.plot2.layer.Normalisation;
import uk.ac.starlink.ttools.plot2.layer.XYShape;
import uk.ac.starlink.util.gui.RenderingComboBox;

public class StyleKeys {
    private static final MarkerShape[] MARKER_SHAPES = StyleKeys.createMarkerShapes();
    public static final ConfigKey<MarkerShape> MARKER_SHAPE = StyleKeys.createMarkerShapeKey(new ConfigMeta("shape", "Shape").setShortDescription("Marker shape").setXmlDescription(new String[]{"<p>Sets the shape of markers that are plotted", "at each position of the scatter plot.", "</p>"}), MarkerShape.FILLED_CIRCLE);
    public static final ConfigKey<Integer> SIZE = StyleKeys.createMarkSizeKey(new ConfigMeta("size", "Size").setStringUsage("<pixels>").setShortDescription("Marker size in pixels").setXmlDescription(new String[]{"<p>Size of the scatter plot markers.", "The unit is pixels, in most cases the marker", "is approximately twice the size", "of the supplied value.", "</p>"}), 1);
    private static final BasicXYShape[] XYSHAPES = BasicXYShape.getXYShapes();
    public static final ConfigKey<BasicXYShape> XYSHAPE = new OptionConfigKey<BasicXYShape>(new ConfigMeta("shape", "Shape").setShortDescription("Marker shape").setXmlDescription(new String[0]), BasicXYShape.class, XYSHAPES){

        @Override
        public String getXmlDescription(BasicXYShape shape) {
            return null;
        }

        @Override
        public Specifier<BasicXYShape> createSpecifier() {
            RenderingComboBox<BasicXYShape> shapeSelector = new RenderingComboBox<BasicXYShape>(XYSHAPES){

                protected Icon getRendererIcon(BasicXYShape shape) {
                    return XYShape.createIcon(shape, 20, 12, true);
                }

                protected String getRendererText(BasicXYShape shape) {
                    return null;
                }
            };
            return new ComboBoxSpecifier<BasicXYShape>(BasicXYShape.class, (JComboBox<BasicXYShape>)shapeSelector);
        }
    }.setOptionUsage().addOptionsXml();
    public static final ConfigKey<Color> COLOR = new ColorConfigKey(ColorConfigKey.createColorMeta("color", "Color", "plotted data"), "red", false);
    public static final ConfigKey<Boolean> SIDEWAYS = new BooleanConfigKey(new ConfigMeta("sideways", "Sideways").setShortDescription("Independent variable is Y?").setXmlDescription(new String[]{"<p>When set to the default value of <code>false</code>,", "the quantity being accumulated is on the the horizontal axis", "and the frequency is represented vertically as usual.", "If set <code>true</code> the quantity accumulated", "is on the vertical axis,", "and the frequency is represented horizontally,", "so that the chart is displayed reflected in the X=Y line.", "</p>"}), false);
    public static final ConfigKey<Double> AUX_OPAQUE = DoubleConfigKey.createSliderKey(new ConfigMeta("opaque", "Opaque limit").setShortDescription("Aux fraction of fully opaque").setXmlDescription(new String[]{"<p>The opacity of points plotted in the Aux colour.", "The value is the number of points which have to be", "overplotted before the background is fully obscured.", "</p>"}), 1.0, 1.0, 1000.0, true);
    public static final ConfigKey<Double> TRANSPARENT_LEVEL = DoubleConfigKey.createSliderKey(new ConfigMeta("translevel", "Transparency Level").setShortDescription("Transparency").setXmlDescription(new String[]{"<p>Sets the level of automatically controlled transparency. ", "The higher this value the more transparent points are.", "Exactly how transparent points are depends on how many", "are currently being plotted on top of each other and", "the value of this parameter.", "The idea is that you can set it to some fixed value,", "and then get something which looks similarly", "transparent while you zoom in and out.", "</p>"}), 0.1, 0.001, 2.0, true);
    public static final ConfigKey<Double> TRANSPARENCY = DoubleConfigKey.createSliderKey(new ConfigMeta("transparency", "Transparency").setShortDescription("Fractional transparency").setXmlDescription(new String[]{"<p>Transparency with which components are plotted,", "in the range 0 (opaque) to 1 (invisible).", "The value is 1-alpha.", "</p>"}).setStringUsage("0..1"), 0.0, 0.0, 1.0, false);
    private static final ConfigKey<Integer> THICKNESS = StyleKeys.createThicknessKey(1);
    public static final ConfigKey<float[]> DASH = new DashConfigKey(DashConfigKey.createDashMeta("dash", "Dash"));
    public static final ConfigKey<Color> GRID_COLOR = new ColorConfigKey(ColorConfigKey.createColorMeta("gridcolor", "Grid Color", "the plot grid"), "grey", false);
    public static final KeySet<Color> GRIDCOLOR_KEYSET = new KeySet<Color>(){

        @Override
        public ConfigKey<?>[] getKeys() {
            return new ConfigKey[]{GRID_COLOR, GRID_TRANSPARENCY};
        }

        @Override
        public Color createValue(ConfigMap config) {
            float[] rgb = config.get(GRID_COLOR).getRGBComponents(null);
            float alpha = (float)(1.0 - config.get(GRID_TRANSPARENCY));
            return alpha > 0.0f ? new Color(rgb[0], rgb[1], rgb[2], alpha) : null;
        }
    };
    public static final ConfigKey<Double> GRID_TRANSPARENCY = DoubleConfigKey.createSliderKey(new ConfigMeta("gridtrans", "Grid Transparency").setShortDescription("Fractional transparency of grid lines").setXmlDescription(new String[]{"<p>Transparency of grid lines that may be drawn over", "the plot.", "The range is 0 (opaque) to 1 (invisible).", "This value is 1-alpha.", "</p>"}).setStringUsage("0..1"), 0.5, 0.0, 1.0, false);
    public static final ConfigKey<Color> AXLABEL_COLOR = new ColorConfigKey(ColorConfigKey.createColorMeta("labelcolor", "Label Color", "axis labels and other plot annotations"), "black", false);
    private static final BarStyle.Form[] BARFORMS = new BarStyle.Form[]{BarStyle.FORM_OPEN, BarStyle.FORM_FILLED, BarStyle.FORM_SEMIFILLED, BarStyle.FORM_TOP, BarStyle.FORM_SEMITOP, BarStyle.FORM_SPIKE};
    public static final ConfigKey<BarStyle.Form> BAR_FORM = new OptionConfigKey<BarStyle.Form>(new ConfigMeta("barform", "Bar Form").setShortDescription("Histogram bar shape").setXmlDescription(new String[]{"<p>How histogram bars are represented.", "Note that options using transparent colours", "may not render very faithfully", "to some vector formats like PDF and EPS.", "</p>"}), BarStyle.Form.class, BARFORMS, BarStyle.FORM_SEMIFILLED){

        @Override
        public String getXmlDescription(BarStyle.Form barForm) {
            return null;
        }

        @Override
        public Specifier<BarStyle.Form> createSpecifier() {
            RenderingComboBox<BarStyle.Form> formSelector = new RenderingComboBox<BarStyle.Form>(BARFORMS){

                protected Icon getRendererIcon(BarStyle.Form form) {
                    return BarStyles.getIcon(form);
                }
            };
            return new ComboBoxSpecifier<BarStyle.Form>(BarStyle.Form.class, (JComboBox<BarStyle.Form>)formSelector);
        }
    }.setOptionUsage().addOptionsXml();
    private static final FillMode[] FILLMODES = new FillMode[]{FillMode.SOLID, FillMode.LINE, FillMode.SEMI};
    private static final int[] FILLMODE_ICON_DATA = new int[]{1, 2, 3, 3, 4, 5, 6, 7, 8, 9, 9, 7, 8, 7, 5, 5, 6, 7, 8, 9, 11, 11, 10, 11, 12, 11, 9, 7, 5, 4, 2, 1, 1, 0};
    public static final ConfigKey<FillMode> FILL = new OptionConfigKey<FillMode>(new ConfigMeta("fill", "Fill").setShortDescription("Fill mode").setXmlDescription(new String[]{"<p>How the density function is represented.", "</p>"}), FillMode.class, FILLMODES, FillMode.SEMI){

        @Override
        public String getXmlDescription(FillMode fillMode) {
            return fillMode.getDescription();
        }

        @Override
        public Specifier<FillMode> createSpecifier() {
            RenderingComboBox<FillMode> fillSelector = new RenderingComboBox<FillMode>(FILLMODES){

                protected Icon getRendererIcon(FillMode fillmode) {
                    return fillmode.createIcon(FILLMODE_ICON_DATA, Color.BLACK, new BasicStroke(), 2);
                }
            };
            return new ComboBoxSpecifier<FillMode>(FillMode.class, (JComboBox<FillMode>)fillSelector);
        }
    }.setOptionUsage().addOptionsXml();
    public static final ConfigKey<Cumulation> CUMULATIVE = new OptionConfigKey<Cumulation>(new ConfigMeta("cumulative", "Cumulative").setShortDescription("Cumulative histogram mode").setXmlDescription(new String[]{"<p>If set to", "<code>" + Cumulation.FORWARD.toString().toLowerCase() + "</code>/<code>" + Cumulation.REVERSE.toString().toLowerCase() + "</code>", "the histogram bars plotted are calculated", "cumulatively;", "each bin includes the counts from all previous bins", "working up/down the independent axis.", "</p>", "<p>Note that setting cumulative plotting", "may not make much sense", "with some other parameter values,", "for instance averaging aggregation modes.", "</p>", "<p>For reasons of backward compatibility,", "the values <code>true</code> and <code>false</code>", "may be used as aliases for", "<code>forward</code> and <code>none</code>.", "</p>"}), Cumulation.class, Cumulation.values(), Cumulation.NONE, true){

        @Override
        public String getXmlDescription(Cumulation cumul) {
            return cumul.getTextDescription();
        }

        @Override
        public Cumulation stringToValue(String txt) throws ConfigException {
            if (BooleanConfigKey.isTrue(txt)) {
                return Cumulation.FORWARD;
            }
            if (BooleanConfigKey.isFalse(txt)) {
                return Cumulation.NONE;
            }
            return (Cumulation)((Object)super.stringToValue(txt));
        }
    }.setOptionUsage().addOptionsXml();
    public static final ConfigKey<Normalisation> NORMALISE = new OptionConfigKey<Normalisation>(new ConfigMeta("normalise", "Normalise").setShortDescription("Normalisation mode").setXmlDescription(new String[]{"<p>Defines how, if at all, the bars of histogram-like plots", "are normalised or otherwise scaled vertically.", "</p>", "<p>Note that some of the normalisation options", "may not make much sense with some other parameter values,", "for instance averaging aggregation modes.", "</p>"}), Normalisation.class, Normalisation.getKnownValues(), Normalisation.NONE){

        @Override
        public String getXmlDescription(Normalisation norm) {
            return norm.getDescription();
        }
    }.setOptionUsage().addOptionsXml();
    public static final ConfigKey<Boolean> ANTIALIAS = new BooleanConfigKey(new ConfigMeta("antialias", "Antialiasing").setShortDescription("Antialias lines?").setXmlDescription(new String[]{"<p>If true, plotted lines are drawn with antialising.", "Antialised lines look smoother, but may take", "perceptibly longer to draw.", "Only has any effect for bitmapped output formats.", "</p>"}), false);
    public static final ConfigKey<Boolean> GRID_ANTIALIAS = new BooleanConfigKey(new ConfigMeta("gridaa", "Antialiasing").setShortDescription("Use antialiasing for grid lines?").setXmlDescription(new String[]{"<p>If true, grid lines are drawn with antialiasing.", "Antialiased lines look smoother, but may take", "perceptibly longer to draw.", "Only has any effect for bitmapped output formats.", "</p>"}), false);
    public static final ConfigKey<Anchor> ANCHOR = new OptionConfigKey<Anchor>(new ConfigMeta("anchor", "Anchor").setShortDescription("Text label anchor position").setXmlDescription(new String[]{"<p>Determines where the text appears", "in relation to the plotted points.", "Values are points of the compass.", "</p>"}), Anchor.class, new Anchor[]{Anchor.W, Anchor.E, Anchor.N, Anchor.S, Anchor.C}){

        @Override
        public String getXmlDescription(Anchor anchor) {
            return null;
        }
    }.setOptionUsage().addOptionsXml();
    public static final ConfigKey<LevelMode> LEVEL_MODE = new OptionConfigKey<LevelMode>(new ConfigMeta("scaling", "Scaling").setShortDescription("Level scaling").setXmlDescription(new String[]{"<p>How the smoothed density is treated before", "contour levels are determined.", "</p>"}), LevelMode.class, LevelMode.MODES, LevelMode.LINEAR){

        @Override
        public String getXmlDescription(LevelMode mode) {
            return mode.getDescription();
        }
    }.setOptionUsage().addOptionsXml();
    public static final MultiPointConfigKey VECTOR_SHAPE = StyleKeys.createMultiPointKey("arrow", "Arrow", MultiPointShape.getOptionsVector(), new ErrorMode[]{ErrorMode.UPPER});
    public static final MultiPointConfigKey ELLIPSE_SHAPE = StyleKeys.createMultiPointKey("ellipse", "Ellipse", MultiPointShape.getOptionsEllipse(), new ErrorMode[]{ErrorMode.SYMMETRIC, ErrorMode.SYMMETRIC});
    public static final MultiPointConfigKey ERROR_SHAPE_1D = StyleKeys.createMultiPointKey("errorbar", "Error Bar", MultiPointShape.getOptionsError1d(), new ErrorMode[]{ErrorMode.SYMMETRIC});
    public static final MultiPointConfigKey ERROR_SHAPE_2D = StyleKeys.createMultiPointKey("errorbar", "Error Bar", MultiPointShape.getOptionsError2d(), new ErrorMode[]{ErrorMode.SYMMETRIC, ErrorMode.SYMMETRIC});
    public static final MultiPointConfigKey ERROR_SHAPE_3D = StyleKeys.createMultiPointKey("errorbar", "Error Bar", MultiPointShape.getOptionsError3d(), new ErrorMode[]{ErrorMode.SYMMETRIC, ErrorMode.SYMMETRIC, ErrorMode.SYMMETRIC});
    public static final ConfigKey<Double> AUX_CROWD = PlaneSurfaceFactory.createAxisCrowdKey("Aux");
    public static final ConfigKey<Double> SHADE_LOW = PlaneSurfaceFactory.createAxisLimitKey("Aux", false);
    public static final ConfigKey<Double> SHADE_HIGH = PlaneSurfaceFactory.createAxisLimitKey("Aux", true);
    public static final ConfigKey<Subrange> SHADE_SUBRANGE = new SubrangeConfigKey(SubrangeConfigKey.createAxisSubMeta("aux", "Aux"));
    public static final ConfigKey<Color> AUX_NULLCOLOR = StyleKeys.createNullColorKey("aux", "Aux");
    public static final ConfigKey<Color> AUXLOCAL_NULLCOLOR = StyleKeys.createNullColorKey("p", "Aux");
    private static final String SCALE_NAME = "scale";
    private static final String AUTOSCALE_NAME = "autoscale";
    public static final ConfigKey<Double> SCALE = new DoubleConfigKey(new ConfigMeta("scale", "Scale").setStringUsage("<factor>").setShortDescription("Marker size multiplier").setXmlDescription(new String[]{"<p>Affects the size of variable-sized markers", "like vectors and ellipses.", "The default value is 1, smaller or larger values", "multiply the visible sizes accordingly.", "</p>"}), 1.0){

        @Override
        public Specifier<Double> createSpecifier() {
            return new SliderSpecifier(1.0E-4, 10000.0, true, 1.0, false, SliderSpecifier.TextOption.ENTER_ECHO);
        }
    };
    public static final ConfigKey<Double> SCALE_PIX = new DoubleConfigKey(new ConfigMeta("scale", "Scale").setStringUsage("<factor>").setShortDescription("Marker size multiplier").setXmlDescription(new String[]{"<p>Scales the size of variable-sized markers.", "The default is 1, smaller or larger values", "multiply the visible sizes accordingly.", "</p>"}), 1.0){

        @Override
        public Specifier<Double> createSpecifier() {
            return new SliderSpecifier(0.01, 100.0, true, 1.0, false, SliderSpecifier.TextOption.ENTER_ECHO);
        }
    };
    public static final ConfigKey<Boolean> AUTOSCALE = new BooleanConfigKey(new ConfigMeta("autoscale", "Auto Scale").setShortDescription("Scale marker sizes automatically?").setXmlDescription(new String[]{"<p>Determines whether the default size of variable-sized", "markers like vectors and ellipses are automatically", "scaled to have a sensible size.", "If true, then the sizes of all the plotted markers", "are examined, and some dynamically calculated factor is", "applied to them all to make them a sensible size", "(by default, the largest ones will be a few tens of pixels).", "If false, the sizes will be the actual input values", "interpreted in data coordinates.", "</p>", "<p>If auto-scaling is on, then markers will keep", "approximately the same screen size during zoom operations;", "if it's off, they will keep the same size", "in data coordinates.", "</p>", "<p>Marker size is also affected by the", "<code>scale</code> parameter.", "</p>"}), Boolean.FALSE);
    public static final ConfigKey<Boolean> AUTOSCALE_PIX = new BooleanConfigKey(new ConfigMeta("autoscale", "Auto Scale").setShortDescription("Scale marker sizes automatically?").setXmlDescription(new String[]{"<p>Determines whether the basic size", "of variable sized markers is automatically", "scaled to have a sensible size.", "If true, then the sizes of all the plotted markers", "are examined, and some dynamically calculated factor is", "applied to them all to make them a sensible size", "(by default, the largest ones will be a few tens of pixels).", "If false, the sizes will be the actual input values", "in units of pixels.", "</p>", "<p>If auto-scaling is off, then markers will keep", "exactly the same screen size during pan and zoom operations;", "if it's on, then the visible sizes will change according", "to what other points are currently plotted.", "</p>", "<p>Marker size is also affected by the", "<code>scale</code> parameter.", "</p>"}), Boolean.TRUE);
    public static final ConfigKey<String> LABEL = new StringConfigKey(new ConfigMeta("label", "Label").setStringUsage("<txt>").setShortDescription("Plot layer label").setXmlDescription(new String[]{"<p>Supplies a text label for a plot layer.", "This may be used for identifying it in the legend.", "If not supplied, a label will be generated automatically", "where required.", "</p>"}), null);
    public static final ConfigKey<Boolean> SHOW_LABEL = new BooleanConfigKey(new ConfigMeta("inlegend", "In Legend").setShortDescription("Show layer in legend?").setXmlDescription(new String[]{"<p>Determines whether the layer has an entry in the", "plot legend, if shown.", "</p>"}), true);
    public static final ConfigKey<Boolean> MINOR_TICKS = new BooleanConfigKey(new ConfigMeta("minor", "Minor Ticks").setShortDescription("Display minor tick marks?").setXmlDescription(new String[]{"<p>If true, minor tick marks are painted along the axes", "as well as the major tick marks.", "Minor tick marks do not have associated grid lines.", "</p>"}), true);
    public static final ConfigKey<Boolean> SHADOW_TICKS = new BooleanConfigKey(new ConfigMeta("shadow", "Shadow Ticks").setShortDescription("Display shadow tick marks?").setXmlDescription(new String[]{"<p>If true and no secondary axis is in use,", "then tick marks without numeric labels are painted", "along the axis opposite to the primary axis,", "so that tick marks are visible along all edges", "not just the ones with numeric labels.", "If a secondary axis is in use, this setting is ignored.", "</p>"}), true);
    public static final ConfigKey<Double> ZOOM_FACTOR = DoubleConfigKey.createSliderKey(new ConfigMeta("zoomfactor", "Zoom Factor").setShortDescription("Amount of zoom per mouse wheel unit").setXmlDescription(new String[]{"<p>Sets the amount by which the plot view zooms in or out", "for each unit of mouse wheel movement.", "A value of 1 means that mouse wheel zooming has no effect.", "A higher value means that the mouse wheel zooms faster", "and a value nearer 1 means it zooms slower.", "Values below 1 are not permitted.", "</p>"}), 1.2, 1.0, 2.0, true);
    public static final CaptionerKeySet CAPTIONER = new CaptionerKeySet();
    public static final RampKeySet AUX_RAMP = new RampKeySet("aux", "Aux", StyleKeys.createAuxShaders(), Scaling.LINEAR, false);
    public static final RampKeySet AUXLOCAL_RAMP = new RampKeySet("p", "Aux", StyleKeys.createAuxShaders(), Scaling.LINEAR, true);
    public static final RampKeySet DENSITY_RAMP = new RampKeySet("dense", "Density", StyleKeys.createDensityShaders(), Scaling.LOG, true);

    private StyleKeys() {
    }

    public static ConfigKey<?>[] getStrokeKeys() {
        return new ConfigKey[]{THICKNESS, DASH};
    }

    public static Stroke createStroke(ConfigMap config, int cap, int join) {
        int thick = config.get(THICKNESS);
        float[] dash = config.get(DASH);
        if (dash != null && thick != 1) {
            dash = (float[])dash.clone();
            int i = 0;
            while (i < dash.length) {
                int n = i++;
                dash[n] = dash[n] * (float)thick;
            }
        }
        return new BasicStroke(thick, cap, join, 10.0f, dash, 0.0f);
    }

    public static ConfigKey<MarkerShape> createMarkerShapeKey(ConfigMeta meta, MarkerShape dflt) {
        OptionConfigKey<MarkerShape> key = new OptionConfigKey<MarkerShape>(meta, MarkerShape.class, MARKER_SHAPES, dflt){

            @Override
            public String getXmlDescription(MarkerShape shape) {
                return null;
            }

            @Override
            public Specifier<MarkerShape> createSpecifier() {
                return new ComboBoxSpecifier<MarkerShape>(MarkerShape.class, MarkStyleSelectors.createMarkerShapeSelector(MARKER_SHAPES));
            }
        };
        key.setOptionUsage();
        key.addOptionsXml();
        return key;
    }

    public static ConfigKey<Integer> createMarkSizeKey(ConfigMeta meta, int dflt) {
        return new IntegerConfigKey(meta, dflt){

            @Override
            public Specifier<Integer> createSpecifier() {
                return new ComboBoxSpecifier<Integer>(Integer.class, MarkStyleSelectors.createSizeSelector(9));
            }
        };
    }

    public static ConfigKey<Double> createCrowdKey(ConfigMeta meta) {
        return DoubleConfigKey.createSliderKey(meta, 1.0, 0.125, 10.0, true);
    }

    public static ConfigKey<String> createAxisLabelKey(String axName) {
        ConfigMeta meta = new ConfigMeta(axName.toLowerCase() + "label", axName + " Label");
        meta.setStringUsage("<text>");
        meta.setShortDescription("Label for axis " + axName);
        meta.setXmlDescription(new String[]{"<p>Gives a label to be used for annotating axis " + axName, "A default value based on the plotted data will be used", "if no value is supplied.", "</p>"});
        return new StringConfigKey(meta, axName);
    }

    public static ConfigKey<Color> createNullColorKey(String axname, String axName) {
        return new ColorConfigKey(ColorConfigKey.createColorMeta(axname.toLowerCase() + "nullcolor", "Null Color", "points with a null value of the " + axName + " coordinate").appendXmlDescription(new String[]{"<p>If the value is null, then points with a null", axName, "value will not be plotted at all.", "</p>"}), "grey", true);
    }

    public static ConfigKey<Double> createOpaqueKey(int dfltValue) {
        return DoubleConfigKey.createSliderKey(new ConfigMeta("opaque", "Opaque limit").setShortDescription("Fraction of fully opaque").setXmlDescription(new String[]{"<p>The opacity of plotted points.", "The value is the number of points which have to be", "overplotted before the background is fully obscured.", "</p>"}), dfltValue, 1.0, 10000.0, true);
    }

    public static ConfigKey<Integer> createThicknessKey(int dfltThick) {
        ConfigMeta meta = new ConfigMeta("thick", "Thickness");
        meta.setStringUsage("<pixels>");
        meta.setShortDescription("Line thickness in pixels");
        meta.setXmlDescription(new String[]{"<p>Thickness of plotted line in pixels.", "</p>"});
        return new IntegerConfigKey(meta, dfltThick){

            @Override
            public Specifier<Integer> createSpecifier() {
                return new ComboBoxSpecifier<Integer>(Integer.class, (JComboBox<Integer>)((Object)new ThicknessComboBox(9)));
            }
        };
    }

    public static ConfigKey<Integer> createPaintThicknessKey(ConfigMeta meta, int max) {
        int lineLength = 48;
        int linePad = 4;
        final Integer[] numbers = new Integer[max + 1];
        for (int i = 0; i <= max; ++i) {
            numbers[i] = i;
        }
        return new IntegerConfigKey(meta, 0){

            @Override
            public Specifier<Integer> createSpecifier() {
                RenderingComboBox<Integer> selector = new RenderingComboBox<Integer>(numbers){

                    public Icon getRendererIcon(Integer nThick) {
                        return this.createLineIcon(nThick);
                    }
                };
                return new ComboBoxSpecifier<Integer>(Integer.class, (JComboBox<Integer>)selector);
            }

            private Icon createLineIcon(final int nthick) {
                final int strokeSize = nthick * 2 + 1;
                final BasicStroke stroke = new BasicStroke(strokeSize);
                return new Icon(){

                    @Override
                    public int getIconHeight() {
                        return strokeSize;
                    }

                    @Override
                    public int getIconWidth() {
                        return 56;
                    }

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        Graphics2D g2 = (Graphics2D)g;
                        Stroke stroke0 = g2.getStroke();
                        Color color0 = g2.getColor();
                        g2.setColor(Color.BLACK);
                        g2.setStroke(stroke);
                        int ypos = y + nthick;
                        g2.drawLine(x + 4, ypos, x + 4 + 48, ypos);
                        g2.setStroke(stroke0);
                        g2.setColor(color0);
                    }
                };
            }
        };
    }

    public static Color getAlphaColor(ConfigMap config, ConfigKey<Color> colorKey, ConfigKey<Double> transparencyKey) {
        Color baseColor = config.get(colorKey);
        float alpha = 1.0f - config.get(transparencyKey).floatValue();
        float[] rgba = baseColor.getRGBComponents(new float[4]);
        rgba[3] = rgba[3] * alpha;
        return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    private static MultiPointConfigKey createMultiPointKey(String shortName, String longName, MultiPointShape[] shapes, ErrorMode[] modes) {
        ConfigMeta meta = new ConfigMeta(shortName, longName);
        meta.setShortDescription(longName + " shape");
        meta.setXmlDescription(new String[]{"<p>How " + shortName + "s are represented.", "</p>"});
        MultiPointConfigKey key = new MultiPointConfigKey(meta, shapes, modes);
        key.setOptionUsage();
        key.addOptionsXml();
        return key;
    }

    private static MarkerShape[] createMarkerShapes() {
        return new MarkerShape[]{MarkerShape.FILLED_CIRCLE, MarkerShape.OPEN_CIRCLE, MarkerShape.CROSS, MarkerShape.CROXX, MarkerShape.OPEN_SQUARE, MarkerShape.OPEN_DIAMOND, MarkerShape.OPEN_TRIANGLE_UP, MarkerShape.OPEN_TRIANGLE_DOWN, FatMarkerShapes.FAT_CIRCLE, FatMarkerShapes.FAT_CROSS, FatMarkerShapes.FAT_CROXX, FatMarkerShapes.FAT_SQUARE, FatMarkerShapes.FAT_DIAMOND, FatMarkerShapes.FAT_TRIANGLE_UP, FatMarkerShapes.FAT_TRIANGLE_DOWN, MarkerShape.FILLED_SQUARE, MarkerShape.FILLED_DIAMOND, MarkerShape.FILLED_TRIANGLE_UP, MarkerShape.FILLED_TRIANGLE_DOWN};
    }

    private static ClippedShader[] createDensityShaders() {
        ArrayList<ClippedShader> list = new ArrayList<ClippedShader>();
        list.add(StyleKeys.clip(Shaders.FADE_BLACK, 0.0, false));
        list.add(StyleKeys.clip(Shaders.FADE_WHITE, 0.1, false));
        list.addAll(Arrays.asList(StyleKeys.createColorShaders(true)));
        return list.toArray(new ClippedShader[0]);
    }

    public static ClippedShader[] createAuxShaders() {
        ArrayList<ClippedShader> list = new ArrayList<ClippedShader>();
        list.addAll(Arrays.asList(StyleKeys.createColorShaders(true)));
        list.addAll(Arrays.asList(StyleKeys.clip(Shaders.createMaskShader("Mask", 0.0f, 1.0f, true), 0.0, false), StyleKeys.clip(Shaders.FADE_BLACK, 0.0, false), StyleKeys.clip(Shaders.FADE_WHITE, 0.1, false), StyleKeys.clip(Shaders.TRANSPARENCY, 0.1, false)));
        return list.toArray(new ClippedShader[0]);
    }

    private static ClippedShader[] createColorShaders(boolean isAllVisible) {
        double c = isAllVisible ? 1.0 : 0.0;
        return new ClippedShader[]{StyleKeys.clip(Shaders.LUT_MPL2INFERNO, c * 0.1, true), StyleKeys.clip(Shaders.LUT_MPL2MAGMA, c * 0.1, true), StyleKeys.clip(Shaders.LUT_MPL2PLASMA, c * 0.1, true), StyleKeys.clip(Shaders.LUT_MPL2VIRIDIS, c * 0.06, true), StyleKeys.clip(Shaders.LUT_CIVIDIS, c * 0.02, true), StyleKeys.clip(Shaders.CUBEHELIX, c * 0.15, true), StyleKeys.clip(Shaders.SRON_RAINBOW, 0.0, true), StyleKeys.clip(Shaders.LUT_RAINBOW, 0.0, true), StyleKeys.clip(Shaders.LUT_GLNEMO2, c * 0.03, true), StyleKeys.clip(Shaders.LUT_RAINBOW3, 0.0, true), StyleKeys.clip(Shaders.LUT_PASTEL, c * 0.06, true), StyleKeys.clip(Shaders.LUT_COSMIC, 0.0, true), StyleKeys.clip(Shaders.LUT_EMBER, 0.05, true), StyleKeys.clip(Shaders.LUT_GOTHIC, 0.15, true), StyleKeys.clip(Shaders.LUT_RAINFOREST, 0.15, true), StyleKeys.clip(Shaders.LUT_VOLTAGE, 0.15, true), StyleKeys.clip(Shaders.LUT_BUBBLEGUM, 0.0, true), StyleKeys.clip(Shaders.LUT_GEM, 0.0, true), StyleKeys.clip(Shaders.LUT_CHROMA, 0.15, true), StyleKeys.clip(Shaders.SUNSET, 0.0, false), StyleKeys.clip(Shaders.LUT_NEON, 0.0, true), StyleKeys.clip(Shaders.LUT_TROPICAL, 0.0, true), StyleKeys.clip(Shaders.LUT_ACCENT, 0.0, true), StyleKeys.clip(Shaders.LUT_GNUPLOT, c * 0.1, true), StyleKeys.clip(Shaders.LUT_GNUPLOT2, c * 0.2, true), StyleKeys.clip(Shaders.LUT_SPECXB2Y, c * 0.1, true), StyleKeys.clip(Shaders.LUT_SET1, 0.0, true), StyleKeys.clip(Shaders.LUT_PAIRED, 0.0, true), StyleKeys.clip(Shaders.LUT_HOTCOLD, 0.0, false), StyleKeys.clip(Shaders.LUT_GUPPY, 0.0, false), StyleKeys.clip(Shaders.LUT_ICEBURN, 0.0, false), StyleKeys.clip(Shaders.LUT_REDSHIFT, 0.0, false), StyleKeys.clip(Shaders.LUT_PRIDE, 0.0, false), StyleKeys.clip(Shaders.BREWER_RDBU, 0.0, false), StyleKeys.clip(Shaders.BREWER_PIYG, 0.0, false), StyleKeys.clip(Shaders.BREWER_BRBG, 0.0, false), StyleKeys.clip(Shaders.CYAN_MAGENTA, 0.0, false), StyleKeys.clip(Shaders.RED_BLUE, 0.0, false), StyleKeys.clip(Shaders.LUT_BRG, 0.0, true), StyleKeys.clip(Shaders.LUT_HEAT, c * 0.15, true), StyleKeys.clip(Shaders.LUT_COLD, c * 0.15, true), StyleKeys.clip(Shaders.LUT_LIGHT, c * 0.15, true), StyleKeys.clip(Shaders.WHITE_BLACK, c * 0.1, false), StyleKeys.clip(Shaders.LUT_COLOR, 0.0, true), StyleKeys.clip(Shaders.LUT_STANDARD, 0.0, true), StyleKeys.clip(Shaders.BREWER_BUGN, c * 0.15, false), StyleKeys.clip(Shaders.BREWER_BUPU, c * 0.15, false), StyleKeys.clip(Shaders.BREWER_ORRD, c * 0.15, false), StyleKeys.clip(Shaders.BREWER_PUBU, c * 0.15, false), StyleKeys.clip(Shaders.BREWER_PURD, c * 0.15, false), StyleKeys.clip(Shaders.LUT_PAINBOW, 0.0, false), StyleKeys.clip(Shaders.HCL_POLAR, 0.0, false), StyleKeys.clip(Shaders.LUT_INFINITY, 0.0, false), StyleKeys.clip(Shaders.FIX_HUE, 0.0, false), StyleKeys.clip(Shaders.FIX_INTENSITY, 0.0, true), StyleKeys.clip(Shaders.FIX_RED, 0.0, false), StyleKeys.clip(Shaders.FIX_GREEN, 0.0, false), StyleKeys.clip(Shaders.FIX_BLUE, 0.0, false), StyleKeys.clip(Shaders.HSV_H, 0.0, false), StyleKeys.clip(Shaders.HSV_S, 0.0, false), StyleKeys.clip(Shaders.HSV_V, 0.0, true), StyleKeys.clip(Shaders.FIX_Y, 0.0, true), StyleKeys.clip(Shaders.FIX_U, 0.0, false), StyleKeys.clip(Shaders.FIX_V, 0.0, false), StyleKeys.clip(Shaders.SCALE_S, 0.0, false), StyleKeys.clip(Shaders.SCALE_V, 0.0, true), StyleKeys.clip(Shaders.SCALE_Y, 0.0, true)};
    }

    private static ClippedShader clip(Shader shader, double clip, boolean flip) {
        String name = shader.getName();
        if (flip) {
            shader = Shaders.invert(shader);
        }
        if (!name.equals(shader.getName())) {
            shader = Shaders.rename(shader, name);
        }
        final Shader shader0 = shader;
        final Subrange subrange = new Subrange(clip, 1.0);
        return new ClippedShader(){

            @Override
            public Shader getShader() {
                return shader0;
            }

            @Override
            public Subrange getSubrange() {
                return subrange;
            }
        };
    }
}

