/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.RangeSliderUtil;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.SpecifierPanel;

public class SubrangeConfigKey
extends ConfigKey<Subrange> {
    private final double vmin_;
    private final double vmax_;

    public SubrangeConfigKey(ConfigMeta meta, Subrange dflt, double vmin, double vmax) {
        super(meta, Subrange.class, dflt);
        this.vmin_ = vmin;
        this.vmax_ = vmax;
    }

    public SubrangeConfigKey(ConfigMeta meta) {
        this(meta, new Subrange(), 0.0, 1.0);
    }

    @Override
    public String valueToString(Subrange value) {
        return SubrangeConfigKey.format(value.getLow(), 3) + "," + SubrangeConfigKey.format(value.getHigh(), 3);
    }

    @Override
    public Subrange stringToValue(String txt) throws ConfigException {
        String[] limits = txt.split(",", -1);
        if (limits.length == 2) {
            String slo = limits[0].trim();
            String shi = limits[1].trim();
            try {
                double hi;
                double lo = slo.length() > 0 ? Double.parseDouble(slo) : 0.0;
                double d = hi = shi.length() > 0 ? Double.parseDouble(shi) : 1.0;
                if (lo <= hi) {
                    return new Subrange(lo, hi);
                }
                throw new ConfigException(this, "lo <= hi violated");
            }
            catch (NumberFormatException e) {
                throw new ConfigException(this, "Bad number(s): \"" + slo + "\", \"" + shi + "\"");
            }
        }
        throw new ConfigException(this, "Should be two numbers separated by a comma");
    }

    @Override
    public Specifier<Subrange> createSpecifier() {
        return new SubrangeSpecifier(this.vmin_, this.vmax_);
    }

    private static String format(double dval, int nf) {
        int m10 = (int)Math.round(Math.pow(10.0, nf));
        int mf = (int)Math.round(dval * (double)m10);
        if (mf == 0) {
            return "0";
        }
        if (mf == m10) {
            return "1";
        }
        return PlotUtil.formatNumber(dval, "0.0", nf);
    }

    public static ConfigMeta createAxisSubMeta(String axname, String axisName) {
        ConfigMeta meta = new ConfigMeta(axname + "sub", ConfigMeta.capitalise(axisName) + " Subrange");
        meta.setStringUsage("<lo>,<hi>");
        meta.setXmlDescription(new String[]{"<p>Defines a normalised adjustment to the data range of the", axisName + " axis.", "The value may be specified as a comma-separated pair", "of two numbers,", "giving the lower and upper bounds of the range of", "of interest respectively.", "This sub-range is applied to the data range that would", "otherwise be used, either automatically calculated", "or explicitly supplied;", "zero corresponds to the lower bound and one to the upper.", "</p>", "<p>The default value \"<code>0,1</code>\" therefore has", "no effect.", "The range could be restricted to its lower half", "with the value <code>0,0.5</code>.", "</p>"});
        return meta;
    }

    public static ConfigMeta createShaderClipMeta(String axname, String axisName) {
        ConfigMeta meta = new ConfigMeta(axname + "clip", "Shader Clip");
        meta.setStringUsage("<lo>,<hi>");
        meta.setShortDescription(axisName + " shader clip range");
        meta.setXmlDescription(new String[]{"<p>Defines a subrange of the colour ramp to be used for", axisName + " shading.", "The value is specified as a (low,high) comma-separated pair", "of two numbers between 0 and 1.", "</p>", "<p>If the full range <code>0,1</code> is used,", "the whole range of colours specified by the selected", "shader will be used.", "But if for instance a value of <code>0,0.5</code> is given,", "only those colours at the left hand end of the ramp", "will be seen.", "</p>"});
        return meta;
    }

    private static class SubrangeSpecifier
    extends SpecifierPanel<Subrange> {
        private final double rmin_;
        private final double rmax_;
        private final JSlider slider_;
        private final JButton resetButton_;
        private static final int MIN = 0;
        private static final int MAX = 10000;

        SubrangeSpecifier(double rmin, double rmax) {
            super(true);
            this.rmin_ = rmin;
            this.rmax_ = rmax;
            this.slider_ = RangeSliderUtil.createRangeSlider(0, 10000);
            this.slider_.addChangeListener(this.getChangeForwarder());
            boolean showLabels = false;
            if (rmin != 0.0 || rmax != 1.0) {
                if (showLabels) {
                    Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
                    labels.put(this.unscale(0.0), new JLabel("0"));
                    labels.put(this.unscale(1.0), new JLabel("1"));
                    this.slider_.setLabelTable(labels);
                    this.slider_.setPaintLabels(true);
                }
                AbstractAction resetAct = new AbstractAction(null, ResourceIcon.ZERO){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        this.setSpecifiedValue(new Subrange());
                    }
                };
                this.resetButton_ = new JButton(resetAct);
                this.resetButton_.setMargin(new Insets(0, 0, 0, 0));
            } else {
                this.resetButton_ = null;
            }
        }

        @Override
        protected JComponent createComponent() {
            Box line = Box.createHorizontalBox();
            line.add(this.slider_);
            if (this.resetButton_ != null) {
                line.add(this.resetButton_);
            }
            line.addPropertyChangeListener("enabled", evt -> {
                boolean isEnabled = line.isEnabled();
                this.slider_.setEnabled(isEnabled);
                if (this.resetButton_ != null) {
                    this.resetButton_.setEnabled(isEnabled);
                }
            });
            return line;
        }

        @Override
        public Subrange getSpecifiedValue() {
            int ihi;
            int[] range = RangeSliderUtil.getSliderRange(this.slider_);
            int ilo = range[0];
            if (ilo == (ihi = range[1])) {
                int quantum = this.getQuantum();
                if (ihi == 10000) {
                    ilo = Math.max(0, ilo - quantum);
                } else {
                    ihi = Math.min(10000, ihi + quantum);
                }
            }
            return new Subrange(this.scale(ilo), this.scale(ihi));
        }

        @Override
        public void setSpecifiedValue(Subrange subrange) {
            RangeSliderUtil.setSliderRange(this.slider_, this.unscale(subrange.getLow()), this.unscale(subrange.getHigh()));
        }

        @Override
        public void submitReport(ReportMap report) {
        }

        private int getQuantum() {
            int npix = this.slider_.getOrientation() == 1 ? this.slider_.getHeight() : this.slider_.getWidth();
            npix = Math.max(10, Math.min(10000, npix));
            return Math.max(1, 10000 / npix);
        }

        private double scale(int ival) {
            double p01 = (double)(ival - 0) / 10000.0;
            return this.rmin_ + p01 * (this.rmax_ - this.rmin_);
        }

        private int unscale(double dval) {
            double p01 = (dval - this.rmin_) / (this.rmax_ - this.rmin_);
            return (int)Math.round(p01 * 10000.0) + 0;
        }
    }
}

