/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JSlider;
import javax.swing.UIManager;

public class TextDisplaySlider
extends JSlider {
    private boolean isShow_;

    public TextDisplaySlider(int min, int max) {
        super(min, max);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                TextDisplaySlider.this.setShowValue(true);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                TextDisplaySlider.this.setShowValue(true);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                TextDisplaySlider.this.setShowValue(false);
            }
        });
    }

    public String getDisplayValue() {
        return Integer.toString(this.getValue());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isShow_) {
            Color color0 = g.getColor();
            Font font0 = g.getFont();
            Shape clip0 = g.getClip();
            g.setColor(UIManager.getColor("ToolTip.foreground"));
            g.setFont(UIManager.getFont("ToolTip.font"));
            g.drawString(this.getDisplayValue(), 0, this.getHeight());
            g.setColor(color0);
            g.setFont(font0);
            g.setClip(clip0);
        }
    }

    private void setShowValue(boolean isShow) {
        this.isShow_ = isShow;
        this.repaint();
    }
}

