/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.plot2.Slow;
import uk.ac.starlink.ttools.plot2.data.CachedColumnFactory;
import uk.ac.starlink.ttools.plot2.data.CachedReader;
import uk.ac.starlink.ttools.plot2.data.CachedTupleSequence;
import uk.ac.starlink.ttools.plot2.data.CoordSpec;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.DataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.MaskSpec;
import uk.ac.starlink.ttools.plot2.data.TableCachedData;
import uk.ac.starlink.ttools.plot2.data.TupleRunner;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;

public class CachedDataStoreFactory
implements DataStoreFactory {
    private final CachedColumnFactory colFact_;
    private final TupleRunner tupleRunner_;
    private final RowRunner rowRunner_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2");

    public CachedDataStoreFactory(CachedColumnFactory colFact, TupleRunner tupleRunner) {
        this(colFact, tupleRunner, null);
    }

    protected CachedDataStoreFactory(CachedColumnFactory colFact, TupleRunner tupleRunner, RowRunner rowRunner) {
        this.colFact_ = colFact;
        this.tupleRunner_ = tupleRunner;
        this.rowRunner_ = rowRunner;
    }

    @Override
    public DataStore readDataStore(DataSpec[] dataSpecs, DataStore prevStore) throws IOException, InterruptedException {
        CacheData gotData;
        CacheSpec needSpec = CachedDataStoreFactory.createCacheSpec(dataSpecs);
        CacheSpec makeSpec = needSpec.subtract((gotData = prevStore instanceof CacheData ? (CacheData)prevStore : new CacheData(this.tupleRunner_)).getSpec());
        if (makeSpec.isEmpty()) {
            return prevStore;
        }
        CacheData oldData = gotData.retain(needSpec);
        CacheData makeData = makeSpec.readData(this.colFact_, this.tupleRunner_, this.rowRunner_);
        CacheData useData = makeData.add(oldData);
        return useData;
    }

    private static CacheSpec createCacheSpec(DataSpec[] dataSpecs) {
        HashSet<MaskSpec> mSet = new HashSet<MaskSpec>();
        HashSet<CoordSpec> cSet = new HashSet<CoordSpec>();
        for (int is = 0; is < dataSpecs.length; ++is) {
            DataSpec dspec = dataSpecs[is];
            if (dspec == null) continue;
            mSet.add(new MaskSpec(dspec));
            int nc = dspec.getCoordCount();
            for (int ic = 0; ic < nc; ++ic) {
                cSet.add(new CoordSpec(dspec, ic));
            }
        }
        return new CacheSpec(mSet, cSet);
    }

    @Slow
    private static CacheData readCacheData(StarTable table, Set<MaskSpec> maskSet, Set<CoordSpec> coordSet, CachedColumnFactory colFact, TupleRunner tupleRunner, RowRunner rowRunner) throws IOException, InterruptedException {
        MaskSpec[] masks = maskSet.toArray(new MaskSpec[0]);
        CoordSpec[] coords = coordSet.toArray(new CoordSpec[0]);
        TableCachedData tcd = rowRunner == null ? TableCachedData.readDataSeq(table, masks, coords, colFact) : TableCachedData.readDataPar(table, masks, coords, colFact, rowRunner);
        long nrow = tcd.getRowCount();
        List<Supplier<CachedReader>> maskCols = tcd.getMaskColumns();
        List<Supplier<CachedReader>> coordCols = tcd.getCoordColumns();
        HashMap<StarTable, Long> nMap = new HashMap<StarTable, Long>();
        HashMap<MaskSpec, Supplier<CachedReader>> mMap = new HashMap<MaskSpec, Supplier<CachedReader>>();
        HashMap<CoordSpec, Supplier<CachedReader>> cMap = new HashMap<CoordSpec, Supplier<CachedReader>>();
        nMap.put(table, nrow);
        for (int im = 0; im < masks.length; ++im) {
            mMap.put(masks[im], maskCols.get(im));
        }
        for (int ic = 0; ic < coords.length; ++ic) {
            cMap.put(coords[ic], coordCols.get(ic));
        }
        return new CacheData(tupleRunner, mMap, cMap, nMap);
    }

    private static String itemCount(Collection<?> collection, String word) {
        int count = collection.size();
        StringBuilder sbuf = new StringBuilder().append(count).append(' ').append(word);
        if (count != 1) {
            sbuf.append('s');
        }
        return sbuf.toString();
    }

    private static class CacheData
    implements DataStore {
        private final TupleRunner tupleRunner_;
        private final Map<MaskSpec, Supplier<CachedReader>> mMap_;
        private final Map<CoordSpec, Supplier<CachedReader>> cMap_;
        private final Map<StarTable, Long> nMap_;

        CacheData(TupleRunner tupleRunner, Map<MaskSpec, Supplier<CachedReader>> mMap, Map<CoordSpec, Supplier<CachedReader>> cMap, Map<StarTable, Long> nMap) {
            this.tupleRunner_ = tupleRunner;
            this.mMap_ = new HashMap<MaskSpec, Supplier<CachedReader>>(mMap);
            this.cMap_ = new HashMap<CoordSpec, Supplier<CachedReader>>(cMap);
            this.nMap_ = new HashMap<StarTable, Long>(nMap);
        }

        CacheData(TupleRunner tupleRunner, CacheData cloned) {
            this(cloned.tupleRunner_, cloned.mMap_, cloned.cMap_, cloned.nMap_);
        }

        CacheData(TupleRunner runner) {
            this(runner, new HashMap<MaskSpec, Supplier<CachedReader>>(), new HashMap<CoordSpec, Supplier<CachedReader>>(), new HashMap<StarTable, Long>());
        }

        CacheSpec getSpec() {
            return new CacheSpec(this.mMap_.keySet(), this.cMap_.keySet());
        }

        CacheData add(CacheData other) {
            CacheData result = new CacheData(this.tupleRunner_, this.mMap_, this.cMap_, this.nMap_);
            result.mMap_.putAll(other.mMap_);
            result.cMap_.putAll(other.cMap_);
            result.nMap_.putAll(other.nMap_);
            return result;
        }

        CacheData retain(CacheSpec spec) {
            HashSet<StarTable> tSet = new HashSet<StarTable>();
            for (MaskSpec mSpec : this.mMap_.keySet()) {
                tSet.add(mSpec.getTable());
            }
            for (CoordSpec cSpec : this.cMap_.keySet()) {
                tSet.add(cSpec.getTable());
            }
            CacheData result = new CacheData(this.tupleRunner_, this.mMap_, this.cMap_, this.nMap_);
            result.mMap_.keySet().retainAll(spec.mSet_);
            result.cMap_.keySet().retainAll(spec.cSet_);
            result.nMap_.keySet().retainAll(tSet);
            return result;
        }

        Supplier<CachedReader> getMask(DataSpec dataSpec) {
            return this.mMap_.get(new MaskSpec(dataSpec));
        }

        Supplier<CachedReader> getColumn(DataSpec dataSpec, int icoord) {
            return this.cMap_.get(new CoordSpec(dataSpec, icoord));
        }

        List<Supplier<CachedReader>> getColumns(DataSpec dataSpec) {
            int ncol = dataSpec.getCoordCount();
            ArrayList<Supplier<CachedReader>> cols = new ArrayList<Supplier<CachedReader>>();
            for (int ic = 0; ic < ncol; ++ic) {
                Supplier<CachedReader> col = this.getColumn(dataSpec, ic);
                if (col == null) {
                    return null;
                }
                cols.add(col);
            }
            return cols;
        }

        @Override
        public boolean hasData(DataSpec spec) {
            return this.getMask(spec) != null && this.getColumns(spec) != null;
        }

        @Override
        public TupleSequence getTupleSequence(DataSpec spec) {
            Long nRow = this.nMap_.get(spec.getSourceTable());
            long nrow = nRow == null ? -1L : nRow;
            Supplier<CachedReader> maskSupplier = this.getMask(spec);
            List<Supplier<CachedReader>> cols = this.getColumns(spec);
            int ncol = cols.size();
            Supplier<CachedReader[]> colsSupplier = () -> {
                CachedReader[] rdrs = new CachedReader[ncol];
                for (int ic = 0; ic < ncol; ++ic) {
                    rdrs[ic] = (CachedReader)((Supplier)cols.get(ic)).get();
                }
                return rdrs;
            };
            return new CachedTupleSequence(maskSupplier, colsSupplier, nrow);
        }

        @Override
        public TupleRunner getTupleRunner() {
            return this.tupleRunner_;
        }
    }

    private static class CacheSpec {
        private final Set<MaskSpec> mSet_;
        private final Set<CoordSpec> cSet_;

        CacheSpec(Set<MaskSpec> mSet, Set<CoordSpec> cSet) {
            this.mSet_ = new HashSet<MaskSpec>(mSet);
            this.cSet_ = new HashSet<CoordSpec>(cSet);
        }

        CacheSpec subtract(CacheSpec other) {
            CacheSpec result = new CacheSpec(this.mSet_, this.cSet_);
            result.mSet_.removeAll(other.mSet_);
            result.cSet_.removeAll(other.cSet_);
            return result;
        }

        boolean isEmpty() {
            return this.mSet_.isEmpty() && this.cSet_.isEmpty();
        }

        @Slow
        CacheData readData(CachedColumnFactory colFact, TupleRunner tupleRunner, RowRunner rowRunner) throws IOException, InterruptedException {
            Level level = Level.INFO;
            if (logger_.isLoggable(level)) {
                String msg = "Caching plot data: " + CachedDataStoreFactory.itemCount(this.getTables(), "table") + ", " + CachedDataStoreFactory.itemCount(this.mSet_, "mask") + ", " + CachedDataStoreFactory.itemCount(this.cSet_, "coord");
                logger_.log(level, msg);
            }
            CacheData data = new CacheData(tupleRunner);
            for (StarTable table : this.getTables()) {
                CacheData tData = CachedDataStoreFactory.readCacheData(table, this.getMasks(table), this.getCoords(table), colFact, tupleRunner, rowRunner);
                data = data.add(tData);
            }
            return data;
        }

        private Set<StarTable> getTables() {
            HashSet<StarTable> tSet = new HashSet<StarTable>();
            for (MaskSpec mask : this.mSet_) {
                tSet.add(mask.getTable());
            }
            for (CoordSpec coord : this.cSet_) {
                tSet.add(coord.getTable());
            }
            return tSet;
        }

        private Set<MaskSpec> getMasks(StarTable table) {
            HashSet<MaskSpec> tmSet = new HashSet<MaskSpec>();
            for (MaskSpec mask : this.mSet_) {
                if (!mask.getTable().equals(table)) continue;
                tmSet.add(mask);
            }
            return tmSet;
        }

        private Set<CoordSpec> getCoords(StarTable table) {
            HashSet<CoordSpec> tcSet = new HashSet<CoordSpec>();
            for (CoordSpec coord : this.cSet_) {
                if (!coord.getTable().equals(table)) continue;
                tcSet.add(coord);
            }
            return tcSet;
        }

        public String toString() {
            return "Masks: " + this.mSet_ + "; Columns: " + this.cSet_;
        }
    }
}

