/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import uk.ac.starlink.table.Domain;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.SingleCoord;
import uk.ac.starlink.ttools.plot2.data.StorageType;
import uk.ac.starlink.ttools.plot2.data.Tuple;

public abstract class FixedLengthVectorCoord
extends SingleCoord {
    public static final VectorDomain FLOATING_VECTOR3_DOMAIN = FixedLengthVectorCoord.createFloatingVector3Domain();
    public static final FixedLengthVectorCoord XYZ_COORD = FixedLengthVectorCoord.createXyzCoord();

    protected FixedLengthVectorCoord(InputMeta meta, boolean isRequired, VectorDomain domain, StorageType storage) {
        super(meta, isRequired, domain, storage);
    }

    public abstract void readElements(Tuple var1, int var2, double[] var3);

    private static FixedLengthVectorCoord createFloatingVector3Coord(InputMeta meta, boolean isRequired) {
        if (PlotUtil.storeFullPrecision()) {
            return new FixedLengthVectorCoord(meta, isRequired, FLOATING_VECTOR3_DOMAIN, StorageType.DOUBLE3){

                public Function<Object[], double[]> inputStorage(ValueInfo[] infos, DomainMapper[] dms) {
                    return FixedLengthVectorCoord.doubleInputStorage(infos[0].getContentClass(), 3);
                }

                @Override
                public void readElements(Tuple tuple, int icol, double[] vec3) {
                    double[] dval = (double[])tuple.getObjectValue(icol);
                    vec3[0] = dval[0];
                    vec3[1] = dval[1];
                    vec3[2] = dval[2];
                }
            };
        }
        return new FixedLengthVectorCoord(meta, isRequired, FLOATING_VECTOR3_DOMAIN, StorageType.FLOAT3){

            public Function<Object[], float[]> inputStorage(ValueInfo[] infos, DomainMapper[] dms) {
                return FixedLengthVectorCoord.floatInputStorage(infos[0].getContentClass(), 3);
            }

            @Override
            public void readElements(Tuple tuple, int icol, double[] vec3) {
                float[] fval = (float[])tuple.getObjectValue(icol);
                vec3[0] = fval[0];
                vec3[1] = fval[1];
                vec3[2] = fval[2];
            }
        };
    }

    private static FixedLengthVectorCoord createXyzCoord() {
        InputMeta meta = new InputMeta("xyz", "XYZ Vector");
        meta.setShortDescription("3-element Cartesian component array");
        meta.setValueUsage("array");
        meta.setXmlDescription(new String[]{"<p>3-element array giving the X, Y and Z components", "of a point in 3-d space.", "If an array longer than 3 elements is supplied,", "the extra elements are ignored.", "</p>"});
        boolean isRequired = true;
        return FixedLengthVectorCoord.createFloatingVector3Coord(meta, isRequired);
    }

    private static VectorDomain createFloatingVector3Domain() {
        return new VectorDomain(3, new Class[]{double[].class, float[].class, long[].class, int[].class, short[].class, byte[].class});
    }

    private static Function<Object[], double[]> doubleInputStorage(Class<?> clazz, int nel) {
        double[] blank = new double[nel];
        for (int i = 0; i < nel; ++i) {
            blank[i] = Double.NaN;
        }
        if (double[].class.equals(clazz)) {
            return values -> {
                Object array = values[0];
                if (array instanceof double[]) {
                    double[] darray = (double[])array;
                    if (darray.length == nel) {
                        return darray;
                    }
                    if (darray.length > nel) {
                        double[] dv = new double[nel];
                        for (int i = 0; i < nel; ++i) {
                            dv[i] = darray[i];
                        }
                        return dv;
                    }
                    return blank;
                }
                return blank;
            };
        }
        if (float[].class.equals(clazz)) {
            return values -> {
                Object array = values[0];
                if (array instanceof float[]) {
                    float[] farray = (float[])array;
                    if (farray.length >= nel) {
                        double[] dv = new double[nel];
                        for (int i = 0; i < nel; ++i) {
                            dv[i] = farray[i];
                        }
                        return dv;
                    }
                    return blank;
                }
                return blank;
            };
        }
        if (long[].class.equals(clazz)) {
            return values -> {
                Object array = values[0];
                if (array instanceof long[]) {
                    long[] larray = (long[])array;
                    if (larray.length >= nel) {
                        double[] dv = new double[nel];
                        for (int i = 0; i < nel; ++i) {
                            dv[i] = larray[i];
                        }
                        return dv;
                    }
                    return blank;
                }
                return blank;
            };
        }
        if (int[].class.equals(clazz)) {
            return values -> {
                Object array = values[0];
                if (array instanceof int[]) {
                    int[] iarray = (int[])array;
                    if (iarray.length >= nel) {
                        double[] dv = new double[nel];
                        for (int i = 0; i < nel; ++i) {
                            dv[i] = iarray[i];
                        }
                        return dv;
                    }
                    return blank;
                }
                return blank;
            };
        }
        if (short[].class.equals(clazz)) {
            return values -> {
                Object array = values[0];
                if (array instanceof short[]) {
                    short[] sarray = (short[])array;
                    if (sarray.length >= nel) {
                        double[] dv = new double[nel];
                        for (int i = 0; i < nel; ++i) {
                            dv[i] = sarray[i];
                        }
                        return dv;
                    }
                    return blank;
                }
                return blank;
            };
        }
        if (byte[].class.equals(clazz)) {
            return values -> {
                Object array = values[0];
                if (array instanceof byte[]) {
                    byte[] barray = (byte[])array;
                    if (barray.length >= nel) {
                        double[] dv = new double[nel];
                        for (int i = 0; i < nel; ++i) {
                            dv[i] = barray[i];
                        }
                        return dv;
                    }
                    return blank;
                }
                return blank;
            };
        }
        return null;
    }

    private static Function<Object[], float[]> floatInputStorage(Class<?> clazz, int nel) {
        float[] blank = new float[nel];
        for (int i = 0; i < nel; ++i) {
            blank[i] = Float.NaN;
        }
        if (float[].class.equals(clazz)) {
            return values -> {
                Object array = values[0];
                if (array instanceof float[]) {
                    float[] farray = (float[])array;
                    if (farray.length == nel) {
                        return farray;
                    }
                    if (farray.length > nel) {
                        float[] fv = new float[nel];
                        for (int i = 0; i < nel; ++i) {
                            fv[i] = farray[i];
                        }
                        return fv;
                    }
                    return blank;
                }
                return blank;
            };
        }
        if (double[].class.equals(clazz)) {
            return values -> {
                Object array = values[0];
                if (array instanceof double[]) {
                    double[] darray = (double[])array;
                    if (darray.length >= nel) {
                        float[] fv = new float[nel];
                        for (int i = 0; i < nel; ++i) {
                            fv[i] = (float)darray[i];
                        }
                        return fv;
                    }
                    return blank;
                }
                return blank;
            };
        }
        if (long[].class.equals(clazz)) {
            return values -> {
                Object array = values[0];
                if (array instanceof long[]) {
                    long[] larray = (long[])array;
                    if (larray.length >= nel) {
                        float[] fv = new float[nel];
                        for (int i = 0; i < nel; ++i) {
                            fv[i] = larray[i];
                        }
                        return fv;
                    }
                    return blank;
                }
                return blank;
            };
        }
        if (int[].class.equals(clazz)) {
            return values -> {
                Object array = values[0];
                if (array instanceof int[]) {
                    int[] iarray = (int[])array;
                    if (iarray.length >= nel) {
                        float[] fv = new float[nel];
                        for (int i = 0; i < nel; ++i) {
                            fv[i] = iarray[i];
                        }
                        return fv;
                    }
                    return blank;
                }
                return blank;
            };
        }
        if (short[].class.equals(clazz)) {
            return values -> {
                Object array = values[0];
                if (array instanceof short[]) {
                    short[] sarray = (short[])array;
                    if (sarray.length >= nel) {
                        float[] fv = new float[nel];
                        for (int i = 0; i < nel; ++i) {
                            fv[i] = sarray[i];
                        }
                        return fv;
                    }
                    return blank;
                }
                return blank;
            };
        }
        if (byte[].class.equals(clazz)) {
            return values -> {
                Object array = values[0];
                if (array instanceof byte[]) {
                    byte[] barray = (byte[])array;
                    if (barray.length >= nel) {
                        float[] fv = new float[nel];
                        for (int i = 0; i < nel; ++i) {
                            fv[i] = barray[i];
                        }
                        return fv;
                    }
                    return blank;
                }
                return blank;
            };
        }
        return values -> blank;
    }

    public static class VectorDomain
    implements Domain<VectorDomain>,
    DomainMapper {
        private final int nel_;
        private final Collection<Class<?>> userClasses_;
        private final VectorDomain mapper_;
        private final VectorDomain domain_;

        public VectorDomain(int nel, Class<?>[] userClasses) {
            this.nel_ = nel;
            this.userClasses_ = Arrays.asList(userClasses);
            this.mapper_ = this;
            this.domain_ = this;
        }

        public String getDomainName() {
            return this.nel_ + "-vector";
        }

        public VectorDomain[] getMappers() {
            return new VectorDomain[]{this.mapper_};
        }

        public VectorDomain getProbableMapper(ValueInfo info) {
            int[] shape = info.getShape();
            if (shape != null && shape.length == 1 && shape[0] == this.nel_ && this.userClasses_.contains(info.getContentClass())) {
                return this.mapper_;
            }
            return null;
        }

        public VectorDomain getPossibleMapper(ValueInfo info) {
            if (this.userClasses_.contains(info.getContentClass())) {
                int[] shape = info.getShape();
                if (shape != null && shape.length == 1) {
                    if (shape[0] < 0 || shape[0] >= this.nel_) {
                        return this.mapper_;
                    }
                    return null;
                }
                return this.mapper_;
            }
            return null;
        }

        public VectorDomain getTargetDomain() {
            return this.domain_;
        }

        public Class<?> getSourceClass() {
            return Object.class;
        }

        public String getSourceName() {
            return this.nel_ + "-vector";
        }

        public String getSourceDescription() {
            return this.nel_ + "-element array-valued quantity";
        }

        public int hashCode() {
            return this.nel_;
        }

        public boolean equals(Object o) {
            return o instanceof VectorDomain && ((VectorDomain)o).nel_ == this.nel_;
        }
    }
}

