/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.util.function.Function;
import uk.ac.starlink.table.Domain;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.SingleCoord;
import uk.ac.starlink.ttools.plot2.data.StorageType;
import uk.ac.starlink.ttools.plot2.data.Tuple;

public abstract class FloatingArrayCoord
extends SingleCoord {
    public static final FloatingArrayCoord X = FloatingArrayCoord.createXYArrayCoord(false);
    public static final FloatingArrayCoord Y = FloatingArrayCoord.createXYArrayCoord(true);

    private FloatingArrayCoord(InputMeta meta, boolean isRequired, boolean isDouble) {
        super(meta, isRequired, ArrayDomain.INSTANCE, isDouble ? StorageType.DOUBLE_ARRAY : StorageType.FLOAT_ARRAY);
    }

    public abstract double[] readArrayCoord(Tuple var1, int var2);

    public abstract int getArrayCoordLength(Tuple var1, int var2);

    public static Class<?>[] getAcceptableClasses() {
        return new Class[]{double[].class, float[].class, long[].class, int[].class, short[].class, byte[].class};
    }

    public static FloatingArrayCoord createCoord(InputMeta meta, boolean isRequired) {
        if (PlotUtil.storeFullPrecision()) {
            final double[] d0 = new double[]{};
            return new FloatingArrayCoord(meta, isRequired, true){

                public Function<Object[], double[]> inputStorage(ValueInfo[] infos, DomainMapper[] dms) {
                    Class clazz = infos[0].getContentClass();
                    if (double[].class.equals((Object)clazz)) {
                        return values -> {
                            Object array = values[0];
                            return array instanceof double[] ? (double[])array : d0;
                        };
                    }
                    if (float[].class.equals((Object)clazz)) {
                        return values -> {
                            Object array = values[0];
                            if (array instanceof float[]) {
                                float[] fa = (float[])array;
                                int n = fa.length;
                                double[] da = new double[n];
                                for (int i = 0; i < n; ++i) {
                                    da[i] = fa[i];
                                }
                                return da;
                            }
                            return d0;
                        };
                    }
                    if (long[].class.equals((Object)clazz)) {
                        return values -> {
                            Object array = values[0];
                            if (array instanceof long[]) {
                                long[] la = (long[])array;
                                int n = la.length;
                                double[] da = new double[n];
                                for (int i = 0; i < n; ++i) {
                                    da[i] = la[i];
                                }
                                return da;
                            }
                            return d0;
                        };
                    }
                    if (int[].class.equals((Object)clazz)) {
                        return values -> {
                            Object array = values[0];
                            if (array instanceof int[]) {
                                int[] ia = (int[])array;
                                int n = ia.length;
                                double[] da = new double[n];
                                for (int i = 0; i < n; ++i) {
                                    da[i] = ia[i];
                                }
                                return da;
                            }
                            return d0;
                        };
                    }
                    if (short[].class.equals((Object)clazz)) {
                        return values -> {
                            Object array = values[0];
                            if (array instanceof short[]) {
                                short[] sa = (short[])array;
                                int n = sa.length;
                                double[] da = new double[n];
                                for (int i = 0; i < n; ++i) {
                                    da[i] = sa[i];
                                }
                                return da;
                            }
                            return d0;
                        };
                    }
                    if (byte[].class.equals((Object)clazz)) {
                        return values -> {
                            Object array = values[0];
                            if (array instanceof byte[]) {
                                byte[] ba = (byte[])array;
                                int n = ba.length;
                                double[] da = new double[n];
                                for (int i = 0; i < n; ++i) {
                                    da[i] = ba[i];
                                }
                                return da;
                            }
                            return d0;
                        };
                    }
                    return values -> d0;
                }

                @Override
                public int getArrayCoordLength(Tuple tuple, int icol) {
                    return ((double[])tuple.getObjectValue(icol)).length;
                }

                @Override
                public double[] readArrayCoord(Tuple tuple, int icol) {
                    double[] dval = (double[])tuple.getObjectValue(icol);
                    return dval;
                }
            };
        }
        final float[] f0 = new float[]{};
        return new FloatingArrayCoord(meta, isRequired, false){

            public Function<Object[], float[]> inputStorage(ValueInfo[] infos, DomainMapper[] dms) {
                Class clazz = infos[0].getContentClass();
                if (float[].class.equals((Object)clazz)) {
                    return values -> {
                        Object array = values[0];
                        return array instanceof float[] ? (float[])array : f0;
                    };
                }
                if (double[].class.equals((Object)clazz)) {
                    return values -> {
                        Object array = values[0];
                        if (array instanceof double[]) {
                            double[] da = (double[])array;
                            int n = da.length;
                            float[] fa = new float[n];
                            for (int i = 0; i < n; ++i) {
                                fa[i] = (float)da[i];
                            }
                            return fa;
                        }
                        return f0;
                    };
                }
                if (long[].class.equals((Object)clazz)) {
                    return values -> {
                        Object array = values[0];
                        if (array instanceof long[]) {
                            long[] la = (long[])array;
                            int n = la.length;
                            float[] fa = new float[n];
                            for (int i = 0; i < n; ++i) {
                                fa[i] = la[i];
                            }
                            return fa;
                        }
                        return f0;
                    };
                }
                if (int[].class.equals((Object)clazz)) {
                    return values -> {
                        Object array = values[0];
                        if (array instanceof int[]) {
                            int[] ia = (int[])array;
                            int n = ia.length;
                            float[] fa = new float[n];
                            for (int i = 0; i < n; ++i) {
                                fa[i] = ia[i];
                            }
                            return fa;
                        }
                        return f0;
                    };
                }
                if (short[].class.equals((Object)clazz)) {
                    return values -> {
                        Object array = values[0];
                        if (array instanceof short[]) {
                            short[] sa = (short[])array;
                            int n = sa.length;
                            float[] fa = new float[n];
                            for (int i = 0; i < n; ++i) {
                                fa[i] = sa[i];
                            }
                            return fa;
                        }
                        return f0;
                    };
                }
                if (byte[].class.equals((Object)clazz)) {
                    return values -> {
                        Object array = values[0];
                        if (array instanceof byte[]) {
                            byte[] ba = (byte[])array;
                            int n = ba.length;
                            float[] fa = new float[n];
                            for (int i = 0; i < n; ++i) {
                                fa[i] = ba[i];
                            }
                            return fa;
                        }
                        return f0;
                    };
                }
                assert (false);
                return values -> f0;
            }

            @Override
            public int getArrayCoordLength(Tuple tuple, int icol) {
                return ((float[])tuple.getObjectValue(icol)).length;
            }

            @Override
            public double[] readArrayCoord(Tuple tuple, int icol) {
                float[] fval = (float[])tuple.getObjectValue(icol);
                int n = fval.length;
                double[] dval = new double[n];
                for (int i = 0; i < n; ++i) {
                    dval[i] = fval[i];
                }
                return dval;
            }
        };
    }

    private static FloatingArrayCoord createXYArrayCoord(boolean isY) {
        String axId = isY ? "Y" : "X";
        String axid = axId.toLowerCase();
        String otherAxId = isY ? "X" : "Y";
        InputMeta meta = new InputMeta(axid + "s", axId + " Values");
        meta.setShortDescription(axId + " coords array");
        meta.setValueUsage("array");
        meta.setXmlDescription(new String[]{"<p>Array giving the " + axId + " coordinate array for each line.", "In most cases, if a blank value is supplied but", otherAxId + " values are present then a suitable linear sequence,", "of the same length as the " + otherAxId + " array, is assumed.", "</p>"});
        boolean isRequired = false;
        return FloatingArrayCoord.createCoord(meta, isRequired);
    }

    private static class ArrayMapper
    implements DomainMapper {
        static final ArrayMapper INSTANCE = new ArrayMapper();

        private ArrayMapper() {
        }

        public ArrayDomain getTargetDomain() {
            return ArrayDomain.INSTANCE;
        }

        public Class<?> getSourceClass() {
            return Object.class;
        }

        public String getSourceName() {
            return "array";
        }

        public String getSourceDescription() {
            return "array-valued quantity";
        }
    }

    public static class ArrayDomain
    implements Domain<ArrayMapper> {
        static final ArrayDomain INSTANCE = new ArrayDomain();

        public String getDomainName() {
            return "Array";
        }

        public ArrayMapper[] getMappers() {
            return new ArrayMapper[]{ArrayMapper.INSTANCE};
        }

        public ArrayMapper getProbableMapper(ValueInfo info) {
            Class clazz = info.getContentClass();
            for (Class<?> c : FloatingArrayCoord.getAcceptableClasses()) {
                if (!c.equals(clazz)) continue;
                return ArrayMapper.INSTANCE;
            }
            return null;
        }

        public ArrayMapper getPossibleMapper(ValueInfo info) {
            return this.getProbableMapper(info);
        }
    }
}

