/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.io.IOException;
import uk.ac.starlink.table.RowData;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.UserDataReader;

@Equality
public class MaskSpec {
    private final DataSpec dataSpec_;
    private final StarTable table_;
    private final String maskId_;

    public MaskSpec(DataSpec dataSpec) {
        this.dataSpec_ = dataSpec;
        this.table_ = dataSpec.getSourceTable();
        this.maskId_ = dataSpec.getMaskId();
    }

    public StarTable getTable() {
        return this.table_;
    }

    public String getMaskId() {
        return this.maskId_;
    }

    public Reader flagReader(RowData rdata) {
        UserDataReader dataReader = this.dataSpec_.createUserDataReader();
        return irow -> dataReader.getMaskFlag(rdata, irow);
    }

    public boolean equals(Object o) {
        if (o instanceof MaskSpec) {
            MaskSpec other = (MaskSpec)o;
            return other.table_.equals(this.table_) && other.maskId_.equals(this.maskId_);
        }
        return false;
    }

    public int hashCode() {
        return this.table_.hashCode() * 23 + this.maskId_.hashCode();
    }

    public String toString() {
        return String.valueOf(this.maskId_);
    }

    @FunctionalInterface
    public static interface Reader {
        public boolean readFlag(long var1) throws IOException;
    }
}

