/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import uk.ac.starlink.table.Domain;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot2.PlotUtil;

public class SimpleDomain<T>
implements Domain<Mapper<T>> {
    private final String domainName_;
    private final String sourceName_;
    private final String sourceDescription_;
    private final Class<T> clazz_;
    private final Mapper<T> mapper_;
    public static final SimpleDomain<Number> NUMERIC_DOMAIN = new SimpleDomain<Number>(Number.class, "Number", "number", "Numeric value");
    public static final Mapper<Number> NUMERIC_MAPPER = NUMERIC_DOMAIN.getMapper();

    protected SimpleDomain(Class<T> clazz, String domainName, String sourceName, String sourceDescription) {
        this.clazz_ = clazz;
        this.domainName_ = domainName;
        this.sourceName_ = sourceName;
        this.sourceDescription_ = sourceDescription;
        this.mapper_ = new Mapper(this);
    }

    public String getDomainName() {
        return this.domainName_;
    }

    public Mapper<T>[] getMappers() {
        return PlotUtil.singletonArray(this.mapper_);
    }

    public Mapper<T> getProbableMapper(ValueInfo info) {
        return this.clazz_.isAssignableFrom(info.getContentClass()) ? this.mapper_ : null;
    }

    public Mapper<T> getPossibleMapper(ValueInfo info) {
        return this.clazz_.isAssignableFrom(info.getContentClass()) ? this.mapper_ : null;
    }

    public Mapper<T> getMapper() {
        return this.mapper_;
    }

    public static class Mapper<T>
    implements DomainMapper {
        private final SimpleDomain<T> domain_;
        private final Class<T> clazz_;

        public Mapper(SimpleDomain<T> domain) {
            this.domain_ = domain;
            this.clazz_ = ((SimpleDomain)domain).clazz_;
        }

        public SimpleDomain<T> getTargetDomain() {
            return this.domain_;
        }

        public Class<?> getSourceClass() {
            return this.clazz_;
        }

        public String getSourceName() {
            return ((SimpleDomain)this.domain_).sourceName_;
        }

        public String getSourceDescription() {
            return ((SimpleDomain)this.domain_).sourceDescription_;
        }
    }
}

