/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.TupleRunner;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.data.WrapperTuple;

public class StepDataStore
implements DataStore {
    private final DataStore baseStore_;
    private final int step_;

    public StepDataStore(DataStore base, int step) {
        this.baseStore_ = base;
        this.step_ = step;
    }

    @Override
    public TupleSequence getTupleSequence(DataSpec spec) {
        return new StepTupleSequence(this.baseStore_.getTupleSequence(spec), this.step_);
    }

    @Override
    public boolean hasData(DataSpec spec) {
        return this.baseStore_.hasData(spec);
    }

    @Override
    public TupleRunner getTupleRunner() {
        return this.baseStore_.getTupleRunner();
    }

    private static class StepTupleSequence
    extends WrapperTuple
    implements TupleSequence {
        private final TupleSequence baseSeq_;
        private final int step_;

        StepTupleSequence(TupleSequence baseSeq, int step) {
            super(baseSeq);
            this.baseSeq_ = baseSeq;
            this.step_ = step;
        }

        @Override
        public boolean next() {
            for (int i = 0; i < this.step_; ++i) {
                if (this.baseSeq_.next()) continue;
                return false;
            }
            return true;
        }

        public TupleSequence split() {
            TupleSequence splitSeq = (TupleSequence)this.baseSeq_.split();
            return splitSeq == null ? null : new StepTupleSequence(splitSeq, this.step_);
        }

        public long splittableSize() {
            return this.baseSeq_.splittableSize() / (long)this.step_;
        }
    }
}

