/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import skyview.data.AngScale;

public class AngScale2
extends AngScale {
    private final double[] deciBigs = new double[]{360.0, 180.0, 120.0, 60.0, 30.0, 15.0, 5.0, 3.0, 1.0};
    private final double[] deciSmalls = new double[]{0.5, 0.2, 0.1};
    private final double[] sexaBigs = new double[]{360.0, 180.0, 120.0, 60.0, 30.0, 15.0, 5.0, 2.0, 1.0, 0.5, 0.3333333333333333, 0.16666666666666666, 0.08333333333333333, 0.03333333333333333, 0.016666666666666666, 0.008333333333333333, 0.005555555555555556, 0.002777777777777778, 0.001388888888888889, 5.555555555555556E-4, 2.777777777777778E-4};
    private final double[] timeBigs = new double[]{24.0, 12.0, 6.0, 3.0, 2.0, 1.0, 0.5, 0.3333333333333333, 0.16666666666666666, 0.08333333333333333, 0.03333333333333333, 0.016666666666666666, 0.008333333333333333, 0.005555555555555556, 0.002777777777777778, 0.001388888888888889, 5.555555555555556E-4, 2.777777777777778E-4};
    private final double[] sexaSmalls = new double[]{1.388888888888889E-4, 5.555555555555556E-5, 2.777777777777778E-5};
    private final double minDivs = 3.0;
    private boolean sexagesimal = true;
    private boolean time = false;

    public double scale(double delta) {
        double[] smalls;
        double[] bigs;
        if (delta == 0.0) {
            return 0.0;
        }
        delta = Math.abs(delta);
        if (this.time) {
            bigs = this.timeBigs;
            smalls = this.sexaSmalls;
        } else if (this.sexagesimal) {
            bigs = this.sexaBigs;
            smalls = this.sexaSmalls;
        } else {
            bigs = this.deciBigs;
            smalls = this.deciSmalls;
        }
        for (int i = 0; i < bigs.length; ++i) {
            if (!(delta / bigs[i] > 3.0)) continue;
            return bigs[i];
        }
        for (double tens = 1.0; tens < 1.0E10; tens *= 10.0) {
            for (int i = 0; i < smalls.length; ++i) {
                double div = smalls[i] / tens;
                if (!(delta / div > 3.0)) continue;
                return div;
            }
        }
        return 0.0;
    }

    public double[] scaling(double min, double max) {
        if (min == max) {
            return null;
        }
        double delt = max - min;
        if (min > max) {
            delt = !this.time ? (delt += 360.0) : (delt += 24.0);
        }
        delt = this.scale(delt);
        min = min > 0.0 ? min - min % delt + delt : (min -= min % delt);
        return new double[]{min, delt};
    }

    public void setSexagesimal(boolean flag) {
        this.sexagesimal = flag;
    }

    public void setTime(boolean flag) {
        this.time = flag;
    }
}

