/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotMetric;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.config.BooleanConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.DoubleConfigKey;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.geom.CubeAspect;
import uk.ac.starlink.ttools.plot2.geom.CubeNavigator;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.geom.OrientationPolicy;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurfaceFactory;

public class CubeSurfaceFactory
implements SurfaceFactory<Profile, CubeAspect> {
    private final boolean isIso_;
    public static final ConfigKey<Scale> XSCALE_KEY = PlaneSurfaceFactory.createAxisScaleKey("X");
    public static final ConfigKey<Scale> YSCALE_KEY = PlaneSurfaceFactory.createAxisScaleKey("Y");
    public static final ConfigKey<Scale> ZSCALE_KEY = PlaneSurfaceFactory.createAxisScaleKey("Z");
    public static final ConfigKey<Boolean> XLOG_KEY = PlaneSurfaceFactory.createAxisLogKey("X");
    public static final ConfigKey<Boolean> YLOG_KEY = PlaneSurfaceFactory.createAxisLogKey("Y");
    public static final ConfigKey<Boolean> ZLOG_KEY = PlaneSurfaceFactory.createAxisLogKey("Z");
    public static final ConfigKey<Boolean> XFLIP_KEY = PlaneSurfaceFactory.createAxisFlipKey("X");
    public static final ConfigKey<Boolean> YFLIP_KEY = PlaneSurfaceFactory.createAxisFlipKey("Y");
    public static final ConfigKey<Boolean> ZFLIP_KEY = PlaneSurfaceFactory.createAxisFlipKey("Z");
    public static final ConfigKey<String> XLABEL_KEY = StyleKeys.createAxisLabelKey("X");
    public static final ConfigKey<String> YLABEL_KEY = StyleKeys.createAxisLabelKey("Y");
    public static final ConfigKey<String> ZLABEL_KEY = StyleKeys.createAxisLabelKey("Z");
    public static final ConfigKey<Boolean> FRAME_KEY = new BooleanConfigKey(new ConfigMeta("frame", "Draw wire frame").setShortDescription("Draw wire frame?").setXmlDescription(new String[]{"<p>If true, a cube wire frame with labelled axes", "is drawn to indicate the limits of the plotted 3D region.", "If false, no wire frame and no axes are drawn.", "</p>"}), true);
    public static final ConfigKey<Double> XCROWD_KEY = PlaneSurfaceFactory.createAxisCrowdKey("X");
    public static final ConfigKey<Double> YCROWD_KEY = PlaneSurfaceFactory.createAxisCrowdKey("Y");
    public static final ConfigKey<Double> ZCROWD_KEY = PlaneSurfaceFactory.createAxisCrowdKey("Z");
    public static final ConfigKey<Double> ISOCROWD_KEY = StyleKeys.createCrowdKey(new ConfigMeta("crowd", "Tick Crowding").setShortDescription("Crowding of axis ticks").setXmlDescription(new String[]{"<p>Determines how closely tick marks are spaced", "on the wire frame axes.", "The default value is 1, meaning normal crowding.", "Larger values result in more grid lines,", "and smaller values in fewer grid lines.", "</p>"}));
    public static final ConfigKey<Double> XMIN_KEY = PlaneSurfaceFactory.createAxisLimitKey("X", false);
    public static final ConfigKey<Double> XMAX_KEY = PlaneSurfaceFactory.createAxisLimitKey("X", true);
    public static final ConfigKey<Subrange> XSUBRANGE_KEY = PlaneSurfaceFactory.createAxisSubrangeKey("X");
    public static final ConfigKey<Double> YMIN_KEY = PlaneSurfaceFactory.createAxisLimitKey("Y", false);
    public static final ConfigKey<Double> YMAX_KEY = PlaneSurfaceFactory.createAxisLimitKey("Y", true);
    public static final ConfigKey<Subrange> YSUBRANGE_KEY = PlaneSurfaceFactory.createAxisSubrangeKey("Y");
    public static final ConfigKey<Double> ZMIN_KEY = PlaneSurfaceFactory.createAxisLimitKey("Z", false);
    public static final ConfigKey<Double> ZMAX_KEY = PlaneSurfaceFactory.createAxisLimitKey("Z", true);
    public static final ConfigKey<Subrange> ZSUBRANGE_KEY = PlaneSurfaceFactory.createAxisSubrangeKey("Z");
    public static final ConfigKey<Double> XC_KEY = CubeSurfaceFactory.createIsoCenterKey("X");
    public static final ConfigKey<Double> YC_KEY = CubeSurfaceFactory.createIsoCenterKey("Y");
    public static final ConfigKey<Double> ZC_KEY = CubeSurfaceFactory.createIsoCenterKey("Z");
    public static final ConfigKey<Boolean> FORCEISO_KEY = new BooleanConfigKey(new ConfigMeta("isometric", "Isometric").setShortDescription("Fix equal X/Y/Z scales").setXmlDescription(new String[]{"<p>If set true, the scaling will be the same on the", "X, Y and Z axes, so that positions retain their", "natural position in 3-d Cartesian space.", "If false, the three axes will be scaled independently,", "so that the positions may be squashed in some directions.", "This option is ignored if there is a mix of linear", "and logarithmic axes.", "</p>"}), false);
    public static final ConfigKey<Double> SCALE_KEY = DoubleConfigKey.createTextKey(new ConfigMeta("scale", "Cube Edge Length").setShortDescription("Cube edge length").setXmlDescription(new String[]{"<p>The length of the cube sides in data coordinates.", "This will be determined from the data range if not supplied.", "</p>"}));
    public static final ConfigKey<Double> PHI_KEY = DoubleConfigKey.createSliderKey(new ConfigMeta("phi", "Rotation \u03c6").setShortDescription("First ZXZ Euler angle of view").setXmlDescription(new String[]{"<p>First of the Euler angles, in the ZXZ sequence,", "defining the rotation of the plotted 3d space.", "Units are degrees.", "This is the rotation around the initial Z axis applied before", "the plot is viewed.", "</p>"}).setStringUsage("<degrees>"), 30.0, -180.0, 180.0, false);
    public static final ConfigKey<Double> THETA_KEY = DoubleConfigKey.createSliderKey(new ConfigMeta("theta", "Rotation \u03b8").setShortDescription("Second ZXZ Euler angle of view").setXmlDescription(new String[]{"<p>Second of the Euler angles, in the ZXZ sequence,", "defining the rotation of the plotted 3d space.", "Units are degrees.", "This is the rotation towards the viewer.", "</p>"}).setStringUsage("<degrees>"), -15.0, -180.0, 180.0, false);
    public static final ConfigKey<Double> PSI_KEY = DoubleConfigKey.createSliderKey(new ConfigMeta("psi", "Rotation \u03c8").setShortDescription("Third ZXZ Euler angle of view").setXmlDescription(new String[]{"<p>Second of the Euler angles, in the ZXZ sequence,", "defining the rotation of the plotted 3d space.", "Units are degrees.", "</p>"}).setStringUsage("<degrees>"), 0.0, -180.0, 180.0, false);
    public static final ConfigKey<Double> ZOOM_KEY = DoubleConfigKey.createSliderKey(new ConfigMeta("zoom", "Zoom factor").setShortDescription("Magnification factor").setXmlDescription(new String[]{"<p>Sets the magnification factor at which the the", "plotted 3D region itself is viewed,", "without affecting its contents.", "The default value is 1, which means the cube", "fits into the plotting space however it is rotated.", "Much higher zoom factors will result in parts of the", "plotting region and axes being drawn outside of", "the plotting region (so invisible).", "</p>"}).setStringUsage("<factor>"), 1.0, 0.1, 10.0, true);
    public static final ConfigKey<Double> XOFF_KEY = DoubleConfigKey.createSliderKey(new ConfigMeta("xoff", "X offset of centre").setShortDescription("Horizontal offset in pixels").setXmlDescription(new String[]{"<p>Shifts the whole plot within the plotting region", "by the given number of pixels in the horizontal direction.", "</p>"}).setStringUsage("<pixels>"), 0.0, -2.0, 2.0, false);
    public static final ConfigKey<Double> YOFF_KEY = DoubleConfigKey.createSliderKey(new ConfigMeta("yoff", "Y offset of centre").setShortDescription("Vertical offset in pixels").setXmlDescription(new String[]{"<p>Shifts the whole plot within the plotting region", "by the given number of pixels in the vertical direction.", "</p>"}).setStringUsage("<pixels>"), 0.0, -2.0, 2.0, false);
    public static final ConfigKey<OrientationPolicy> ORIENTATIONS_KEY = new OptionConfigKey<OrientationPolicy>(new ConfigMeta("labelangle", "Tick Label Angles").setShortDescription("Tick label orientations").setXmlDescription(new String[]{"<p>Controls the orientation of the numeric labels", "on the axes.", "By default the labels are written parallel to the axes", "as long as they fit, but if they become too crowded", "they can be angled so they don't overlap.", "This option controls the choice of parallel or angled", "labelling.", "</p>"}), OrientationPolicy.class, OrientationPolicy.getOptions(), OrientationPolicy.ADAPTIVE){

        @Override
        public String getXmlDescription(OrientationPolicy orient) {
            return orient.getDescription();
        }
    }.setOptionUsage().addOptionsXml();
    public static final double ISO_CENTER_TOLERANCE = 0.1;

    public CubeSurfaceFactory(boolean isIso) {
        this.isIso_ = isIso;
    }

    @Override
    public Surface createSurface(Rectangle plotBounds, Profile profile, CubeAspect aspect) {
        Profile p = profile;
        return CubeSurface.createSurface(plotBounds, aspect, p.forceiso_, new Scale[]{p.xscale_, p.yscale_, p.zscale_}, new boolean[]{p.xflip_, p.yflip_, p.zflip_}, new String[]{p.xlabel_, p.ylabel_, p.zlabel_}, new double[]{p.xcrowd_, p.ycrowd_, p.zcrowd_}, p.orientpolicy_, p.captioner_, p.frame_, p.minor_, p.antialias_);
    }

    @Override
    public ConfigKey<?>[] getProfileKeys() {
        ArrayList list = new ArrayList();
        if (!this.isIso_) {
            list.addAll(Arrays.asList(XSCALE_KEY, YSCALE_KEY, ZSCALE_KEY, XLOG_KEY, YLOG_KEY, ZLOG_KEY, XFLIP_KEY, YFLIP_KEY, ZFLIP_KEY, FORCEISO_KEY, XLABEL_KEY, YLABEL_KEY, ZLABEL_KEY, XCROWD_KEY, YCROWD_KEY, ZCROWD_KEY, ORIENTATIONS_KEY));
        } else {
            list.addAll(Arrays.asList(ISOCROWD_KEY, ORIENTATIONS_KEY));
        }
        list.addAll(Arrays.asList(FRAME_KEY, StyleKeys.MINOR_TICKS, StyleKeys.GRID_ANTIALIAS));
        list.addAll(Arrays.asList(StyleKeys.CAPTIONER.getKeys()));
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public Profile createProfile(ConfigMap config) {
        Scale xscale = this.isIso_ ? Scale.LINEAR : PlaneSurfaceFactory.getScale(XSCALE_KEY, XLOG_KEY, config);
        Scale yscale = this.isIso_ ? Scale.LINEAR : PlaneSurfaceFactory.getScale(YSCALE_KEY, YLOG_KEY, config);
        Scale zscale = this.isIso_ ? Scale.LINEAR : PlaneSurfaceFactory.getScale(ZSCALE_KEY, ZLOG_KEY, config);
        boolean xflip = this.isIso_ ? false : config.get(XFLIP_KEY);
        boolean yflip = this.isIso_ ? false : config.get(YFLIP_KEY);
        boolean zflip = this.isIso_ ? false : config.get(ZFLIP_KEY);
        String xlabel = this.isIso_ ? "X" : config.get(XLABEL_KEY);
        String ylabel = this.isIso_ ? "Y" : config.get(YLABEL_KEY);
        String zlabel = this.isIso_ ? "Z" : config.get(ZLABEL_KEY);
        double xcrowd = config.get(this.isIso_ ? ISOCROWD_KEY : XCROWD_KEY);
        double ycrowd = config.get(this.isIso_ ? ISOCROWD_KEY : YCROWD_KEY);
        double zcrowd = config.get(this.isIso_ ? ISOCROWD_KEY : ZCROWD_KEY);
        OrientationPolicy orientpolicy = config.get(ORIENTATIONS_KEY);
        boolean forceiso = config.get(FORCEISO_KEY);
        Captioner captioner = StyleKeys.CAPTIONER.createValue(config);
        boolean frame = config.get(FRAME_KEY);
        boolean minor = config.get(StyleKeys.MINOR_TICKS);
        boolean antialias = config.get(StyleKeys.GRID_ANTIALIAS);
        return new Profile(xscale, yscale, zscale, xflip, yflip, zflip, xlabel, ylabel, zlabel, forceiso, captioner, frame, xcrowd, ycrowd, zcrowd, orientpolicy, minor, antialias);
    }

    @Override
    public ConfigKey<?>[] getAspectKeys() {
        ArrayList<ConfigKey> list = new ArrayList<ConfigKey>();
        if (this.isIso_) {
            list.addAll(Arrays.asList(XC_KEY, YC_KEY, ZC_KEY, SCALE_KEY));
        } else {
            list.addAll(Arrays.asList(XMIN_KEY, XMAX_KEY, XSUBRANGE_KEY, YMIN_KEY, YMAX_KEY, YSUBRANGE_KEY, ZMIN_KEY, ZMAX_KEY, ZSUBRANGE_KEY));
        }
        list.addAll(Arrays.asList(PHI_KEY, THETA_KEY, PSI_KEY, ZOOM_KEY, XOFF_KEY, YOFF_KEY));
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public boolean useRanges(Profile profile, ConfigMap config) {
        return this.getUnrangedXyzLimits(profile, config) == null;
    }

    @Override
    public CubeAspect createAspect(Profile profile, ConfigMap config, Range[] ranges) {
        double[][] limits = this.getUnrangedXyzLimits(profile, config);
        if (limits == null) {
            if (ranges == null) {
                ranges = new Range[]{new Range(), new Range(), new Range()};
            }
            limits = this.getRangedXyzLimits(profile, config, ranges);
        }
        double[] rotmat = CubeSurfaceFactory.getRotation(config);
        double zoom = config.get(ZOOM_KEY);
        double xoff = config.get(XOFF_KEY);
        double yoff = config.get(YOFF_KEY);
        return new CubeAspect(limits[0], limits[1], limits[2], rotmat, zoom, xoff, yoff);
    }

    @Override
    public ConfigMap getAspectConfig(Surface surface) {
        return surface instanceof CubeSurface ? ((CubeSurface)surface).getAspectConfig(this.isIso_) : new ConfigMap();
    }

    @Override
    public Range[] readRanges(Profile profile, PlotLayer[] layers, DataStore dataStore) {
        Range[] ranges = new Range[]{new Range(), new Range(), new Range()};
        PlotUtil.extendCoordinateRanges(layers, ranges, profile.getScales(), true, dataStore);
        return ranges;
    }

    @Override
    public ConfigKey<?>[] getNavigatorKeys() {
        return CubeNavigator.getConfigKeys(this.isIso_);
    }

    @Override
    public Navigator<CubeAspect> createNavigator(ConfigMap navConfig) {
        return CubeNavigator.createNavigator(this.isIso_, navConfig);
    }

    @Override
    public PlotMetric getPlotMetric() {
        return null;
    }

    private double[][] getUnrangedXyzLimits(Profile profile, ConfigMap config) {
        Object object;
        if (this.isIso_) {
            Object object2;
            double scale = config.get(SCALE_KEY);
            double xc = config.get(XC_KEY);
            double yc = config.get(YC_KEY);
            double zc = config.get(ZC_KEY);
            double s2 = scale * 0.5;
            if (Double.isNaN(scale) || Double.isNaN(xc) || Double.isNaN(yc) || Double.isNaN(zc)) {
                object2 = null;
            } else {
                double[][] dArrayArray = new double[3][];
                dArrayArray[0] = new double[]{xc - s2, xc + s2};
                dArrayArray[1] = new double[]{yc - s2, yc + s2};
                object2 = dArrayArray;
                dArrayArray[2] = new double[]{zc - s2, zc + s2};
            }
            return object2;
        }
        double[] xlimits = PlaneSurfaceFactory.getLimits(config, XMIN_KEY, XMAX_KEY, XSUBRANGE_KEY, profile.xscale_, null);
        double[] ylimits = PlaneSurfaceFactory.getLimits(config, YMIN_KEY, YMAX_KEY, YSUBRANGE_KEY, profile.yscale_, null);
        double[] zlimits = PlaneSurfaceFactory.getLimits(config, ZMIN_KEY, ZMAX_KEY, ZSUBRANGE_KEY, profile.zscale_, null);
        if (xlimits == null || ylimits == null || zlimits == null) {
            object = null;
        } else {
            double[][] dArrayArray = new double[3][];
            dArrayArray[0] = xlimits;
            dArrayArray[1] = ylimits;
            object = dArrayArray;
            dArrayArray[2] = zlimits;
        }
        return object;
    }

    private double[][] getRangedXyzLimits(Profile profile, ConfigMap config, Range[] ranges) {
        if (this.isIso_) {
            double zc;
            double scale = config.get(SCALE_KEY);
            double xc0 = config.get(XC_KEY);
            double yc0 = config.get(YC_KEY);
            double zc0 = config.get(ZC_KEY);
            double[] xlimits = ranges[0].getFiniteBounds(false);
            double[] ylimits = ranges[1].getFiniteBounds(false);
            double[] zlimits = ranges[2].getFiniteBounds(false);
            double xlo = xlimits[0];
            double xhi = xlimits[1];
            double ylo = ylimits[0];
            double yhi = ylimits[1];
            double zlo = zlimits[0];
            double zhi = zlimits[1];
            double ctol = 0.1;
            double xc = Double.isNaN(xc0) ? CubeSurfaceFactory.getCenter(xlo, xhi, ctol) : xc0;
            double yc = Double.isNaN(yc0) ? CubeSurfaceFactory.getCenter(ylo, yhi, ctol) : yc0;
            double d = zc = Double.isNaN(zc0) ? CubeSurfaceFactory.getCenter(zlo, zhi, ctol) : zc0;
            assert (!Double.isNaN(xc + yc + zc));
            if (Double.isNaN(scale)) {
                scale = 2.0 * CubeSurfaceFactory.max3(Math.max(xhi - xc, xc - xlo), Math.max(yhi - yc, yc - ylo), Math.max(zhi - zc, zc - zlo));
            }
            assert (!Double.isNaN(scale));
            return new double[][]{CubeSurfaceFactory.centerLimits(xlo, xhi, xc, scale), CubeSurfaceFactory.centerLimits(ylo, yhi, yc, scale), CubeSurfaceFactory.centerLimits(zlo, zhi, zc, scale)};
        }
        return new double[][]{PlaneSurfaceFactory.getLimits(config, XMIN_KEY, XMAX_KEY, XSUBRANGE_KEY, profile.xscale_, ranges[0]), PlaneSurfaceFactory.getLimits(config, YMIN_KEY, YMAX_KEY, YSUBRANGE_KEY, profile.yscale_, ranges[1]), PlaneSurfaceFactory.getLimits(config, ZMIN_KEY, ZMAX_KEY, ZSUBRANGE_KEY, profile.zscale_, ranges[2])};
    }

    private static double getCenter(double lo, double hi, double tolerance) {
        double c0 = 0.5 * (lo + hi);
        return Math.abs(c0) / (hi - lo) <= tolerance ? 0.0 : c0;
    }

    private static double[] centerLimits(double lo, double hi, double center, double scale) {
        if (Double.isNaN(center)) {
            center = (lo + hi) * 0.5;
        }
        double s2 = scale * 0.5;
        return new double[]{center - s2, center + s2};
    }

    private static double max3(double a, double b, double c) {
        return Math.max(a, Math.max(b, c));
    }

    public static double[] getRotation(ConfigMap config) {
        return CubeSurfaceFactory.eulerToRotationDegrees(new double[]{config.get(PHI_KEY), config.get(THETA_KEY), config.get(PSI_KEY)});
    }

    public static double[] eulerToRotationDegrees(double[] eulers) {
        int ne = eulers.length;
        double radFact = Math.PI / 180;
        double phiRad = radFact * (ne > 0 ? eulers[0] : 0.0);
        double thetaRad = radFact * (ne > 1 ? eulers[1] : 0.0);
        double psiRad = radFact * (ne > 2 ? eulers[2] : 0.0);
        double s1 = Math.sin(phiRad);
        double c1 = Math.cos(phiRad);
        double s2 = Math.sin(thetaRad);
        double c2 = Math.cos(thetaRad);
        double s3 = Math.sin(psiRad);
        double c3 = Math.cos(psiRad);
        return new double[]{c1 * c3 - c2 * s1 * s3, c3 * s1 + c1 * c2 * s3, s2 * s3, -c1 * s3 - c2 * c3 * s1, c1 * c2 * c3 - s1 * s3, c3 * s2, s1 * s2, -c1 * s2, c2};
    }

    public static double[] rotationToEulerDegrees(double[] rotmat) {
        double psiRad;
        double phiRad;
        double thetaRad = Math.acos(rotmat[8]);
        if (Math.abs(thetaRad) < 0.0017453292519943296) {
            phiRad = Math.acos(rotmat[0]);
            psiRad = 0.0;
        } else {
            phiRad = Math.atan2(rotmat[6], -rotmat[7]);
            psiRad = Math.atan2(rotmat[2], rotmat[5]);
        }
        double degFact = 57.29577951308232;
        return new double[]{degFact * phiRad, degFact * thetaRad, degFact * psiRad};
    }

    private static ConfigKey<Double> createIsoCenterKey(String axName) {
        ConfigMeta meta = new ConfigMeta("c" + axName.toLowerCase(), axName + " Center");
        meta.setShortDescription("Central " + axName + " coordinate");
        meta.setXmlDescription(new String[]{"<p>Gives the central coordinate in the " + axName + " dimension.", "This will be determined from the data range if not supplied.", "</p>"});
        return DoubleConfigKey.createTextKey(meta);
    }

    public static class Profile {
        private final Scale xscale_;
        private final Scale yscale_;
        private final Scale zscale_;
        private final boolean xflip_;
        private final boolean yflip_;
        private final boolean zflip_;
        private final String xlabel_;
        private final String ylabel_;
        private final String zlabel_;
        private final boolean forceiso_;
        private final Captioner captioner_;
        private final boolean frame_;
        private final double xcrowd_;
        private final double ycrowd_;
        private final double zcrowd_;
        private final OrientationPolicy orientpolicy_;
        private final boolean minor_;
        private final boolean antialias_;

        public Profile(Scale xscale, Scale yscale, Scale zscale, boolean xflip, boolean yflip, boolean zflip, String xlabel, String ylabel, String zlabel, boolean forceiso, Captioner captioner, boolean frame, double xcrowd, double ycrowd, double zcrowd, OrientationPolicy orientpolicy, boolean minor, boolean antialias) {
            this.xscale_ = xscale;
            this.yscale_ = yscale;
            this.zscale_ = zscale;
            this.xflip_ = xflip;
            this.yflip_ = yflip;
            this.zflip_ = zflip;
            this.xlabel_ = xlabel;
            this.ylabel_ = ylabel;
            this.zlabel_ = zlabel;
            this.forceiso_ = forceiso;
            this.captioner_ = captioner;
            this.frame_ = frame;
            this.xcrowd_ = xcrowd;
            this.ycrowd_ = ycrowd;
            this.zcrowd_ = zcrowd;
            this.orientpolicy_ = orientpolicy;
            this.minor_ = minor;
            this.antialias_ = antialias;
        }

        public Scale[] getScales() {
            return new Scale[]{this.xscale_, this.yscale_, this.zscale_};
        }

        public boolean isForceIso() {
            return this.forceiso_;
        }
    }
}

