/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.util.GregorianCalendar;

abstract class DateTickLevel {
    private final long majorSec_;
    private final String prefixPattern_;
    private final String suffixPattern_;
    private final String name_;
    private static final int MINUTE_SECS = 60;
    private static final int HOUR_SECS = 3600;
    private static final int DAY_SECS = 86400;
    private static final int DAY_MILLIS = 86400000;

    protected DateTickLevel(String prefixPattern, String suffixPattern, long majorSec) {
        this.prefixPattern_ = prefixPattern;
        this.suffixPattern_ = suffixPattern;
        this.majorSec_ = majorSec;
        this.name_ = prefixPattern + "/" + suffixPattern;
    }

    public String getPrefixPattern() {
        return this.prefixPattern_;
    }

    public String getSuffixPattern() {
        return this.suffixPattern_;
    }

    public long getMajorTickSeconds() {
        return this.majorSec_;
    }

    public abstract long calendarFloorIndex(GregorianCalendar var1);

    public abstract void setCalendarToIndex(long var1, GregorianCalendar var3);

    public abstract long[] getMinorSecondOffsets(GregorianCalendar var1);

    static long floorDiv(long value, int divisor) {
        long q = value / (long)divisor;
        if (value >= 0L) {
            return q;
        }
        if (q * (long)divisor == value) {
            return q;
        }
        return q - 1L;
    }

    static int remainder(long value, int divisor) {
        long result;
        long remainder = value % (long)divisor;
        long l = result = remainder >= 0L ? remainder : remainder + (long)divisor;
        assert (result >= 0L && result < (long)divisor);
        return (int)result;
    }

    private static long[] getSecondOffsets(GregorianCalendar cal, int field, int[] values) {
        int noff = values.length;
        long[] secOffsets = new long[noff];
        long baseMillis = cal.getTimeInMillis();
        for (int i = 0; i < noff; ++i) {
            cal.set(field, values[i]);
            secOffsets[i] = (cal.getTimeInMillis() - baseMillis) / 1000L;
        }
        return secOffsets;
    }

    public static DateTickLevel[] createLevels(char dateSep) {
        String datePrefix = "yyyy-MM-dd'" + dateSep + "'";
        return new DateTickLevel[]{new DateTickLevel("", "yyyy", 31557600L){

            @Override
            public long calendarFloorIndex(GregorianCalendar cal) {
                return cal.get(1);
            }

            @Override
            public void setCalendarToIndex(long index, GregorianCalendar cal) {
                cal.clear();
                cal.set(1, (int)index);
            }

            @Override
            public long[] getMinorSecondOffsets(GregorianCalendar cal) {
                return DateTickLevel.getSecondOffsets(cal, 2, new int[]{3, 6, 9});
            }
        }, new DateTickLevel("yyyy-", "MM", 7884000L){

            @Override
            public long calendarFloorIndex(GregorianCalendar cal) {
                int year = cal.get(1);
                int quarter = cal.get(2) / 3;
                assert (quarter >= 0 && quarter < 4);
                return 4 * year + quarter;
            }

            @Override
            public void setCalendarToIndex(long index, GregorianCalendar cal) {
                int year = (int)2.floorDiv(index, 4);
                int quarter = 2.remainder(index, 4);
                cal.clear();
                cal.set(1, year);
                cal.set(2, quarter * 3);
            }

            @Override
            public long[] getMinorSecondOffsets(GregorianCalendar cal) {
                int month = cal.get(2);
                int[] monthOffs = new int[]{month + 1, month + 2};
                return DateTickLevel.getSecondOffsets(cal, 2, monthOffs);
            }
        }, new DateTickLevel("yyyy-", "MM", 2620800L){

            @Override
            public long calendarFloorIndex(GregorianCalendar cal) {
                int year = cal.get(1);
                int month = cal.get(2);
                assert (month >= 0 && month < 12);
                return 12 * year + month;
            }

            @Override
            public void setCalendarToIndex(long index, GregorianCalendar cal) {
                int year = (int)3.floorDiv(index, 12);
                int month = 3.remainder(index, 12);
                cal.clear();
                cal.set(1, year);
                cal.set(2, month);
            }

            @Override
            public long[] getMinorSecondOffsets(GregorianCalendar cal) {
                int[] nArray;
                boolean has28orLess;
                boolean bl = has28orLess = cal.getActualMaximum(5) < 29;
                if (cal.getActualMaximum(5) < 29) {
                    int[] nArray2 = new int[3];
                    nArray2[0] = 8;
                    nArray2[1] = 15;
                    nArray = nArray2;
                    nArray2[2] = 22;
                } else {
                    int[] nArray3 = new int[4];
                    nArray3[0] = 8;
                    nArray3[1] = 15;
                    nArray3[2] = 22;
                    nArray = nArray3;
                    nArray3[3] = 29;
                }
                int[] days = nArray;
                return DateTickLevel.getSecondOffsets(cal, 5, days);
            }
        }, new FixedMinorLevel("yyyy-", "MM-dd", 604800L, 86400){

            @Override
            public long calendarFloorIndex(GregorianCalendar cal) {
                long unixMillis = cal.getTimeInMillis();
                long unixDay = 4.floorDiv(unixMillis, 86400000);
                long unixWeek = 4.floorDiv(unixDay - 4L, 7);
                return unixWeek;
            }

            @Override
            public void setCalendarToIndex(long index, GregorianCalendar cal) {
                long unixDay = index * 7L + 4L;
                cal.clear();
                cal.setTimeInMillis(unixDay * 86400000L);
            }
        }, new RegularLevel("yyyy-", "MM-dd", 86400, 21600), new RegularLevel(datePrefix, "HH", 21600, 3600), new RegularLevel(datePrefix, "HH", 3600, 900), new RegularLevel(datePrefix, "HH:mm", 900, 300), new RegularLevel(datePrefix, "HH:mm", 300, 60), new RegularLevel(datePrefix, "HH:mm", 60, 15), new RegularLevel(datePrefix + "HH:mm:", "ss", 15, 5), new RegularLevel(datePrefix + "HH:mm:", "ss", 5, 1), new RegularLevel(datePrefix + "HH:mm:", "ss", 1, 0)};
    }

    private static class RegularLevel
    extends FixedMinorLevel {
        private final int majorMillis_;

        RegularLevel(String prefixPattern, String suffixPattern, int majorSec, int minorSec) {
            super(prefixPattern, suffixPattern, majorSec, minorSec);
            this.majorMillis_ = majorSec * 1000;
        }

        @Override
        public long calendarFloorIndex(GregorianCalendar cal) {
            return RegularLevel.floorDiv(cal.getTimeInMillis(), this.majorMillis_);
        }

        @Override
        public void setCalendarToIndex(long ix, GregorianCalendar cal) {
            cal.clear();
            cal.setTimeInMillis(ix * (long)this.majorMillis_);
        }
    }

    private static abstract class FixedMinorLevel
    extends DateTickLevel {
        private final long[] minors_;

        FixedMinorLevel(String prefixPattern, String suffixPattern, long majorSec, int minorSec) {
            super(prefixPattern, suffixPattern, majorSec);
            if (minorSec > 0) {
                int nminor = (int)(majorSec / (long)minorSec);
                this.minors_ = new long[nminor - 1];
                for (int i = 0; i < this.minors_.length; ++i) {
                    this.minors_[i] = (i + 1) * minorSec;
                }
            } else {
                this.minors_ = new long[0];
            }
        }

        @Override
        public long[] getMinorSecondOffsets(GregorianCalendar cal) {
            return (long[])this.minors_.clone();
        }
    }
}

