/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.geom.MatrixShape;

public enum MatrixFormat {
    LOWER(null, Boolean.TRUE, Boolean.FALSE, "only the lower diagonal part of the matrix is populated, as well as the diagonal if diagonal elements are present"),
    UPPER(null, Boolean.FALSE, Boolean.TRUE, "only the upper diagonal part of the matrix is populated, as well as the diagonal if diagonal elements are present"),
    FULL(null, Boolean.TRUE, Boolean.TRUE, "all cells of the matrix are populated where present");

    private final Boolean hasDiag_;
    private final Boolean hasLower_;
    private final Boolean hasUpper_;
    private final String description_;

    private MatrixFormat(Boolean hasDiag, Boolean hasLower, Boolean hasUpper, String description) {
        this.hasDiag_ = hasDiag;
        this.hasLower_ = hasLower;
        this.hasUpper_ = hasUpper;
        this.description_ = description;
    }

    public Boolean hasDiagonal() {
        return this.hasDiag_;
    }

    public Boolean hasLower() {
        return this.hasLower_;
    }

    public Boolean hasUpper() {
        return this.hasUpper_;
    }

    public String getDescription() {
        return this.description_;
    }

    public MatrixShape getShape(int nw, boolean hasOnDiag, boolean hasOffDiag) {
        boolean hasDiag = this.hasDiag_ == null ? hasOnDiag : this.hasDiag_;
        boolean hasLower = this.hasLower_ == null ? hasOffDiag : this.hasLower_;
        boolean hasUpper = this.hasUpper_ == null ? hasOffDiag : this.hasUpper_;
        boolean shapeDiag = hasDiag;
        boolean shapeLower = hasUpper;
        boolean shapeUpper = hasLower;
        return new MatrixShape(nw, shapeDiag, shapeLower, shapeUpper);
    }

    public static boolean isOnDiagonal(CoordGroup cgrp) {
        return cgrp != null && cgrp.isSinglePartialPosition();
    }

    public static boolean isOffDiagonal(CoordGroup cgrp) {
        return cgrp != null && cgrp.getBasicPositionCount() > 0;
    }
}

