/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.function.Supplier;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Gang;
import uk.ac.starlink.ttools.plot2.Ganger;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotPlacement;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ShadeAxis;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.Surround;
import uk.ac.starlink.ttools.plot2.Trimming;
import uk.ac.starlink.ttools.plot2.ZoneContent;
import uk.ac.starlink.ttools.plot2.geom.MatrixShape;
import uk.ac.starlink.ttools.plot2.geom.PlaneAspect;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.SideFlags;

public class MatrixGanger
implements Ganger<PlaneSurfaceFactory.Profile, PlaneAspect> {
    private final MatrixShape shape_;
    private final Padding padding_;
    private final boolean isSquares_;
    private final int cellGap_;
    private final int cxlo_;
    private final int cxhi_;
    private final int cylo_;
    private final int cyhi_;
    private static final int PAD = 2;
    public static final boolean XDIAG = true;
    private static final boolean YUP = false;

    public MatrixGanger(MatrixShape shape, Padding padding, boolean isSquares, int cellGap) {
        int nw;
        this.shape_ = shape;
        this.padding_ = padding;
        this.isSquares_ = isSquares;
        this.cellGap_ = cellGap;
        int cxmin = nw = shape.getWidth();
        int cxmax = -1;
        int cymin = nw;
        int cymax = -1;
        for (MatrixShape.Cell cell : this.shape_) {
            int x = cell.getX();
            int y = cell.getY();
            cxmin = Math.min(cxmin, x);
            cxmax = Math.max(cxmax, x);
            cymin = Math.min(cymin, y);
            cymax = Math.max(cymax, y);
        }
        this.cxlo_ = cxmin;
        this.cxhi_ = cxmax + 1;
        this.cylo_ = cymin;
        this.cyhi_ = cymax + 1;
    }

    public MatrixShape getShape() {
        return this.shape_;
    }

    @Override
    public int getZoneCount() {
        return this.shape_.getCellCount();
    }

    @Override
    public boolean isTrimmingGlobal() {
        return true;
    }

    @Override
    public boolean isShadingGlobal() {
        return true;
    }

    @Override
    public Gang createGang(Rectangle[] zonePlotBounds) {
        return new MatrixGang(zonePlotBounds);
    }

    @Override
    public Gang createApproxGang(Rectangle gangExtBox) {
        Insets insets = Padding.padInsets(this.padding_, new Insets(0, 0, 0, 0));
        return this.createGang(PlotUtil.subtractInsets(gangExtBox, insets));
    }

    @Override
    public Gang createGang(Rectangle gangExtBox, SurfaceFactory<PlaneSurfaceFactory.Profile, PlaneAspect> surfFact, ZoneContent<PlaneSurfaceFactory.Profile, PlaneAspect>[] zoneContents, Trimming[] trimmings, ShadeAxis[] shadeAxes, boolean withScroll) {
        ZoneContent<PlaneSurfaceFactory.Profile, PlaneAspect> zc0 = zoneContents.length > 0 ? zoneContents[0] : null;
        Supplier<Captioner> captSupplier = zc0 == null ? () -> null : () -> surfFact.createSurface(gangExtBox, (PlaneSurfaceFactory.Profile)zc0.getProfile(), (PlaneAspect)zc0.getAspect()).getCaptioner();
        Surround decSurround = PlotPlacement.calculateApproxDecorationSurround(gangExtBox, trimmings[0], shadeAxes[0], captSupplier);
        Rectangle decBox = PlotUtil.subtractInsets(gangExtBox, decSurround.toInsets());
        Surround axisSurround = this.calculateAxisSurround(decBox, surfFact, zoneContents);
        Insets axisInsets = withScroll ? axisSurround.toExtentInsets() : axisSurround.toInsets();
        Insets gangInsets = Padding.padInsets(this.padding_, axisInsets);
        return this.createGang(PlotUtil.subtractInsets(decBox, gangInsets));
    }

    public PlaneAspect[] adjustAspects(PlaneAspect[] aspects, int iz0) {
        int y0;
        int x0;
        PlaneAspect aspect0;
        assert (aspects.length == this.shape_.getCellCount());
        int nw = this.shape_.getWidth();
        int nz = this.shape_.getCellCount();
        Extent[] xextents = new Extent[nw];
        Extent[] yextents = new Extent[nw];
        if (iz0 >= 0) {
            aspect0 = aspects[iz0];
            MatrixShape.Cell cell0 = this.shape_.getCell(iz0);
            x0 = cell0.getX();
            y0 = cell0.getY();
        } else {
            aspect0 = null;
            x0 = -1;
            y0 = -1;
        }
        for (int i = 0; i < nw; ++i) {
            Extent yextent;
            Extent xextent;
            if (i == x0) {
                if (x0 == y0) {
                    // empty if block
                }
                yextent = xextent = MatrixGanger.getExtent(aspect0, false);
            } else if (i == y0 && x0 != y0) {
                xextent = yextent = MatrixGanger.getExtent(aspect0, true);
            } else {
                xextent = MatrixGanger.getExtent(this.getLineAspects(aspects, i, false), false);
                yextent = MatrixGanger.getExtent(this.getLineAspects(aspects, i, true), true);
            }
            xextents[i] = xextent;
            yextents[i] = yextent;
        }
        PlaneAspect[] newAspects = new PlaneAspect[nz];
        for (int iz = 0; iz < nz; ++iz) {
            double[] dArray;
            int iy;
            MatrixShape.Cell cell = this.shape_.getCell(iz);
            int ix = cell.getX();
            boolean isDiag = ix == (iy = cell.getY());
            PlaneAspect asp = aspects[iz];
            if (isDiag) {
                // empty if block
            }
            double[] xlimits = xextents[ix].getLimits();
            if (!isDiag) {
                dArray = yextents[iy].getLimits();
            } else {
                double[] dArray2 = new double[2];
                dArray2[0] = asp.getYMin();
                dArray = dArray2;
                dArray2[1] = asp.getYMax();
            }
            double[] ylimits = dArray;
            newAspects[iz] = new PlaneAspect(xlimits, ylimits);
        }
        return newAspects;
    }

    public PlaneSurfaceFactory.Profile[] adjustProfiles(PlaneSurfaceFactory.Profile[] profiles) {
        assert (profiles.length == this.shape_.getCellCount());
        int nz = this.shape_.getCellCount();
        int nw = this.shape_.getWidth();
        PlaneSurfaceFactory.Profile[] newProfiles = new PlaneSurfaceFactory.Profile[nz];
        boolean hasLower = this.shape_.hasLower();
        boolean hasUpper = this.shape_.hasUpper();
        boolean hasDiag = this.shape_.hasDiagonal();
        for (int iz = 0; iz < nz; ++iz) {
            boolean bl;
            boolean top;
            boolean bl2;
            boolean right;
            boolean left;
            MatrixShape.Cell cell = this.shape_.getCell(iz);
            int ix = cell.getX();
            int iy = cell.getY();
            boolean bl3 = (hasUpper || hasDiag && !hasLower) && ix == this.cxlo_ && ix != iy ? true : (left = false);
            boolean bl4 = hasLower && !hasUpper && ix == this.cxhi_ - 1 && ix != iy ? true : (right = false);
            if (hasLower && !hasUpper && iy == this.cylo_) {
                if (ix == iy) {
                    // empty if block
                }
                bl2 = true;
            } else {
                bl2 = top = false;
            }
            if ((hasUpper || hasDiag && !hasLower) && iy == this.cyhi_ - 1) {
                if (ix == iy) {
                    // empty if block
                }
                bl = true;
            } else {
                bl = false;
            }
            boolean bottom = bl;
            PlaneSurfaceFactory.Profile profile = profiles[iz];
            SideFlags annotateFlags = new SideFlags(bottom, left, top, right);
            boolean addSecondary = right || top;
            newProfiles[iz] = profiles[iz].fixAnnotation(annotateFlags, addSecondary);
        }
        return newProfiles;
    }

    private Surround calculateAxisSurround(Rectangle gangExtBox, SurfaceFactory<PlaneSurfaceFactory.Profile, PlaneAspect> surfFact, ZoneContent<PlaneSurfaceFactory.Profile, PlaneAspect>[] zoneContents) {
        Surround surround = Surround.fromInsets(new Insets(2, 2, 2, 2));
        int nz = this.shape_.getCellCount();
        int cw0 = gangExtBox.width / (this.cxhi_ - this.cxlo_);
        int ch0 = gangExtBox.height / (this.cyhi_ - this.cylo_);
        boolean zoneWithScroll = false;
        Padding zonePadding = null;
        for (int iz = 0; iz < nz; ++iz) {
            ZoneContent<PlaneSurfaceFactory.Profile, PlaneAspect> content = zoneContents[iz];
            Rectangle zoneExtBox = new Rectangle(0, 0, cw0, ch0);
            Surround zoneSurround = PlotPlacement.createPlacement(zoneExtBox, zonePadding, surfFact, content.getProfile(), content.getAspect(), zoneWithScroll, null, null).getSurface().getSurround(zoneWithScroll);
            surround = surround.union(zoneSurround);
        }
        return surround;
    }

    private MatrixGang createGang(Rectangle gangInBox) {
        int ncx = this.cxhi_ - this.cxlo_;
        int ncy = this.cyhi_ - this.cylo_;
        int cw = (gangInBox.width + this.cellGap_) / ncx;
        int ch = (gangInBox.height + this.cellGap_) / ncy;
        int xoff = gangInBox.x;
        int yoff = gangInBox.y;
        if (this.isSquares_) {
            int c;
            cw = c = Math.min(cw, ch);
            ch = c;
            xoff += (gangInBox.width - (ncx * cw - this.cellGap_)) / 2;
            yoff += (gangInBox.height - (ncy * ch - this.cellGap_)) / 2;
        }
        int ncell = this.shape_.getCellCount();
        Rectangle[] boxes = new Rectangle[ncell];
        for (int icell = 0; icell < ncell; ++icell) {
            MatrixShape.Cell cell = this.shape_.getCell(icell);
            int ix = cell.getX() - this.cxlo_;
            int iy = cell.getY() - this.cylo_;
            int rx = xoff + ix * cw;
            int ry = yoff + iy * ch;
            int rw = cw - this.cellGap_;
            int rh = ch - this.cellGap_;
            boxes[icell] = new Rectangle(rx, ry, rw, rh);
        }
        return new MatrixGang(boxes);
    }

    private PlaneAspect[] getLineAspects(PlaneAspect[] aspects, int iw, boolean isY) {
        int nz = this.shape_.getCellCount();
        ArrayList<PlaneAspect> lineAspects = new ArrayList<PlaneAspect>();
        for (int iz = 0; iz < nz; ++iz) {
            MatrixShape.Cell cell = this.shape_.getCell(iz);
            int x = cell.getX();
            int y = cell.getY();
            if (iw != (isY ? y : x) || x == y && isY) continue;
            lineAspects.add(aspects[iz]);
        }
        return lineAspects.toArray(new PlaneAspect[0]);
    }

    private static Extent getExtent(PlaneAspect aspect, boolean isY) {
        return isY ? new Extent(aspect.getYMin(), aspect.getYMax()) : new Extent(aspect.getXMin(), aspect.getXMax());
    }

    private static Extent getExtent(PlaneAspect[] aspects, boolean isY) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (PlaneAspect aspect : aspects) {
            min = Math.min(min, isY ? aspect.getYMin() : aspect.getXMin());
            max = Math.max(max, isY ? aspect.getYMax() : aspect.getXMax());
        }
        return new Extent(min, max);
    }

    private static int getDistanceOutside(Rectangle box, Point pos) {
        boolean inY;
        int dx1 = pos.x - box.x;
        int dx2 = pos.x - box.x - box.width;
        int dy1 = pos.y - box.y;
        int dy2 = pos.y - box.y - box.height;
        boolean inX = dx1 * dx2 <= 0;
        boolean bl = inY = dy1 * dy2 <= 0;
        if (inX && inY) {
            return 0;
        }
        if (inX) {
            return Math.min(Math.abs(dy1), Math.abs(dy2));
        }
        if (inY) {
            return Math.min(Math.abs(dx1), Math.abs(dx2));
        }
        return -1;
    }

    private static class Extent {
        final double min_;
        final double max_;

        Extent(double min, double max) {
            this.min_ = min;
            this.max_ = max;
        }

        double[] getLimits() {
            return new double[]{this.min_, this.max_};
        }
    }

    private static class MatrixGang
    implements Gang {
        private final Rectangle[] cellBoxes_;

        MatrixGang(Rectangle[] cellBoxes) {
            this.cellBoxes_ = cellBoxes;
        }

        @Override
        public int getZoneCount() {
            return this.cellBoxes_.length;
        }

        @Override
        public Rectangle getZonePlotBounds(int iz) {
            return new Rectangle(this.cellBoxes_[iz]);
        }

        @Override
        public int getNavigationZoneIndex(Point pos) {
            int minDist = 10000;
            int ibest = -1;
            for (int i = 0; i < this.cellBoxes_.length; ++i) {
                int dist = MatrixGanger.getDistanceOutside(this.cellBoxes_[i], pos);
                if (dist == 0) {
                    return i;
                }
                if (dist <= 0 || dist >= minDist) continue;
                minDist = dist;
                ibest = i;
            }
            return ibest;
        }
    }
}

