/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.ac.starlink.ttools.plot2.Equality;

@Equality
public class MatrixShape
implements Iterable<Cell> {
    private final int nx_;
    private final boolean hasDiagonal_;
    private final boolean hasLower_;
    private final boolean hasUpper_;
    private final Mapper mapper_;

    public MatrixShape(int nx, boolean hasDiagonal, boolean hasLower, boolean hasUpper) {
        this.nx_ = nx;
        this.hasDiagonal_ = hasDiagonal;
        this.hasLower_ = hasLower;
        this.hasUpper_ = hasUpper;
        this.mapper_ = MatrixShape.createMapper(this);
    }

    public MatrixShape(int nx) {
        this(nx, true, true, true);
    }

    public int getWidth() {
        return this.nx_;
    }

    public boolean hasDiagonal() {
        return this.hasDiagonal_;
    }

    public boolean hasLower() {
        return this.hasLower_;
    }

    public boolean hasUpper() {
        return this.hasUpper_;
    }

    public int getCellCount() {
        return this.mapper_.ncell_;
    }

    public int getIndex(int ix, int iy) {
        return ix >= 0 && ix < this.nx_ && iy >= 0 && iy < this.nx_ ? this.mapper_.getIndex(ix, iy) : -1;
    }

    public int getIndex(Cell cell) {
        return this.getIndex(cell.getX(), cell.getY());
    }

    public Cell getCell(int icell) {
        return icell >= 0 && icell < this.mapper_.ncell_ ? this.mapper_.getCell(icell) : null;
    }

    @Override
    public Iterator<Cell> iterator() {
        return new Iterator<Cell>(){
            int ic = 0;

            @Override
            public boolean hasNext() {
                return this.ic < ((MatrixShape)MatrixShape.this).mapper_.ncell_;
            }

            @Override
            public Cell next() {
                if (this.ic < ((MatrixShape)MatrixShape.this).mapper_.ncell_) {
                    return MatrixShape.this.mapper_.getCell(this.ic++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return new StringBuffer(6).append(this.nx_).append('(').append(this.hasDiagonal_ ? (char)'D' : '.').append(this.hasLower_ ? (char)'L' : '.').append(this.hasUpper_ ? (char)'U' : '.').append(')').toString();
    }

    public int hashCode() {
        int code = 221512;
        code = 23 * code + this.nx_;
        code = 23 * code + (this.hasDiagonal_ ? 0 : 2);
        code = 23 * code + (this.hasUpper_ ? 0 : 4);
        code = 23 * code + (this.hasLower_ ? 0 : 8);
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof MatrixShape) {
            MatrixShape other = (MatrixShape)o;
            return this.nx_ == other.nx_ && this.hasDiagonal_ == other.hasDiagonal_ && this.hasUpper_ == other.hasUpper_ && this.hasLower_ == other.hasLower_;
        }
        return false;
    }

    private static Mapper createMapper(MatrixShape shape) {
        final int nx = shape.nx_;
        final boolean hasDiagonal = shape.hasDiagonal_;
        final boolean hasLower = shape.hasLower_;
        boolean hasUpper = shape.hasUpper_;
        if (hasUpper && hasLower) {
            if (hasDiagonal) {
                return new Mapper(nx * nx){

                    @Override
                    int getIndex(int ix, int iy) {
                        return ix + nx * iy;
                    }

                    @Override
                    Cell getCell(int icell) {
                        return new Cell(icell % nx, icell / nx);
                    }
                };
            }
            final int nx1 = nx - 1;
            return new Mapper(nx * nx1){

                @Override
                int getIndex(int ix, int iy) {
                    return ix != iy ? ix + (ix > iy ? -1 : 0) + nx1 * iy : -1;
                }

                @Override
                Cell getCell(int icell) {
                    int jx;
                    int iy = icell / nx1;
                    return new Cell(jx + ((jx = icell % nx1) >= iy ? 1 : 0), iy);
                }
            };
        }
        if (!hasUpper && !hasLower) {
            if (hasDiagonal) {
                return new Mapper(nx){

                    @Override
                    int getIndex(int ix, int iy) {
                        return ix == iy ? ix : -1;
                    }

                    @Override
                    Cell getCell(int icell) {
                        return new Cell(icell, icell);
                    }
                };
            }
            return new Mapper(0){

                @Override
                int getIndex(int ix, int iy) {
                    return -1;
                }

                @Override
                Cell getCell(int icell) {
                    return null;
                }
            };
        }
        assert (hasUpper != hasLower);
        int nx1 = nx - 1;
        final int nt = nx * nx1 / 2;
        return new Mapper(nt + (hasDiagonal ? nx : 0)){

            @Override
            int getIndex(int ix, int iy) {
                int iq;
                int ip = hasLower ? ix : iy;
                int n = iq = hasLower ? iy : ix;
                if (ip > iq) {
                    return ip * (ip - 1) / 2 + iq;
                }
                if (hasDiagonal && ix == iy) {
                    return nt + ix;
                }
                return -1;
            }

            @Override
            Cell getCell(int icell) {
                if (icell < nt) {
                    int iq = (int)((-1.0 + Math.sqrt(8 * icell + 1)) / 2.0);
                    int ip = icell - iq * (iq + 1) / 2;
                    return hasLower ? new Cell(iq + 1, ip) : new Cell(ip, iq + 1);
                }
                if (hasDiagonal) {
                    int id = icell - nt;
                    return id >= 0 && id < nx ? new Cell(id, id) : null;
                }
                return null;
            }
        };
    }

    private static abstract class Mapper {
        final int ncell_;

        Mapper(int ncell) {
            this.ncell_ = ncell;
        }

        abstract int getIndex(int var1, int var2);

        abstract Cell getCell(int var1);
    }

    @Equality
    public static class Cell {
        private final int ix_;
        private final int iy_;

        public Cell(int ix, int iy) {
            this.ix_ = ix;
            this.iy_ = iy;
        }

        public int getX() {
            return this.ix_;
        }

        public int getY() {
            return this.iy_;
        }

        public String toString() {
            return this.ix_ + "," + this.iy_;
        }

        public int hashCode() {
            return this.ix_ | this.iy_ << 16;
        }

        public boolean equals(Object o) {
            if (o instanceof Cell) {
                Cell other = (Cell)o;
                return this.ix_ == other.ix_ && this.iy_ == other.iy_;
            }
            return false;
        }
    }
}

