/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import uk.ac.starlink.ttools.plot2.CoordSequence;
import uk.ac.starlink.ttools.plot2.Decoration;
import uk.ac.starlink.ttools.plot2.Gesture;
import uk.ac.starlink.ttools.plot2.NavAction;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.geom.BandDecoration;
import uk.ac.starlink.ttools.plot2.geom.NavDecorations;
import uk.ac.starlink.ttools.plot2.geom.PlaneAspect;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurface;

public class PlaneNavigator
implements Navigator<PlaneAspect> {
    private final double zoomFactor_;
    private final boolean xZoom_;
    private final boolean yZoom_;
    private final boolean xPan_;
    private final boolean yPan_;
    private final double xAnchor_;
    private final double yAnchor_;

    public PlaneNavigator(double zoomFactor, boolean xZoom, boolean yZoom, boolean xPan, boolean yPan, double xAnchor, double yAnchor) {
        this.zoomFactor_ = zoomFactor;
        this.xZoom_ = xZoom;
        this.yZoom_ = yZoom;
        this.xPan_ = xPan;
        this.yPan_ = yPan;
        this.xAnchor_ = xAnchor;
        this.yAnchor_ = yAnchor;
    }

    @Override
    public NavAction<PlaneAspect> drag(Surface surface, Point point, int ibutt, Point origin) {
        boolean[] useFlags = PlaneNavigator.getAxisNavFlags(surface, origin, this.xPan_, this.yPan_);
        PlaneSurface psurf = (PlaneSurface)surface;
        boolean xUse = useFlags[0];
        boolean yUse = useFlags[1];
        Rectangle plotBounds = surface.getPlotBounds();
        if (ibutt == 3) {
            int[] offs = this.getAnchorOffsets(psurf, origin);
            Point g0 = new Point(origin.x + offs[0], origin.y + offs[1]);
            Point gp = new Point(point.x + offs[0], point.y + offs[1]);
            double xf = useFlags[0] ? PlotUtil.toZoom(this.zoomFactor_, g0, gp, false) : 1.0;
            double yf = useFlags[1] ? PlotUtil.toZoom(this.zoomFactor_, g0, gp, true) : 1.0;
            PlaneAspect aspect = psurf.zoom(g0, xf, yf);
            Decoration dec = NavDecorations.createDragDecoration(g0, xf, yf, xUse, yUse, plotBounds);
            return new NavAction<PlaneAspect>(aspect, dec);
        }
        if (ibutt == 2) {
            BandDecoration dec = NavDecorations.createBandDecoration(origin, point, xUse, yUse, plotBounds);
            return new NavAction<Object>(null, dec);
        }
        PlaneAspect aspect = psurf.pan(origin, point, xUse, yUse);
        return new NavAction<PlaneAspect>(aspect, null);
    }

    @Override
    public NavAction<PlaneAspect> endDrag(Surface surface, Point pos, int ibutt, Point origin) {
        if (ibutt == 2) {
            boolean[] useFlags = PlaneNavigator.getAxisNavFlags(surface, origin, this.xPan_, this.yPan_);
            PlaneSurface psurf = (PlaneSurface)surface;
            boolean xUse = useFlags[0];
            boolean yUse = useFlags[1];
            Rectangle bounds = surface.getPlotBounds();
            BandDecoration dec = NavDecorations.createBandDecoration(origin, pos, xUse, yUse, bounds);
            if (dec != null) {
                PlaneAspect aspect = psurf.reframe(dec.getTargetRectangle());
                return new NavAction<PlaneAspect>(aspect, null);
            }
            return null;
        }
        return null;
    }

    @Override
    public NavAction<PlaneAspect> wheel(Surface surface, Point pos, int wheelrot) {
        PlaneSurface psurf = (PlaneSurface)surface;
        boolean[] useFlags = PlaneNavigator.getAxisNavFlags(surface, pos, this.xZoom_, this.yZoom_);
        double zfact = PlotUtil.toZoom(this.zoomFactor_, wheelrot);
        double xf = useFlags[0] ? zfact : 1.0;
        double yf = useFlags[1] ? zfact : 1.0;
        int[] offs = this.getAnchorOffsets(psurf, pos);
        Point gp = new Point(pos.x + offs[0], pos.y + offs[1]);
        PlaneAspect aspect = psurf.zoom(gp, xf, yf);
        Decoration dec = NavDecorations.createWheelDecoration(gp, xf, yf, useFlags[0], useFlags[1], surface.getPlotBounds());
        return new NavAction<PlaneAspect>(aspect, dec);
    }

    @Override
    public NavAction<PlaneAspect> click(Surface surface, Point pos, int ibutt, Supplier<CoordSequence> dposSup) {
        return null;
    }

    @Override
    public Map<Gesture, String> getNavOptions(Surface surface, Point pos) {
        String isoTxt;
        String freeTxt;
        boolean[] useFlags = PlaneNavigator.getAxisNavFlags(surface, pos, this.xPan_, this.yPan_);
        boolean xUse = useFlags[0];
        boolean yUse = useFlags[1];
        if (xUse && yUse) {
            freeTxt = "X/Y";
            isoTxt = "Iso";
        } else {
            freeTxt = xUse ? "X " : (yUse ? "Y  " : "   ");
            isoTxt = freeTxt;
        }
        LinkedHashMap<Gesture, String> map = new LinkedHashMap<Gesture, String>();
        map.put(Gesture.DRAG_1, "Pan " + freeTxt);
        map.put(Gesture.DRAG_3, "Stretch " + freeTxt);
        map.put(Gesture.DRAG_2, "Frame " + freeTxt);
        map.put(Gesture.WHEEL, "Zoom " + isoTxt);
        return map;
    }

    private int[] getAnchorOffsets(PlaneSurface surface, Point refpos) {
        double[] d0 = surface.graphicsToData(surface.getPlotBounds().getLocation(), null);
        Point2D.Double pc = new Point2D.Double();
        Scale[] scales = surface.getScales();
        int xoff = !Double.isNaN(this.xAnchor_) && (this.xAnchor_ > 0.0 || !scales[0].isPositiveDefinite()) && surface.dataToGraphics(new double[]{this.xAnchor_, d0[1]}, false, pc) && PlotUtil.isPointFinite(pc) ? (int)Math.round(pc.x - (double)refpos.x) : 0;
        int yoff = !Double.isNaN(this.yAnchor_) && (this.yAnchor_ > 0.0 || !scales[1].isPositiveDefinite()) && surface.dataToGraphics(new double[]{d0[0], this.yAnchor_}, false, pc) && PlotUtil.isPointFinite(pc) ? (int)Math.round(pc.y - (double)refpos.y) : 0;
        return new int[]{xoff, yoff};
    }

    public static boolean[] getAxisNavFlags(Surface surface, Point pos, boolean xFlag, boolean yFlag) {
        boolean inY;
        Rectangle bounds = surface.getPlotBounds();
        boolean inX = pos.x >= bounds.x && pos.x <= bounds.x + bounds.width;
        boolean bl = inY = pos.y >= bounds.y && pos.y <= bounds.y + bounds.height;
        if (inX && inY) {
            return new boolean[]{xFlag, yFlag};
        }
        if (inX && !inY) {
            return new boolean[]{true, false};
        }
        if (inY && !inX) {
            return new boolean[]{false, true};
        }
        return new boolean[]{false, false};
    }
}

