/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.util.Arrays;
import uk.ac.starlink.ttools.plot.Matrices;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.geom.SkySys;

@Equality
public abstract class Rotation {
    public static Rotation IDENTITY = new Rotation(){

        @Override
        public void rotate(double[] r3) {
        }

        @Override
        public Rotation invert() {
            return this;
        }

        @Override
        public double[] getMatrix() {
            return new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
        }
    };

    protected Rotation() {
    }

    public abstract void rotate(double[] var1);

    public abstract Rotation invert();

    public abstract double[] getMatrix();

    public static boolean isIdentityRotation(SkySys inSys, SkySys outSys) {
        return inSys == null || outSys == null || inSys.equals(outSys);
    }

    public static Rotation createRotation(SkySys inSys, SkySys outSys) {
        if (Rotation.isIdentityRotation(inSys, outSys)) {
            return IDENTITY;
        }
        double[] rotmat = Matrices.mmMult(Matrices.invert(outSys.toEquatorial()), inSys.toEquatorial());
        return new MatrixRotation(rotmat);
    }

    private static class MatrixRotation
    extends Rotation {
        private final double[] rotmat_;
        private final double r0_;
        private final double r1_;
        private final double r2_;
        private final double r3_;
        private final double r4_;
        private final double r5_;
        private final double r6_;
        private final double r7_;
        private final double r8_;

        MatrixRotation(double[] rotmat) {
            this.r0_ = rotmat[0];
            this.r1_ = rotmat[1];
            this.r2_ = rotmat[2];
            this.r3_ = rotmat[3];
            this.r4_ = rotmat[4];
            this.r5_ = rotmat[5];
            this.r6_ = rotmat[6];
            this.r7_ = rotmat[7];
            this.r8_ = rotmat[8];
            this.rotmat_ = new double[]{this.r0_, this.r1_, this.r2_, this.r3_, this.r4_, this.r5_, this.r6_, this.r7_, this.r8_};
        }

        @Override
        public void rotate(double[] dpos) {
            double dx = dpos[0];
            double dy = dpos[1];
            double dz = dpos[2];
            dpos[0] = this.r0_ * dx + this.r1_ * dy + this.r2_ * dz;
            dpos[1] = this.r3_ * dx + this.r4_ * dy + this.r5_ * dz;
            dpos[2] = this.r6_ * dx + this.r7_ * dy + this.r8_ * dz;
        }

        @Override
        public Rotation invert() {
            return new MatrixRotation(Matrices.invert(this.rotmat_));
        }

        @Override
        public double[] getMatrix() {
            return (double[])this.rotmat_.clone();
        }

        public int hashCode() {
            int code = 55442;
            code = 23 * code + Arrays.hashCode(this.rotmat_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof MatrixRotation) {
                MatrixRotation other = (MatrixRotation)o;
                return Arrays.equals(this.rotmat_, other.rotmat_);
            }
            return false;
        }
    }
}

