/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;

public final class Sin2
extends Projecter {
    public String getName() {
        return "Sin2";
    }

    public String getDescription() {
        return "Project as if seeing the sphere from a great distance";
    }

    public Deprojecter inverse() {
        return new Sin2Deproj();
    }

    public boolean isInverse(Transformer t) {
        return t.getName().equals("Sin2Deproj");
    }

    public final void transform(double[] sphere, double[] plane) {
        if (Double.isNaN(sphere[0]) || sphere[0] <= 0.0) {
            plane[0] = Double.NaN;
            plane[1] = Double.NaN;
        } else {
            plane[0] = sphere[1];
            plane[1] = sphere[2];
        }
    }

    public boolean validPosition(double[] plane) {
        return super.validPosition(plane) && plane[0] * plane[0] + plane[1] * plane[1] <= 1.0;
    }

    public class Sin2Deproj
    extends Deprojecter {
        public String getName() {
            return "Sin2Deproj";
        }

        public String getDescription() {
            return "Invert the sine projection";
        }

        public Projecter inverse() {
            return Sin2.this;
        }

        public boolean isInverse(Transformer t) {
            return t.getName().equals("Sin2");
        }

        public final void transform(double[] plane, double[] sphere) {
            if (!Sin2.this.validPosition(plane)) {
                sphere[0] = Double.NaN;
                sphere[1] = Double.NaN;
                sphere[2] = Double.NaN;
            } else {
                sphere[1] = plane[0];
                sphere[2] = plane[1];
                sphere[0] = Math.sqrt(1.0 - plane[0] * plane[0] - plane[1] * plane[1]);
            }
        }
    }
}

