/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import uk.ac.starlink.ttools.plot2.Caption;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Surround;
import uk.ac.starlink.ttools.plot2.geom.AxisAnnotation;
import uk.ac.starlink.ttools.plot2.geom.GridLiner;
import uk.ac.starlink.ttools.plot2.geom.SkyAxisLabeller;
import uk.ac.starlink.ttools.plot2.geom.SkySys;
import uk.ac.starlink.ttools.plot2.geom.TickSkyAxisLabeller;

public class SkyAxisLabellers {
    public static final SkyAxisLabeller NONE = new SkyAxisLabeller(){

        @Override
        public String getLabellerName() {
            return "None";
        }

        @Override
        public String getLabellerDescription() {
            return "Axes are not labelled";
        }

        @Override
        public AxisAnnotation createAxisAnnotation(GridLiner gridLiner, Captioner captioner, SkySys skySys) {
            return new AxisAnnotation(){

                @Override
                public Surround getSurround(boolean withScroll) {
                    return new Surround();
                }

                @Override
                public void drawLabels(Graphics g) {
                }
            };
        }
    };
    public static final SkyAxisLabeller LAME = new SkyAxisLabeller(){

        @Override
        public String getLabellerName() {
            return "Basic";
        }

        @Override
        public String getLabellerDescription() {
            return "Labels are drawn somewhere near the grid line";
        }

        @Override
        public AxisAnnotation createAxisAnnotation(final GridLiner gridLiner, final Captioner captioner, SkySys skySys) {
            return new AxisAnnotation(){

                @Override
                public Surround getSurround(boolean withScroll) {
                    return new Surround();
                }

                @Override
                public void drawLabels(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    double[][][] lines = gridLiner.getLines();
                    String[] labels = gridLiner.getLabels();
                    int nl = labels.length;
                    for (int il = 0; il < nl; ++il) {
                        double[][] line = lines[il];
                        String label = labels[il];
                        double[] seg0 = line[0];
                        double[] segN = line[line.length - 1];
                        double px = seg0[0];
                        double py = seg0[1];
                        g2.translate(px, py);
                        captioner.drawCaption(SkyAxisLabellers.labelCaption(label), g2);
                        g2.translate(-px, -py);
                    }
                }
            };
        }
    };
    public static final SkyAxisLabeller EXTERNAL = SkyAxisLabellers.createExternalLabeller("External", "Labels are drawn outside the plot bounds", false);
    public static final SkyAxisLabeller INTERNAL = SkyAxisLabellers.createInternalLabeller("Internal", "Labels are drawn inside the plot bounds", false);
    public static final SkyAxisLabeller EXTSYS = SkyAxisLabellers.createExternalLabeller("ExternalSys", "Like <code>" + EXTERNAL.getLabellerName() + "</code>, but the axes are also labelled with coordinate system axis names", true);
    public static final SkyAxisLabeller INTSYS = SkyAxisLabellers.createInternalLabeller("InternalSys", "Like <code>" + INTERNAL.getLabellerName() + "</code>, but the axes are also labelled with coordinate system axis names", true);
    public static final SkyAxisLabeller HYBRID = new TickSkyAxisLabeller("Hybrid", "Grid lines are labelled outside the plot bounds where possible, but inside if they would otherwise be invisible", false){

        @Override
        protected TickSkyAxisLabeller.SkyTick[] calculateTicks(double[][][] lines, Caption[] labels, Rectangle plotBounds) {
            ArrayList<TickSkyAxisLabeller.SkyTick> tickList = new ArrayList<TickSkyAxisLabeller.SkyTick>();
            int nl = labels.length;
            for (int il = 0; il < nl; ++il) {
                Caption label = labels[il];
                double[][] line = lines[il];
                TickSkyAxisLabeller.SkyTick tick = 3.createExternalTick(label, line, plotBounds);
                if (tick == null) {
                    tick = 3.createInternalTick(label, line);
                }
                if (tick == null) continue;
                tickList.add(tick);
            }
            return tickList.toArray(new TickSkyAxisLabeller.SkyTick[0]);
        }
    };

    private SkyAxisLabellers() {
    }

    public static Caption labelCaption(String label) {
        return Caption.createCaption(label, txt -> txt.replaceAll("([hms])", "^{\\\\text{$1}}"));
    }

    public static SkyAxisLabeller[] getKnownLabellers() {
        return new SkyAxisLabeller[]{null, EXTERNAL, INTERNAL, LAME, HYBRID, NONE, EXTSYS, INTSYS};
    }

    public static SkyAxisLabeller getAutoLabeller(boolean skyFillsBounds) {
        return skyFillsBounds ? EXTERNAL : INTERNAL;
    }

    private static SkyAxisLabeller createExternalLabeller(String name, String description, boolean labelSys) {
        return new TickSkyAxisLabeller(name, description, labelSys){

            @Override
            protected TickSkyAxisLabeller.SkyTick[] calculateTicks(double[][][] lines, Caption[] labels, Rectangle plotBounds) {
                ArrayList<TickSkyAxisLabeller.SkyTick> tickList = new ArrayList<TickSkyAxisLabeller.SkyTick>();
                int nl = labels.length;
                for (int il = 0; il < nl; ++il) {
                    TickSkyAxisLabeller.SkyTick tick = 4.createExternalTick(labels[il], lines[il], plotBounds);
                    if (tick == null) continue;
                    tickList.add(tick);
                }
                return tickList.toArray(new TickSkyAxisLabeller.SkyTick[0]);
            }
        };
    }

    private static SkyAxisLabeller createInternalLabeller(String name, String description, boolean labelSys) {
        return new TickSkyAxisLabeller(name, description, labelSys){

            @Override
            protected TickSkyAxisLabeller.SkyTick[] calculateTicks(double[][][] lines, Caption[] labels, Rectangle plotBounds) {
                ArrayList<TickSkyAxisLabeller.SkyTick> tickList = new ArrayList<TickSkyAxisLabeller.SkyTick>();
                int nl = labels.length;
                for (int il = 0; il < nl; ++il) {
                    TickSkyAxisLabeller.SkyTick tick = 5.createInternalTick(labels[il], lines[il]);
                    if (tick == null) continue;
                    tickList.add(tick);
                }
                return tickList.toArray(new TickSkyAxisLabeller.SkyTick[0]);
            }
        };
    }
}

