/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.Tuple;

public class TimeDataGeom
implements DataGeom {
    public static final FloatingCoord T_COORD = FloatingCoord.createTimeCoord(new InputMeta("t", "Time").setShortDescription("Time coordinate").setValueUsage("time"), true);
    public static final FloatingCoord Y_COORD = FloatingCoord.createCoord(new InputMeta("y", "Y").setShortDescription("Vertical coordinate"), true);
    public static TimeDataGeom INSTANCE = new TimeDataGeom();

    private TimeDataGeom() {
    }

    @Override
    public int getDataDimCount() {
        return 2;
    }

    @Override
    public String getVariantName() {
        return "Time";
    }

    @Override
    public Coord[] getPosCoords() {
        return new Coord[]{T_COORD, Y_COORD};
    }

    @Override
    public boolean readDataPos(Tuple tuple, int ic, double[] dpos) {
        double t = T_COORD.readDoubleCoord(tuple, ic++);
        double y = Y_COORD.readDoubleCoord(tuple, ic++);
        if (Double.isNaN(t) || Double.isNaN(y)) {
            return false;
        }
        dpos[0] = t;
        dpos[1] = y;
        return true;
    }
}

