/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.layer.ColorKit;

public class AuxColorKit
implements ColorKit {
    private final int icShade_;
    private final Shader shader_;
    private final Scaler scaler_;
    private final Color scaledNullColor_;
    private final float scaleAlpha_;
    private final float[] baseRgba_;
    private final float[] rgba_;
    private Color lastColor_;
    private float lastScale_;

    public AuxColorKit(int icShade, Shader shader, Scaler scaler, Color baseColor, Color nullColor, float scaleAlpha) {
        this.icShade_ = icShade;
        this.shader_ = shader;
        this.scaler_ = scaler;
        this.scaleAlpha_ = scaleAlpha;
        this.scaledNullColor_ = nullColor == null ? null : this.toOutputColor(nullColor.getRGBComponents(null));
        this.baseRgba_ = baseColor.getRGBComponents(null);
        this.rgba_ = new float[4];
        this.lastColor_ = this.scaledNullColor_;
        this.lastScale_ = Float.NaN;
    }

    @Override
    public Color readColor(Tuple tuple) {
        double auxVal = tuple.getDoubleValue(this.icShade_);
        float scaleVal = (float)this.scaler_.scaleValue(auxVal);
        if (Float.isNaN(scaleVal)) {
            return this.scaledNullColor_;
        }
        if (this.lastScale_ == scaleVal) {
            return this.lastColor_;
        }
        System.arraycopy(this.baseRgba_, 0, this.rgba_, 0, 4);
        this.shader_.adjustRgba(this.rgba_, scaleVal);
        Color color = this.toOutputColor(this.rgba_);
        this.lastScale_ = scaleVal;
        this.lastColor_ = color;
        return color;
    }

    private Color toOutputColor(float[] rgba) {
        float alpha = rgba[3];
        return alpha > 0.0f ? new Color(rgba[0], rgba[1], rgba[2], alpha * this.scaleAlpha_) : null;
    }
}

