/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.layer.BinMapper;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.Cumulation;
import uk.ac.starlink.ttools.plot2.layer.Normalisation;
import uk.ac.starlink.ttools.plot2.layer.Unit;

public class BinBag {
    private final Scale scale_;
    private final double binWidth_;
    private final double binPhase_;
    private final Combiner combiner_;
    private final BinMapper mapper_;
    private final Map<Integer, Combiner.Container> valueMap_;

    public BinBag(Scale scale, double binWidth, double binPhase, Combiner combiner, double point) {
        this.scale_ = scale;
        this.binWidth_ = binWidth;
        this.binPhase_ = binPhase;
        this.combiner_ = combiner;
        this.mapper_ = new BinMapper(scale, binWidth, binPhase, point);
        this.valueMap_ = new HashMap<Integer, Combiner.Container>();
    }

    public void submitToBin(double point, double datum) {
        if (!(Double.isNaN(point) || Double.isInfinite(point) || this.scale_.isPositiveDefinite() && !(point > 0.0))) {
            int ix = this.mapper_.getBinIndex(point);
            Combiner.Container val = this.valueMap_.get(ix);
            if (val == null) {
                val = this.combiner_.createContainer();
                this.valueMap_.put(ix, val);
            }
            val.submit(datum);
        }
    }

    public Iterator<Bin> binIterator(Cumulation cumul, Normalisation norm, Unit unit) {
        return this.binIterator(cumul, norm, unit, null);
    }

    public Iterator<Bin> binIterator(final Cumulation cumul, Normalisation norm, Unit unit, double[] range) {
        if (this.valueMap_.isEmpty()) {
            return new ArrayList().iterator();
        }
        final int nbin = this.valueMap_.size();
        final int[] binIndices = new int[nbin];
        int ib = 0;
        for (Integer index : this.valueMap_.keySet()) {
            binIndices[ib++] = index;
        }
        assert (ib == nbin);
        Arrays.sort(binIndices);
        final double[] binValues = new double[nbin];
        double total = 0.0;
        double max = 0.0;
        for (int ib2 = 0; ib2 < nbin; ++ib2) {
            double bv;
            int jb = cumul.isReverse() ? nbin - ib2 - 1 : ib2;
            double value = this.valueMap_.get(binIndices[jb]).getCombinedValue();
            switch (cumul) {
                case NONE: {
                    bv = value;
                    break;
                }
                case FORWARD: {
                    bv = total + value;
                    break;
                }
                case REVERSE: {
                    bv = total;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            binValues[jb] = bv;
            total += value;
            max = Math.max(max, Math.abs(value));
        }
        double bw = this.binWidth_ / unit.getExtent();
        double scale = norm.getScaleFactor(total, max, bw, this.combiner_.getType(), cumul.isCumulative());
        if (scale != 1.0) {
            int ib3 = 0;
            while (ib3 < nbin) {
                int n = ib3++;
                binValues[n] = binValues[n] * scale;
            }
        }
        final double stotal = scale * total;
        if (cumul.isCumulative()) {
            int ixlo = binIndices[0];
            int ixhi = binIndices[nbin - 1];
            if (range != null) {
                ixlo = Math.min(ixlo, this.mapper_.getBinIndex(range[0]) - 1);
                ixhi = Math.max(ixhi, this.mapper_.getBinIndex(range[1]) + 1);
            }
            final int ixMin = ixlo;
            final int ixMax = ixhi;
            return new Iterator<Bin>(){
                int index;
                int ib;
                {
                    this.index = ixMin;
                    this.ib = this.index < binIndices[0] ? -1 : 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < ixMax;
                }

                @Override
                public Bin next() {
                    double value = this.ib < 0 ? (cumul.isReverse() ? stotal : 0.0) : (this.ib >= nbin ? (cumul.isReverse() ? 0.0 : binValues[nbin - 1]) : binValues[this.ib]);
                    ++this.index;
                    if (this.ib == nbin - 1 || this.ib < nbin - 1 && this.index == binIndices[this.ib + 1]) {
                        ++this.ib;
                    }
                    return BinBag.this.createBin(this.index, value);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<Bin>(){
            int ib = 0;

            @Override
            public boolean hasNext() {
                return this.ib < nbin;
            }

            @Override
            public Bin next() {
                if (this.ib < nbin) {
                    Bin bin = BinBag.this.createBin(binIndices[this.ib], binValues[this.ib]);
                    ++this.ib;
                    return bin;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<double[]> barIterator(double lo, double hi) {
        final int ibin0 = this.mapper_.getBinIndex(lo);
        final int ibin1 = this.mapper_.getBinIndex(hi);
        return new Iterator<double[]>(){
            int ib;
            {
                this.ib = ibin0;
            }

            @Override
            public boolean hasNext() {
                return this.ib <= ibin1;
            }

            @Override
            public double[] next() {
                if (this.ib <= ibin1) {
                    return BinBag.this.mapper_.getBinLimits(this.ib++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public double getBinWidth() {
        return this.binWidth_;
    }

    public Combiner getCombiner() {
        return this.combiner_;
    }

    public int getBinCount() {
        return this.valueMap_.size();
    }

    public void add(BinBag other) {
        for (Map.Entry<Integer, Combiner.Container> entry : other.valueMap_.entrySet()) {
            Integer key = entry.getKey();
            Combiner.Container otherContainer = entry.getValue();
            Combiner.Container thisContainer = this.valueMap_.get(key);
            if (thisContainer == null) {
                this.valueMap_.put(key, otherContainer);
                continue;
            }
            thisContainer.add(otherContainer);
        }
    }

    public boolean matches(Scale scale, double binWidth, double binPhase, Combiner combiner) {
        return scale.equals(this.scale_) && binWidth == this.binWidth_ && binPhase == this.binPhase_ && combiner.equals(this.combiner_);
    }

    private Bin createBin(int binIndex, final double binValue) {
        final double[] limits = this.mapper_.getBinLimits(binIndex);
        return new Bin(){

            @Override
            public double getXMin() {
                return limits[0];
            }

            @Override
            public double getXMax() {
                return limits[1];
            }

            @Override
            public double getY() {
                return binValue;
            }

            public String toString() {
                return limits[0] + ".." + limits[1] + ": " + binValue;
            }
        };
    }

    public static interface Bin {
        public double getXMin();

        public double getXMax();

        public double getY();
    }
}

