/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.Scale;

@Equality
public class BinMapper {
    private final Scale scale_;
    private final double swidth_;
    private final double sfloor_;
    private final double swidth1_;

    public BinMapper(Scale scale, double scaleWidth, double binPhase, double dpoint) {
        this.scale_ = scale;
        this.swidth_ = scaleWidth;
        this.swidth1_ = 1.0 / this.swidth_;
        if (binPhase > 1.0) {
            binPhase %= 1.0;
        }
        if (binPhase < 0.0) {
            binPhase += 1.0;
        }
        double spoint = scale.dataToScale(dpoint);
        double f0 = Math.floor(spoint * this.swidth1_);
        this.sfloor_ = (f0 + binPhase) * this.swidth_;
        assert ((float)Math.abs(this.sfloor_ - spoint) <= (float)this.swidth_);
    }

    public int getBinIndex(double dvalue) {
        double svalue = this.scale_.dataToScale(dvalue);
        return (int)Math.floor((svalue - this.sfloor_) * this.swidth1_);
    }

    public double[] getBinLimits(int index) {
        double slo = this.sfloor_ + (double)index * this.swidth_;
        return new double[]{this.scale_.scaleToData(slo), this.scale_.scaleToData(slo + this.swidth_)};
    }

    public int hashCode() {
        int code = 55289;
        code = 23 * code + this.scale_.hashCode();
        code = 23 * code + Float.floatToIntBits((float)this.swidth_);
        code = 23 * code + Float.floatToIntBits((float)this.sfloor_);
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof BinMapper) {
            BinMapper other = (BinMapper)o;
            return this.scale_.equals(other.scale_) && this.swidth_ == other.swidth_ && this.sfloor_ == other.sfloor_;
        }
        return false;
    }
}

