/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.util.function.DoubleFunction;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot2.layer.BinList;

public class BinResultColumnData<T>
extends ColumnData {
    private final BinList.Result binResult_;
    private final double binFactor_;
    private final DoubleFunction<T> typedValue_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.layer");

    BinResultColumnData(ValueInfo info, BinList.Result binResult, double binFactor, DoubleFunction<T> typedValue) {
        super(info);
        this.binResult_ = binResult;
        this.binFactor_ = binFactor;
        this.typedValue_ = typedValue;
    }

    public T readValue(long irow) {
        double dval = this.binResult_.getBinValue(irow) * this.binFactor_;
        return Double.isNaN(dval) ? null : (T)this.typedValue_.apply(dval);
    }

    public static BinResultColumnData<?> createInstance(ValueInfo info, BinList.Result binResult, double binFactor) {
        Class clazz = info.getContentClass();
        if (Byte.class.equals((Object)clazz)) {
            return new BinResultColumnData<Byte>(info, binResult, binFactor, dval -> (byte)dval);
        }
        if (Short.class.equals((Object)clazz)) {
            return new BinResultColumnData<Short>(info, binResult, binFactor, dval -> (short)dval);
        }
        if (Integer.class.equals((Object)clazz)) {
            return new BinResultColumnData<Integer>(info, binResult, binFactor, dval -> (int)dval);
        }
        if (Long.class.equals((Object)clazz)) {
            return new BinResultColumnData<Long>(info, binResult, binFactor, dval -> (long)dval);
        }
        if (Float.class.equals((Object)clazz)) {
            return new BinResultColumnData<Float>(info, binResult, binFactor, dval -> Float.valueOf((float)dval));
        }
        if (Double.class.equals((Object)clazz)) {
            return new BinResultColumnData<Double>(info, binResult, binFactor, dval -> dval);
        }
        logger_.warning("Surprising data type: " + clazz + "; can't create ColumnData");
        return null;
    }
}

