/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.AreaCoord;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.geom.PlaneDataGeom;
import uk.ac.starlink.ttools.plot2.geom.SkyDataGeom;
import uk.ac.starlink.ttools.plot2.geom.SphereDataGeom;
import uk.ac.starlink.ttools.plot2.layer.AreaForm;
import uk.ac.starlink.ttools.plot2.layer.MarkForm;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapeStyle;

public class CentralForm<DG extends DataGeom>
implements ShapeForm {
    private final AreaCoord<DG> areaCoord_;
    private final Coord[] otherCoords_;
    public static final CentralForm<PlaneDataGeom> PLANE_INSTANCE = new CentralForm<PlaneDataGeom>(AreaCoord.PLANE_COORD, new Coord[0]);
    public static final CentralForm<SkyDataGeom> SKY_INSTANCE = new CentralForm<SkyDataGeom>(AreaCoord.SKY_COORD, new Coord[0]);
    public static final CentralForm<SphereDataGeom> SPHERE_INSTANCE = new CentralForm<SphereDataGeom>(AreaCoord.SPHERE_COORD, new Coord[]{AreaForm.RADIAL_COORD});

    private CentralForm(AreaCoord<DG> areaCoord, Coord[] otherCoords) {
        this.areaCoord_ = areaCoord;
        this.otherCoords_ = otherCoords;
    }

    @Override
    public String getFormName() {
        return "Central";
    }

    @Override
    public Icon getFormIcon() {
        return ResourceIcon.FORM_MARK;
    }

    @Override
    public String getFormDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots the nominal central point of an area.", "This appears just like a normal marker plot,", "but can be used when the available geometry information", "is an area description", "(such as an STC-S string or an array of polygon vertices)", "rather than coordinate values such as an X,Y pair.", "The position plotted is the nominal center of the shape", "as determined by the plotting code;", "that may or may not correspond to the actual center.", "</p>"});
    }

    @Override
    public int getBasicPositionCount() {
        return 0;
    }

    @Override
    public Coord[] getExtraCoords() {
        return PlotUtil.arrayConcat(new Coord[]{this.areaCoord_}, this.otherCoords_);
    }

    @Override
    public int getExtraPositionCount() {
        return 1;
    }

    @Override
    public ConfigKey<?>[] getConfigKeys() {
        return new ConfigKey[]{StyleKeys.MARKER_SHAPE, StyleKeys.SIZE};
    }

    @Override
    public DataGeom adjustGeom(DataGeom geom, DataSpec dataSpec, ShapeStyle style) {
        DataGeom tgeom = geom;
        return this.areaCoord_.getAreaDataGeom(tgeom);
    }

    @Override
    public Outliner createOutliner(ConfigMap config) {
        MarkerShape shape = config.get(StyleKeys.MARKER_SHAPE);
        int size = config.get(StyleKeys.SIZE);
        return MarkForm.createMarkOutliner(shape, size);
    }
}

