/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.util.Arrays;
import java.util.BitSet;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.layer.ArrayBinList;
import uk.ac.starlink.ttools.plot2.layer.QuantileCombiner;
import uk.ac.starlink.ttools.plot2.layer.Unit;

@Equality
public abstract class Combiner {
    private final String name_;
    private final String description_;
    private final Type type_;
    private final boolean hasBigBin_;
    public static final Combiner COUNT;
    public static final Combiner DENSITY;
    public static final Combiner SUM;
    public static final Combiner WEIGHTED_DENSITY;
    public static final Combiner MEAN;
    public static final Combiner MEDIAN;
    public static final Combiner Q1;
    public static final Combiner Q3;
    public static final Combiner SAMPLE_STDEV;
    public static final Combiner POP_STDEV;
    public static final Combiner MIN;
    public static final Combiner MAX;
    public static final Combiner HIT;
    private static final Combiner[] COMBINERS;
    public static final Combiner Q01;
    public static final Combiner Q99;

    protected Combiner(String name, String description, Type type, boolean hasBigBin) {
        this.name_ = name;
        this.description_ = description;
        this.type_ = type;
        this.hasBigBin_ = hasBigBin;
    }

    public abstract Container createContainer();

    public abstract ArrayBinList createArrayBinList(int var1);

    public String getName() {
        return this.name_;
    }

    public String getDescription() {
        return this.description_;
    }

    public Type getType() {
        return this.type_;
    }

    public boolean hasBigBin() {
        return this.hasBigBin_;
    }

    public abstract ValueInfo createCombinedInfo(ValueInfo var1, Unit var2);

    public String toString() {
        return this.name_;
    }

    public static Combiner[] getKnownCombiners() {
        return (Combiner[])COMBINERS.clone();
    }

    private static String getInfoDescription(ValueInfo info) {
        String descrip = info.getDescription();
        return descrip != null && descrip.trim().length() > 0 ? descrip : info.getName();
    }

    private static String modifyUcd(String ucd, String word, boolean isPrimary) {
        if (isPrimary) {
            return word;
        }
        if (ucd == null || ucd.trim().length() == 0) {
            return ucd;
        }
        return ucd + ";" + word;
    }

    public static Combiner createQuantileCombiner(String name, final String descrip, final double quantile) {
        String description = (descrip == null ? "value below which " + quantile + " of the values fall" : descrip + " of the values") + " (may be slow)";
        QuantileCombiner.Quantiler quantiler = new QuantileCombiner.Quantiler(){

            @Override
            public double calculateValue(double[] sorted) {
                int nv = sorted.length;
                if (nv > 1) {
                    double dpos = quantile * (double)(nv - 1);
                    int ipos = (int)dpos;
                    double frac = dpos - (double)ipos;
                    double value = sorted[ipos];
                    if (frac > 0.0) {
                        value += frac * (sorted[ipos + 1] - sorted[ipos]);
                    }
                    return value;
                }
                if (nv == 1) {
                    return sorted[0];
                }
                assert (nv == 0);
                return Double.NaN;
            }
        };
        return new QuantileCombiner(name, descrip, quantiler){

            @Override
            public ValueInfo createCombinedInfo(ValueInfo dataInfo, Unit scaleUnit) {
                DefaultValueInfo info = new DefaultValueInfo(dataInfo);
                info.setContentClass(Double.class);
                info.setDescription(Combiner.getInfoDescription(dataInfo) + ", " + (descrip == null ? quantile + " quantile" : descrip));
                if (quantile == 0.5) {
                    info.setUCD(Combiner.modifyUcd(dataInfo.getUCD(), "stat.median", false));
                }
                return info;
            }
        };
    }

    static {
        SUM = new SumCombiner();
        WEIGHTED_DENSITY = new WeightedDensityCombiner();
        COUNT = new CountCombiner();
        DENSITY = new DensityCombiner();
        MEAN = new MeanCombiner();
        MEDIAN = Combiner.createQuantileCombiner("median", "the median", 0.5);
        COMBINERS = new Combiner[]{SUM, WEIGHTED_DENSITY, COUNT, DENSITY, MEAN, MEDIAN, Q1 = Combiner.createQuantileCombiner("Q1", "first quartile", 0.25), Q3 = Combiner.createQuantileCombiner("Q3", "third quartile", 0.75), MIN = new MinCombiner(), MAX = new MaxCombiner(), SAMPLE_STDEV = new StdevCombiner(true), POP_STDEV = new StdevCombiner(false), HIT = new HitCombiner()};
        Q01 = Combiner.createQuantileCombiner("Q.01", "1st percentile", 0.01);
        Q99 = Combiner.createQuantileCombiner("Q.99", "99th percentile", 0.99);
    }

    private static class HitCombiner
    extends Combiner {
        HitCombiner() {
            super("hit", "1 if any values present, NaN otherwise (weight is ignored)", Type.EXTENSIVE, false);
        }

        @Override
        public ArrayBinList createArrayBinList(int size) {
            return new HitBinList(size, this);
        }

        @Override
        public Container createContainer() {
            return new HitContainer();
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo dataInfo, Unit scaleUnit) {
            return new DefaultValueInfo("hit", Short.class, "1 if bin contains data, 0 if not");
        }

        private static class HitContainer
        implements Container {
            boolean hit_;

            private HitContainer() {
            }

            @Override
            public void submit(double datum) {
                this.hit_ = true;
            }

            @Override
            public void add(Container other) {
                boolean otherHit = ((HitContainer)other).hit_;
                if (otherHit) {
                    this.hit_ = true;
                }
            }

            @Override
            public double getCombinedValue() {
                return this.hit_ ? 1.0 : Double.NaN;
            }
        }

        private static class HitBinList
        extends ArrayBinList {
            final BitSet mask_ = new BitSet();

            HitBinList(int size, HitCombiner combiner) {
                super(size, combiner);
            }

            @Override
            public void submitToBinInt(int index, double datum) {
                this.mask_.set(index);
            }

            @Override
            public double getBinResultInt(int index) {
                return this.mask_.get(index) ? 1.0 : Double.NaN;
            }

            @Override
            public void copyBin(int index, Container bin) {
                HitContainer container = (HitContainer)bin;
                this.mask_.set(index, container.hit_);
            }

            @Override
            public void addBin(int index, ArrayBinList other) {
                if (((HitBinList)other).mask_.get(index)) {
                    this.mask_.set(index);
                }
            }
        }
    }

    private static class MaxCombiner
    extends Combiner {
        private static double combineMax(double oldValue, double datum) {
            return Double.isNaN(oldValue) ? datum : Math.max(oldValue, datum);
        }

        MaxCombiner() {
            super("max", "the maximum of all the combined values", Type.INTENSIVE, false);
        }

        @Override
        public ArrayBinList createArrayBinList(int size) {
            return new MaxBinList(size, this);
        }

        @Override
        public Container createContainer() {
            return new MaxContainer();
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo dataInfo, Unit scaleUnit) {
            DefaultValueInfo info = new DefaultValueInfo(dataInfo.getName() + "_max", dataInfo.getContentClass(), Combiner.getInfoDescription(dataInfo) + ", maximum value in bin");
            info.setUnitString(dataInfo.getUnitString());
            info.setUCD(Combiner.modifyUcd(dataInfo.getUCD(), "stat.max", false));
            return info;
        }

        private static class MaxContainer
        implements Container {
            private double max_ = Double.NaN;

            private MaxContainer() {
            }

            @Override
            public void submit(double datum) {
                this.max_ = MaxCombiner.combineMax(this.max_, datum);
            }

            @Override
            public void add(Container other) {
                double otherMax = ((MaxContainer)other).max_;
                if (!Double.isNaN(otherMax)) {
                    this.max_ = MaxCombiner.combineMax(this.max_, otherMax);
                }
            }

            @Override
            public double getCombinedValue() {
                return this.max_;
            }
        }

        private static class MaxBinList
        extends ArrayBinList {
            final double[] maxs_;

            MaxBinList(int size, MaxCombiner combiner) {
                super(size, combiner);
                this.maxs_ = new double[size];
                Arrays.fill(this.maxs_, Double.NaN);
            }

            @Override
            public void submitToBinInt(int index, double datum) {
                this.maxs_[index] = MaxCombiner.combineMax(this.maxs_[index], datum);
            }

            @Override
            public double getBinResultInt(int index) {
                return this.maxs_[index];
            }

            @Override
            public void copyBin(int index, Container bin) {
                MaxContainer container = (MaxContainer)bin;
                this.maxs_[index] = container.max_;
            }

            @Override
            public void addBin(int index, ArrayBinList other) {
                double otherMax = ((MaxBinList)other).maxs_[index];
                if (!Double.isNaN(otherMax)) {
                    this.maxs_[index] = MaxCombiner.combineMax(this.maxs_[index], otherMax);
                }
            }
        }
    }

    private static class MinCombiner
    extends Combiner {
        private static double combineMin(double oldValue, double datum) {
            return Double.isNaN(oldValue) ? datum : Math.min(oldValue, datum);
        }

        MinCombiner() {
            super("min", "the minimum of all the combined values", Type.INTENSIVE, false);
        }

        @Override
        public ArrayBinList createArrayBinList(int size) {
            return new MinBinList(size, this);
        }

        @Override
        public Container createContainer() {
            return new MinContainer();
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo dataInfo, Unit scaleUnit) {
            DefaultValueInfo info = new DefaultValueInfo(dataInfo.getName() + "_min", dataInfo.getContentClass(), Combiner.getInfoDescription(dataInfo) + ", minimum value in bin");
            info.setUnitString(dataInfo.getUnitString());
            info.setUCD(Combiner.modifyUcd(dataInfo.getUCD(), "stat.min", false));
            return info;
        }

        private static class MinContainer
        implements Container {
            private double min_ = Double.NaN;

            private MinContainer() {
            }

            @Override
            public void submit(double datum) {
                this.min_ = MinCombiner.combineMin(this.min_, datum);
            }

            @Override
            public void add(Container other) {
                double otherMin = ((MinContainer)other).min_;
                if (!Double.isNaN(otherMin)) {
                    this.min_ = MinCombiner.combineMin(this.min_, otherMin);
                }
            }

            @Override
            public double getCombinedValue() {
                return this.min_;
            }
        }

        private static class MinBinList
        extends ArrayBinList {
            final double[] mins_;

            MinBinList(int size, MinCombiner combiner) {
                super(size, combiner);
                this.mins_ = new double[size];
                Arrays.fill(this.mins_, Double.NaN);
            }

            @Override
            public void submitToBinInt(int index, double datum) {
                this.mins_[index] = MinCombiner.combineMin(this.mins_[index], datum);
            }

            @Override
            public double getBinResultInt(int index) {
                return this.mins_[index];
            }

            @Override
            public void copyBin(int index, Container bin) {
                MinContainer container = (MinContainer)bin;
                this.mins_[index] = container.min_;
            }

            @Override
            public void addBin(int index, ArrayBinList other) {
                double otherMin = ((MinBinList)other).mins_[index];
                if (!Double.isNaN(otherMin)) {
                    this.mins_[index] = MinCombiner.combineMin(this.mins_[index], otherMin);
                }
            }
        }
    }

    private static class WeightedDensityCombiner
    extends AbstractSumCombiner {
        WeightedDensityCombiner() {
            super("sum-per-unit", "the sum of all the combined values per unit of bin size", Type.DENSITY);
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo dataInfo, Unit scaleUnit) {
            DefaultValueInfo info = new DefaultValueInfo(dataInfo.getName() + "_density", Double.class, Combiner.getInfoDescription(dataInfo) + ", density per " + scaleUnit.getTextName());
            String inUnit = dataInfo.getUnitString();
            if (inUnit == null || inUnit.trim().length() == 0) {
                inUnit = "1";
            }
            info.setUnitString(inUnit + "/" + scaleUnit.getSymbol());
            return info;
        }
    }

    private static class SumCombiner
    extends AbstractSumCombiner {
        SumCombiner() {
            super("sum", "the sum of all the combined values per bin", Type.EXTENSIVE);
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo dataInfo, Unit scaleUnit) {
            DefaultValueInfo info = new DefaultValueInfo(dataInfo.getName() + "_sum", Double.class, Combiner.getInfoDescription(dataInfo) + ", sum in bin");
            info.setUnitString(dataInfo.getUnitString());
            info.setUCD(Combiner.modifyUcd(dataInfo.getUCD(), "arith.sum", false));
            return info;
        }
    }

    private static abstract class AbstractSumCombiner
    extends Combiner {
        private static double combineSum(double oldValue, double datum) {
            return Double.isNaN(oldValue) ? datum : oldValue + datum;
        }

        AbstractSumCombiner(String name, String descrip, Type type) {
            super(name, descrip, type, false);
        }

        @Override
        public ArrayBinList createArrayBinList(int size) {
            return new AbstractSumBinList(size, this);
        }

        @Override
        public Container createContainer() {
            return new SumContainer();
        }

        private static class SumContainer
        implements Container {
            double sum_ = Double.NaN;

            private SumContainer() {
            }

            @Override
            public void submit(double datum) {
                this.sum_ = AbstractSumCombiner.combineSum(this.sum_, datum);
            }

            @Override
            public void add(Container other) {
                double otherSum = ((SumContainer)other).sum_;
                if (!Double.isNaN(otherSum)) {
                    this.sum_ = AbstractSumCombiner.combineSum(this.sum_, otherSum);
                }
            }

            @Override
            public double getCombinedValue() {
                return this.sum_;
            }
        }

        static class AbstractSumBinList
        extends ArrayBinList {
            final double[] sums_;

            AbstractSumBinList(int size, AbstractSumCombiner combiner) {
                super(size, combiner);
                this.sums_ = new double[size];
                Arrays.fill(this.sums_, Double.NaN);
            }

            @Override
            public void submitToBinInt(int index, double datum) {
                this.sums_[index] = AbstractSumCombiner.combineSum(this.sums_[index], datum);
            }

            @Override
            public double getBinResultInt(int index) {
                return this.sums_[index];
            }

            @Override
            public void copyBin(int index, Container bin) {
                SumContainer container = (SumContainer)bin;
                this.sums_[index] = container.sum_;
            }

            @Override
            public void addBin(int index, ArrayBinList other) {
                double otherSum = ((AbstractSumBinList)other).sums_[index];
                if (!Double.isNaN(otherSum)) {
                    this.sums_[index] = AbstractSumCombiner.combineSum(this.sums_[index], otherSum);
                }
            }
        }
    }

    private static class DensityCombiner
    extends AbstractCountCombiner {
        DensityCombiner() {
            super("count-per-unit", "the number of non-blank values per unit of bin size (weight is ignored)", Type.DENSITY);
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo inInfo, Unit scaleUnit) {
            DefaultValueInfo outInfo = new DefaultValueInfo("density", Double.class, "Number of items counted per " + scaleUnit.getTextName());
            outInfo.setUCD("src.density");
            outInfo.setUnitString("1/" + scaleUnit.getSymbol());
            return outInfo;
        }
    }

    private static class CountCombiner
    extends AbstractCountCombiner {
        CountCombiner() {
            super("count", "the number of non-blank values per bin (weight is ignored)", Type.EXTENSIVE);
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo inInfo, Unit scaleUnit) {
            DefaultValueInfo outInfo = new DefaultValueInfo("count", Integer.class, "Number of items counted per bin");
            outInfo.setUCD("meta.number");
            return outInfo;
        }
    }

    private static abstract class AbstractCountCombiner
    extends Combiner {
        AbstractCountCombiner(String name, String descrip, Type type) {
            super(name, descrip, type, false);
        }

        @Override
        public ArrayBinList createArrayBinList(int size) {
            return new AbstractCountBinList(size, this);
        }

        @Override
        public Container createContainer() {
            return new CountContainer();
        }

        private static class CountContainer
        implements Container {
            int count_;

            private CountContainer() {
            }

            @Override
            public void submit(double datum) {
                ++this.count_;
            }

            @Override
            public void add(Container other) {
                CountContainer countOther = (CountContainer)other;
                this.count_ += countOther.count_;
            }

            @Override
            public double getCombinedValue() {
                return this.count_ == 0 ? Double.NaN : (double)this.count_;
            }
        }

        static class AbstractCountBinList
        extends ArrayBinList {
            final int[] counts_;

            AbstractCountBinList(int size, AbstractCountCombiner combiner) {
                super(size, combiner);
                this.counts_ = new int[size];
            }

            @Override
            public void submitToBinInt(int index, double value) {
                int n = index;
                this.counts_[n] = this.counts_[n] + 1;
            }

            @Override
            public double getBinResultInt(int index) {
                int count = this.counts_[index];
                return count == 0 ? Double.NaN : (double)count;
            }

            @Override
            public void copyBin(int index, Container bin) {
                CountContainer container = (CountContainer)bin;
                this.counts_[index] = container.count_;
            }

            @Override
            public void addBin(int index, ArrayBinList other) {
                AbstractCountBinList countOther = (AbstractCountBinList)other;
                int n = index;
                this.counts_[n] = this.counts_[n] + countOther.counts_[index];
            }
        }
    }

    private static class StdevCombiner
    extends Combiner {
        private final boolean isSampleStdev_;

        public StdevCombiner(boolean isSampleStdev) {
            super(isSampleStdev ? "stdev" : "stdev_pop", "the " + (isSampleStdev ? "sample" : "population") + " standard deviation of the combined values", Type.INTENSIVE, true);
            this.isSampleStdev_ = isSampleStdev;
        }

        @Override
        public ArrayBinList createArrayBinList(int size) {
            return new StdevBinList(size, this);
        }

        @Override
        public Container createContainer() {
            return this.isSampleStdev_ ? new SampleStdevContainer() : new PopulationStdevContainer();
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo dataInfo, Unit scaleUnit) {
            DefaultValueInfo info = new DefaultValueInfo(dataInfo.getName() + "_stdev", Double.class, (this.isSampleStdev_ ? "Sample " : "Population ") + "standard deviation of " + Combiner.getInfoDescription(dataInfo));
            info.setUnitString(dataInfo.getUnitString());
            info.setUCD(Combiner.modifyUcd(dataInfo.getUCD(), "stat.stdev", true));
            return info;
        }

        private static double getStdev(boolean isSampleStdev, int count, double sum1, double sum2) {
            if (count < (isSampleStdev ? 2 : 1)) {
                return Double.NaN;
            }
            double dcount = count;
            double nvar = sum2 - sum1 * sum1 / dcount;
            double divisor = isSampleStdev ? dcount - 1.0 : dcount;
            return Math.sqrt(nvar / divisor);
        }

        private static class SampleStdevContainer
        extends StdevContainer {
            private SampleStdevContainer() {
            }

            @Override
            public double getCombinedValue() {
                return StdevCombiner.getStdev(true, this.count_, this.sum1_, this.sum2_);
            }
        }

        private static class PopulationStdevContainer
        extends StdevContainer {
            private PopulationStdevContainer() {
            }

            @Override
            public double getCombinedValue() {
                return StdevCombiner.getStdev(false, this.count_, this.sum1_, this.sum2_);
            }
        }

        private static abstract class StdevContainer
        implements Container {
            int count_;
            double sum1_;
            double sum2_;

            private StdevContainer() {
            }

            @Override
            public void submit(double datum) {
                ++this.count_;
                this.sum1_ += datum;
                this.sum2_ += datum * datum;
            }

            @Override
            public void add(Container other) {
                StdevContainer stdevOther = (StdevContainer)other;
                this.count_ += stdevOther.count_;
                this.sum1_ += stdevOther.sum1_;
                this.sum2_ += stdevOther.sum2_;
            }
        }

        private static class StdevBinList
        extends ArrayBinList {
            final boolean isSampleStdev_;
            final int[] counts_;
            final double[] sum1s_;
            final double[] sum2s_;

            StdevBinList(int size, StdevCombiner combiner) {
                super(size, combiner);
                this.isSampleStdev_ = combiner.isSampleStdev_;
                this.counts_ = new int[size];
                this.sum1s_ = new double[size];
                this.sum2s_ = new double[size];
            }

            @Override
            public void submitToBinInt(int index, double value) {
                int n = index;
                this.counts_[n] = this.counts_[n] + 1;
                int n2 = index;
                this.sum1s_[n2] = this.sum1s_[n2] + value;
                int n3 = index;
                this.sum2s_[n3] = this.sum2s_[n3] + value * value;
            }

            @Override
            public double getBinResultInt(int index) {
                return StdevCombiner.getStdev(this.isSampleStdev_, this.counts_[index], this.sum1s_[index], this.sum2s_[index]);
            }

            @Override
            public void copyBin(int index, Container bin) {
                StdevContainer container = (StdevContainer)bin;
                this.counts_[index] = container.count_;
                this.sum1s_[index] = container.sum1_;
                this.sum2s_[index] = container.sum2_;
            }

            @Override
            public void addBin(int index, ArrayBinList other) {
                StdevBinList stdevOther = (StdevBinList)other;
                int n = index;
                this.counts_[n] = this.counts_[n] + stdevOther.counts_[index];
                int n2 = index;
                this.sum1s_[n2] = this.sum1s_[n2] + stdevOther.sum1s_[index];
                int n3 = index;
                this.sum2s_[n3] = this.sum2s_[n3] + stdevOther.sum2s_[index];
            }
        }
    }

    private static class MeanCombiner
    extends Combiner {
        public MeanCombiner() {
            super("mean", "the mean of the combined values", Type.INTENSIVE, true);
        }

        @Override
        public ArrayBinList createArrayBinList(int size) {
            return new MeanBinList(size, this);
        }

        @Override
        public Container createContainer() {
            return new MeanContainer();
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo dataInfo, Unit scaleUnit) {
            DefaultValueInfo info = new DefaultValueInfo(dataInfo);
            info.setContentClass(Double.class);
            info.setDescription(Combiner.getInfoDescription(dataInfo) + ", mean value in bin");
            info.setUCD(Combiner.modifyUcd(dataInfo.getUCD(), "stat.mean", false));
            return info;
        }

        private static class MeanContainer
        implements Container {
            int count_;
            double sum_;

            private MeanContainer() {
            }

            @Override
            public void submit(double datum) {
                ++this.count_;
                this.sum_ += datum;
            }

            @Override
            public void add(Container other) {
                MeanContainer meanOther = (MeanContainer)other;
                this.count_ += meanOther.count_;
                this.sum_ += meanOther.sum_;
            }

            @Override
            public double getCombinedValue() {
                return this.count_ == 0 ? Double.NaN : this.sum_ / (double)this.count_;
            }
        }

        private static class MeanBinList
        extends ArrayBinList {
            final int[] counts_;
            final double[] sums_;

            MeanBinList(int size, MeanCombiner combiner) {
                super(size, combiner);
                this.counts_ = new int[size];
                this.sums_ = new double[size];
            }

            @Override
            public void submitToBinInt(int index, double value) {
                int n = index;
                this.counts_[n] = this.counts_[n] + 1;
                int n2 = index;
                this.sums_[n2] = this.sums_[n2] + value;
            }

            @Override
            public double getBinResultInt(int index) {
                int count = this.counts_[index];
                return count == 0 ? Double.NaN : this.sums_[index] / (double)count;
            }

            @Override
            public void copyBin(int index, Container bin) {
                MeanContainer container = (MeanContainer)bin;
                this.counts_[index] = container.count_;
                this.sums_[index] = container.sum_;
            }

            @Override
            public void addBin(int index, ArrayBinList other) {
                MeanBinList meanOther = (MeanBinList)other;
                int n = index;
                this.counts_[n] = this.counts_[n] + meanOther.counts_[index];
                int n2 = index;
                this.sums_[n2] = this.sums_[n2] + meanOther.sums_[index];
            }
        }
    }

    public static interface Container {
        public void submit(double var1);

        public void add(Container var1);

        public double getCombinedValue();
    }

    public static enum Type {
        EXTENSIVE(true, false),
        INTENSIVE(false, false),
        DENSITY(true, true);

        private final boolean isExtensive_;
        private final boolean isScaling_;

        private Type(boolean isExtensive, boolean isScaling) {
            this.isExtensive_ = isExtensive;
            this.isScaling_ = isScaling;
        }

        public boolean isExtensive() {
            return this.isExtensive_;
        }

        public double getBinFactor(double binExtent) {
            return this.isScaling_ ? 1.0 / binExtent : 1.0;
        }
    }
}

